/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.firebirdsql.jdbc.FBSQLException;

public class CharacterTranslator {
    private char[] mapping = new char[65536];

    public CharacterTranslator() {
        for (int i2 = 0; i2 < this.mapping.length; ++i2) {
            this.mapping[i2] = (char)i2;
        }
    }

    public char[] getMapping() {
        return this.mapping;
    }

    public char getMapping(char toMap) {
        return this.mapping[toMap];
    }

    public void init(String mappingPath) throws SQLException {
        Properties props = new Properties();
        try {
            ResourceBundle res = ResourceBundle.getBundle(mappingPath, Locale.getDefault(), this.getClass().getClassLoader());
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = res.getString(key);
                props.put(key, value);
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                char javaChar;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.startsWith("db.")) {
                    throw new SQLException("Incorrect mapping format. All properties should start with \"db.\", but " + key + " found.");
                }
                if (key.length() != 4) {
                    throw new SQLException("Incorrect mapping format. Key should consist only of 4 characters, but " + key + " found.");
                }
                if (value.length() != 1) {
                    throw new SQLException("Incorrect mapping format. Mapped value should consist only of single character, but " + value + " found.");
                }
                char dbChar = key.charAt(3);
                this.mapping[dbChar] = javaChar = value.charAt(0);
                this.mapping[javaChar] = dbChar;
            }
        }
        catch (MissingResourceException ex) {
            throw new FBSQLException("Character translation " + mappingPath + " could not be found.");
        }
    }
}

