/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.firebirdsql.ds.AbstractPooledConnection;
import org.firebirdsql.ds.ReflectionHelper;
import org.firebirdsql.ds.StatementHandler;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.util.SQLExceptionChainBuilder;

class PooledConnectionHandler
implements InvocationHandler {
    protected static final String CLOSED_MESSAGE = "Logical connection already closed";
    protected static final String FORCIBLY_CLOSED_MESSAGE = "Logical connection was forcibly closed by the connection pool";
    protected final AbstractPooledConnection owner;
    protected volatile Connection connection;
    protected volatile Connection proxy;
    protected volatile boolean forcedClose;
    private final List openStatements = Collections.synchronizedList(new LinkedList());
    private static final Method CONNECTION_IS_CLOSED = ReflectionHelper.findMethod(Connection.class, "isClosed", new Class[0]);
    private static final Method CONNECTION_CLOSE = ReflectionHelper.findMethod(Connection.class, "close", new Class[0]);
    private static final Set STATEMENT_CREATION_METHOD_NAMES;
    private static final Method TO_STRING;
    private static final Method EQUALS;
    private static final Method HASH_CODE;

    protected PooledConnectionHandler(Connection connection, AbstractPooledConnection owner) {
        this.connection = connection;
        this.owner = owner;
        this.proxy = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), ReflectionHelper.getAllInterfaces(connection.getClass()), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(TO_STRING)) {
            return "Proxy for " + this.connection;
        }
        if (method.equals(EQUALS)) {
            return proxy == args[0];
        }
        if (method.equals(HASH_CODE)) {
            return System.identityHashCode(proxy);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            try {
                return method.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException e2) {
                throw e2.getTargetException();
            }
        }
        if (method.equals(CONNECTION_IS_CLOSED)) {
            return this.isClosed();
        }
        if (this.isClosed() && !method.equals(CONNECTION_CLOSE)) {
            String message = this.forcedClose ? FORCIBLY_CLOSED_MESSAGE : CLOSED_MESSAGE;
            throw new FBSQLException(message, "08003");
        }
        try {
            if (method.equals(CONNECTION_CLOSE)) {
                if (!this.isClosed()) {
                    this.handleClose(true);
                }
                return null;
            }
            if (method.getDeclaringClass().equals(Connection.class) && STATEMENT_CREATION_METHOD_NAMES.contains(method.getName())) {
                Statement pstmt = (Statement)method.invoke((Object)this.connection, args);
                StatementHandler stmtHandler = new StatementHandler(this, pstmt);
                this.openStatements.add(stmtHandler);
                return stmtHandler.getProxy();
            }
            return method.invoke((Object)this.connection, args);
        }
        catch (InvocationTargetException ite) {
            Throwable inner = ite.getTargetException();
            if (inner instanceof SQLException) {
                this.owner.fireConnectionError((SQLException)inner);
            }
            throw inner;
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    protected boolean isRollbackAllowed() throws SQLException {
        return !this.connection.getAutoCommit();
    }

    protected void handleClose(boolean notifyOwner) throws SQLException {
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        try {
            this.closeStatements();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
        if (this.isRollbackAllowed()) {
            try {
                this.connection.rollback();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
        this.proxy = null;
        this.connection = null;
        this.owner.releaseConnectionHandler(this);
        if (notifyOwner) {
            this.owner.fireConnectionClosed();
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    protected Connection getProxy() {
        return this.proxy;
    }

    protected void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.handleClose(false);
            }
            finally {
                this.forcedClose = true;
            }
        }
    }

    protected boolean isClosed() {
        return this.connection == null || this.proxy == null;
    }

    protected void statementErrorOccurred(StatementHandler stmtHandler, SQLException sqle) {
        this.owner.fireConnectionError(sqle);
    }

    protected void forgetStatement(StatementHandler stmtHandler) {
        this.openStatements.remove(stmtHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStatements() throws SQLException {
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        List list = this.openStatements;
        synchronized (list) {
            ArrayList statementsCopy = new ArrayList(this.openStatements);
            for (StatementHandler stmt : statementsCopy) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
                catch (Throwable t2) {}
            }
            this.openStatements.clear();
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("createStatement");
        temp.add("prepareCall");
        temp.add("prepareStatement");
        STATEMENT_CREATION_METHOD_NAMES = Collections.unmodifiableSet(temp);
        TO_STRING = ReflectionHelper.findMethod(Object.class, "toString", new Class[0]);
        EQUALS = ReflectionHelper.findMethod(Object.class, "equals", new Class[]{Object.class});
        HASH_CODE = ReflectionHelper.findMethod(Object.class, "hashCode", new Class[0]);
    }
}

