/*
 * Decompiled with CFR 0.152.
 */
package org.dsd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import load.file.MainApp;

public class DiscoverClient {
    private static final Logger a = Logger.getLogger(DiscoverClient.class.getName());

    public void main(String[] objectArray) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        objectArray = "DISCOVER_FUIFSERVER_REQUEST".getBytes();
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            Throwable throwable = null;
            try {
                datagramSocket.setBroadcast(true);
                datagramSocket.setSoTimeout(5000);
                ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (int i2 = 0; i2 < 4; ++i2) {
                    a.log(Level.INFO, "Iniciando intento de descubrimiento " + (i2 + 1) + "/4");
                    String[] stringArray = arrayList.iterator();
                    while (stringArray.hasNext()) {
                        NetworkInterface object;
                        NetworkInterface networkInterface = object = (NetworkInterface)stringArray.next();
                        DiscoverClient discoverClient = this;
                        networkInterface.getDisplayName().toLowerCase();
                        if (!(DiscoverClient.a(networkInterface) && networkInterface.isUp())) continue;
                        this.a(object, datagramSocket, (byte[])objectArray, 8888, i2 + 1);
                    }
                    try {
                        while (true) {
                            stringArray = (String[])new byte[2048];
                            DatagramPacket datagramPacket = new DatagramPacket((byte[])stringArray, 2048);
                            datagramSocket.receive(datagramPacket);
                            stringArray = new String(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength()).trim();
                            a.log(Level.INFO, "Broadcast response from server: " + datagramPacket.getAddress().getHostAddress() + " (Msg: " + (String)stringArray + ")");
                            if (!stringArray.contains("DISCOVER_FUIFSERVER_RESPONSE") && !stringArray.contains("DISCOVER_FUIFSERVER_SS_RESPONSE")) continue;
                            stringArray = stringArray.split("\\|");
                            String string = datagramPacket.getAddress().getHostAddress();
                            int n2 = MainApp.sbIP.stream().anyMatch(string2 -> string2.startsWith(string + "|"));
                            if (n2 != 0) continue;
                            StringBuilder stringBuilder = new StringBuilder(string).append("|").append(stringArray[MainApp.SCALE_NUMBER]).append("|").append(stringArray[MainApp.SCALE_CAPACITY]).append("|").append(stringArray[MainApp.SCALE_UNI_MEDI]).append("|").append(stringArray[MainApp.SCALE_NAME]).append("|").append(stringArray[MainApp.SCALE_ICON]);
                            n2 = stringArray.length;
                            if (n2 > 10) {
                                stringBuilder.append("|").append(stringArray[MainApp.SCALE_TYPE]).append("|").append(stringArray[MainApp.SCALE_VERSION]).append("|").append(stringArray[MainApp.SCALE_MAC_ETH]).append("|").append(stringArray[MainApp.SCALE_MAC_WIFI]).append("|").append(stringArray[MainApp.SCALE_STRENGTH_WIFI]).append("|").append(stringArray[MainApp.SCALE_PING_LATENCY]);
                            } else if (n2 > 7) {
                                stringBuilder.append("|").append(stringArray[MainApp.SCALE_TYPE]).append("|").append(stringArray[MainApp.SCALE_VERSION]).append("|").append(stringArray[MainApp.SCALE_MAC_ETH]).append("|").append(stringArray[MainApp.SCALE_MAC_WIFI]);
                            } else if (n2 > 6) {
                                stringBuilder.append("|").append(stringArray[MainApp.SCALE_TYPE]);
                            } else {
                                stringBuilder.append("|");
                            }
                            MainApp.sbIP.add(stringBuilder.toString());
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        a.log(Level.INFO, "Timeout de recepci\u00f3n. Intentando de nuevo...");
                        continue;
                    }
                    catch (Exception exception) {
                        a.log(Level.INFO, "Exception: " + exception);
                    }
                }
                datagramSocket.close();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            datagramSocket.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        datagramSocket.close();
                    }
                    throw throwable4;
                }
            }
        }
        catch (IOException iOException) {
            a.log(Level.SEVERE, "Error de I/O en el socket:", iOException);
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Error Exception:", exception);
        }
        a.log(Level.INFO, "Finalizado el descubrimiento. Dispositivos encontrados: " + MainApp.sbIP.size());
    }

    private void a(NetworkInterface networkInterface, DatagramSocket datagramSocket, byte[] byArray, int n2, int n3) {
        try {
            if (!DiscoverClient.a(networkInterface) || !networkInterface.isUp()) {
                return;
            }
            for (InterfaceAddress unknownHostException : networkInterface.getInterfaceAddresses()) {
                InetAddress inetAddress = unknownHostException.getBroadcast();
                if (inetAddress == null) {
                    try {
                        inetAddress = InetAddress.getByAddress(new byte[]{-1, -1, -1, -1});
                    }
                    catch (UnknownHostException unknownHostException2) {
                        a.log(Level.SEVERE, "Error creating broadcast address: ", unknownHostException2);
                        continue;
                    }
                }
                if (unknownHostException.getAddress().toString().contains(":") || networkInterface.getDisplayName().toLowerCase().contains("radmin")) continue;
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 8888);
                datagramSocket.send(datagramPacket);
                a.log(Level.INFO, "Broadcast SEND: " + datagramPacket.getAddress().getHostAddress() + " (Attempt " + n3 + ") - Interface: " + networkInterface.getDisplayName());
            }
            return;
        }
        catch (SocketException socketException) {
            a.log(Level.SEVERE, "Socket error when processing interface " + networkInterface.getDisplayName(), socketException);
            return;
        }
        catch (IOException iOException) {
            a.log(Level.SEVERE, "I/O error sending discovery packet", iOException);
            return;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Exception error sending discovery packet", exception);
            return;
        }
    }

    private static boolean a(NetworkInterface networkInterface) {
        return !networkInterface.isLoopback() && !networkInterface.isVirtual();
    }
}

