/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.tsp.ers.SortedHashList;
import org.bouncycastle.util.Arrays;

public class BinaryTreeRootCalculator
implements ERSRootNodeCalculator {
    private List<List<byte[]>> tree;

    public byte[] computeRootHash(DigestCalculator digestCalculator, PartialHashtree[] partialHashtreeArray) {
        Object object;
        SortedHashList sortedHashList = new SortedHashList();
        for (int i2 = 0; i2 < partialHashtreeArray.length; ++i2) {
            object = ERSUtil.computeNodeHash(digestCalculator, partialHashtreeArray[i2]);
            sortedHashList.add((byte[])object);
        }
        Object object2 = sortedHashList.toList();
        this.tree = new ArrayList<List<byte[]>>();
        this.tree.add((List<byte[]>)object2);
        if (object2.size() > 1) {
            do {
                object = new ArrayList(object2.size() / 2 + 1);
                for (int i3 = 0; i3 <= object2.size() - 2; i3 += 2) {
                    object.add(ERSUtil.calculateBranchHash(digestCalculator, object2.get(i3), object2.get(i3 + 1)));
                }
                if (object2.size() % 2 == 1) {
                    object.add(object2.get(object2.size() - 1));
                }
                this.tree.add((List<byte[]>)object);
            } while ((object2 = (Object)object).size() > 1);
        }
        return object2.get(0);
    }

    public PartialHashtree[] computePathToRoot(DigestCalculator digestCalculator, PartialHashtree partialHashtree, int n2) {
        ArrayList<PartialHashtree> arrayList = new ArrayList<PartialHashtree>();
        byte[] byArray = ERSUtil.computeNodeHash(digestCalculator, partialHashtree);
        arrayList.add(partialHashtree);
        for (int i2 = 0; i2 < this.tree.size() - 1; ++i2) {
            Object object;
            if (n2 == this.tree.get(i2).size() - 1) {
                while (Arrays.areEqual(byArray, (object = this.tree.get(i2 + 1)).get(object.size() - 1))) {
                    n2 = this.tree.get(++i2).size() - 1;
                }
            }
            object = (n2 & 1) == 0 ? (Object)this.tree.get(i2).get(n2 + 1) : (Object)this.tree.get(i2).get(n2 - 1);
            arrayList.add(new PartialHashtree((byte[])object));
            byArray = ERSUtil.calculateBranchHash(digestCalculator, byArray, (byte[])object);
            n2 /= 2;
        }
        return arrayList.toArray(new PartialHashtree[0]);
    }

    public byte[] recoverRootHash(DigestCalculator digestCalculator, PartialHashtree[] partialHashtreeArray) {
        byte[] byArray = ERSUtil.computeNodeHash(digestCalculator, partialHashtreeArray[0]);
        for (int i2 = 1; i2 < partialHashtreeArray.length; ++i2) {
            byArray = ERSUtil.calculateBranchHash(digestCalculator, byArray, ERSUtil.computeNodeHash(digestCalculator, partialHashtreeArray[i2]));
        }
        return byArray;
    }
}

