/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer.its.ieee1609dot2.basetypes;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.oer.its.ieee1609dot2.Opaque;
import org.bouncycastle.oer.its.ieee1609dot2.basetypes.BitmapSsp;

public class ServiceSpecificPermissions
extends ASN1Object
implements ASN1Choice {
    public static final int opaque = 0;
    public static final int bitmapSsp = 1;
    private final int choice;
    private final ASN1Encodable serviceSpecificPermissions;

    public ServiceSpecificPermissions(int n2, ASN1Encodable aSN1Encodable) {
        this.choice = n2;
        this.serviceSpecificPermissions = aSN1Encodable;
    }

    private ServiceSpecificPermissions(ASN1TaggedObject aSN1TaggedObject) {
        this.choice = aSN1TaggedObject.getTagNo();
        switch (this.choice) {
            case 0: {
                this.serviceSpecificPermissions = Opaque.getInstance(aSN1TaggedObject.getExplicitBaseObject());
                return;
            }
            case 1: {
                this.serviceSpecificPermissions = BitmapSsp.getInstance(aSN1TaggedObject.getExplicitBaseObject());
                return;
            }
        }
        throw new IllegalArgumentException("invalid choice value " + this.choice);
    }

    public static ServiceSpecificPermissions getInstance(Object object) {
        if (object instanceof ServiceSpecificPermissions) {
            return (ServiceSpecificPermissions)object;
        }
        if (object != null) {
            return new ServiceSpecificPermissions(ASN1TaggedObject.getInstance(object, 128));
        }
        return null;
    }

    public static ServiceSpecificPermissions opaque(ASN1OctetString aSN1OctetString) {
        return new ServiceSpecificPermissions(0, aSN1OctetString);
    }

    public static ServiceSpecificPermissions opaque(byte[] byArray) {
        return new ServiceSpecificPermissions(0, new DEROctetString(byArray));
    }

    public static ServiceSpecificPermissions bitmapSsp(BitmapSsp bitmapSsp) {
        return new ServiceSpecificPermissions(1, bitmapSsp);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getServiceSpecificPermissions() {
        return this.serviceSpecificPermissions;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.serviceSpecificPermissions);
    }
}

