/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class PhotonBeetleEngine
implements AEADCipher {
    private boolean input_empty;
    private boolean forEncryption;
    private byte[] K;
    private byte[] N;
    private byte[] state;
    private byte[][] state_2d;
    private byte[] A;
    private byte[] T;
    private boolean encrypted;
    private boolean initialised;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();
    private final int CRYPTO_KEYBYTES = 16;
    private final int CRYPTO_NPUBBYTES = 16;
    private final int RATE_INBYTES;
    private final int RATE_INBYTES_HALF;
    private final int STATE_INBYTES;
    private final int TAG_INBYTES = 16;
    private final int LAST_THREE_BITS_OFFSET;
    private final int ROUND = 12;
    private final int D = 8;
    private final int Dq = 3;
    private final int Dr = 7;
    private final int DSquare = 64;
    private final int S = 4;
    private final int S_1 = 3;
    private final byte[][] RC = new byte[][]{{1, 3, 7, 14, 13, 11, 6, 12, 9, 2, 5, 10}, {0, 2, 6, 15, 12, 10, 7, 13, 8, 3, 4, 11}, {2, 0, 4, 13, 14, 8, 5, 15, 10, 1, 6, 9}, {6, 4, 0, 9, 10, 12, 1, 11, 14, 5, 2, 13}, {14, 12, 8, 1, 2, 4, 9, 3, 6, 13, 10, 5}, {15, 13, 9, 0, 3, 5, 8, 2, 7, 12, 11, 4}, {13, 15, 11, 2, 1, 7, 10, 0, 5, 14, 9, 6}, {9, 11, 15, 6, 5, 3, 14, 4, 1, 10, 13, 2}};
    private final byte[][] MixColMatrix = new byte[][]{{2, 4, 2, 11, 2, 8, 5, 6}, {12, 9, 8, 13, 7, 7, 5, 2}, {4, 4, 13, 13, 9, 4, 13, 9}, {1, 6, 5, 1, 12, 13, 15, 14}, {15, 12, 9, 13, 14, 5, 14, 13}, {9, 14, 5, 15, 4, 12, 9, 6}, {12, 2, 2, 10, 3, 1, 1, 14}, {15, 1, 13, 10, 5, 10, 2, 3}};
    private final byte[] sbox = new byte[]{12, 5, 6, 11, 9, 0, 10, 13, 3, 14, 15, 8, 4, 7, 1, 2};

    public PhotonBeetleEngine(PhotonBeetleParameters photonBeetleParameters) {
        int n2 = 0;
        int n3 = 0;
        switch (photonBeetleParameters) {
            case pb32: {
                n3 = 32;
                n2 = 224;
                break;
            }
            case pb128: {
                n3 = 128;
                n2 = 128;
            }
        }
        this.RATE_INBYTES = n3 + 7 >>> 3;
        this.RATE_INBYTES_HALF = this.RATE_INBYTES >>> 1;
        int n4 = n3 + n2;
        this.STATE_INBYTES = n4 + 7 >>> 3;
        this.LAST_THREE_BITS_OFFSET = n4 - (this.STATE_INBYTES - 1 << 3) - 3;
        this.initialised = false;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl2;
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Photon-Beetle AEAD init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        this.N = parametersWithIV.getIV();
        if (this.N == null || this.N.length != 16) {
            throw new IllegalArgumentException("Photon-Beetle AEAD requires exactly 16 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Photon-Beetle AEAD init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.K = keyParameter.getKey();
        if (this.K.length != 16) {
            throw new IllegalArgumentException("Photon-Beetle AEAD key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, cipherParameters, Utils.getPurpose(bl2)));
        this.state = new byte[this.STATE_INBYTES];
        this.state_2d = new byte[8][8];
        this.T = new byte[16];
        this.initialised = true;
        this.reset(false);
    }

    public String getAlgorithmName() {
        return "Photon-Beetle AEAD";
    }

    public void processAADByte(byte by) {
        this.aadData.write(by);
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.aadData.write(byArray, n2, n3);
    }

    public int processByte(byte by, byte[] byArray, int n2) throws DataLengthException {
        return this.processBytes(new byte[]{by}, 0, 1, byArray, n2);
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.message.write(byArray, n2, n3);
        return 0;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        int n3;
        int n4;
        int n5;
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        int n6 = this.message.size() - (this.forEncryption ? 0 : 16);
        if (this.forEncryption && n6 + 16 + n2 > byArray.length || !this.forEncryption && n6 + n2 > byArray.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] byArray2 = this.message.toByteArray();
        int n7 = 0;
        this.A = this.aadData.toByteArray();
        int n8 = this.A.length;
        if (n8 != 0 || n6 != 0) {
            this.input_empty = false;
        }
        byte by = this.select(n6 != 0, n8 % this.RATE_INBYTES == 0, (byte)3, (byte)4);
        byte by2 = this.select(n8 != 0, n6 % this.RATE_INBYTES == 0, (byte)5, (byte)6);
        if (n8 != 0) {
            n5 = (n8 + this.RATE_INBYTES - 1) / this.RATE_INBYTES;
            for (n4 = 0; n4 < n5 - 1; ++n4) {
                this.PHOTON_Permutation();
                this.XOR(this.A, n4 * this.RATE_INBYTES, this.RATE_INBYTES);
            }
            this.PHOTON_Permutation();
            n3 = n8 - n4 * this.RATE_INBYTES;
            this.XOR(this.A, n4 * this.RATE_INBYTES, n3);
            if (n3 < this.RATE_INBYTES) {
                int n9 = n3;
                this.state[n9] = (byte)(this.state[n9] ^ 1);
            }
            int n10 = this.STATE_INBYTES - 1;
            this.state[n10] = (byte)(this.state[n10] ^ by << this.LAST_THREE_BITS_OFFSET);
        }
        if (n6 != 0) {
            n5 = (n6 + this.RATE_INBYTES - 1) / this.RATE_INBYTES;
            for (n4 = 0; n4 < n5 - 1; ++n4) {
                this.PHOTON_Permutation();
                this.rhoohr(byArray, n2 + n4 * this.RATE_INBYTES, byArray2, n7 + n4 * this.RATE_INBYTES, this.RATE_INBYTES);
            }
            this.PHOTON_Permutation();
            n3 = n6 - n4 * this.RATE_INBYTES;
            this.rhoohr(byArray, n2 + n4 * this.RATE_INBYTES, byArray2, n7 + n4 * this.RATE_INBYTES, n3);
            if (n3 < this.RATE_INBYTES) {
                int n11 = n3;
                this.state[n11] = (byte)(this.state[n11] ^ 1);
            }
            int n12 = this.STATE_INBYTES - 1;
            this.state[n12] = (byte)(this.state[n12] ^ by2 << this.LAST_THREE_BITS_OFFSET);
        }
        n2 += n6;
        if (this.input_empty) {
            int n13 = this.STATE_INBYTES - 1;
            this.state[n13] = (byte)(this.state[n13] ^ 1 << this.LAST_THREE_BITS_OFFSET);
        }
        this.PHOTON_Permutation();
        this.T = new byte[16];
        System.arraycopy(this.state, 0, this.T, 0, 16);
        if (this.forEncryption) {
            System.arraycopy(this.T, 0, byArray, n2, 16);
            n6 += 16;
        } else {
            for (n4 = 0; n4 < 16; ++n4) {
                if (this.T[n4] == byArray2[n6 + n4]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.reset(false);
        return n6;
    }

    public byte[] getMac() {
        return this.T;
    }

    public int getUpdateOutputSize(int n2) {
        return n2;
    }

    public int getOutputSize(int n2) {
        return n2 + 16;
    }

    public void reset() {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.reset(true);
    }

    private void reset(boolean bl2) {
        if (bl2) {
            this.T = null;
        }
        this.input_empty = true;
        this.aadData.reset();
        this.message.reset();
        System.arraycopy(this.K, 0, this.state, 0, this.K.length);
        System.arraycopy(this.N, 0, this.state, this.K.length, this.N.length);
        this.encrypted = false;
    }

    private void PHOTON_Permutation() {
        int n2;
        for (n2 = 0; n2 < 64; ++n2) {
            this.state_2d[n2 >>> 3][n2 & 7] = (byte)((this.state[n2 >> 1] & 0xFF) >>> 4 * (n2 & 1) & 0xF);
        }
        for (int i2 = 0; i2 < 12; ++i2) {
            int n3;
            for (n2 = 0; n2 < 8; ++n2) {
                byte[] byArray = this.state_2d[n2];
                byArray[0] = (byte)(byArray[0] ^ this.RC[n2][i2]);
            }
            for (n2 = 0; n2 < 8; ++n2) {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.state_2d[n2][n3] = this.sbox[this.state_2d[n2][n3]];
                }
            }
            for (n2 = 1; n2 < 8; ++n2) {
                System.arraycopy(this.state_2d[n2], 0, this.state, 0, 8);
                System.arraycopy(this.state, n2, this.state_2d[n2], 0, 8 - n2);
                System.arraycopy(this.state, 0, this.state_2d[n2], 8 - n2, n2);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                for (n2 = 0; n2 < 8; ++n2) {
                    byte by = 0;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n4 = this.MixColMatrix[n2][i3];
                        int n5 = 0;
                        byte by2 = this.state_2d[i3][n3];
                        for (int i4 = 0; i4 < 4; ++i4) {
                            if ((by2 >>> i4 & 1) != 0) {
                                n5 ^= n4;
                            }
                            if ((n4 >>> 3 & 1) != 0) {
                                n4 <<= 1;
                                n4 ^= 3;
                                continue;
                            }
                            n4 <<= 1;
                        }
                        by = (byte)(by ^ n5 & 0xF);
                    }
                    this.state[n2] = by;
                }
                for (n2 = 0; n2 < 8; ++n2) {
                    this.state_2d[n2][n3] = this.state[n2];
                }
            }
        }
        for (n2 = 0; n2 < 64; n2 += 2) {
            this.state[n2 >>> 1] = (byte)(this.state_2d[n2 >>> 3][n2 & 7] & 0xF | (this.state_2d[n2 >>> 3][n2 + 1 & 7] & 0xF) << 4);
        }
    }

    private byte select(boolean bl2, boolean bl3, byte by, byte by2) {
        if (bl2 && bl3) {
            return 1;
        }
        if (bl2) {
            return 2;
        }
        if (bl3) {
            return by;
        }
        return by2;
    }

    private void rhoohr(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        byte[] byArray3 = this.state_2d[0];
        int n6 = Math.min(n4, this.RATE_INBYTES_HALF);
        for (n5 = 0; n5 < this.RATE_INBYTES_HALF - 1; ++n5) {
            byArray3[n5] = (byte)((this.state[n5] & 0xFF) >>> 1 | (this.state[n5 + 1] & 1) << 7);
        }
        byArray3[this.RATE_INBYTES_HALF - 1] = (byte)((this.state[n5] & 0xFF) >>> 1 | (this.state[0] & 1) << 7);
        n5 = 0;
        while (n5 < n6) {
            byArray[n5 + n2] = (byte)(this.state[n5 + this.RATE_INBYTES_HALF] ^ byArray2[n5++ + n3]);
        }
        while (n5 < n4) {
            byArray[n5 + n2] = (byte)(byArray3[n5 - this.RATE_INBYTES_HALF] ^ byArray2[n5++ + n3]);
        }
        if (this.forEncryption) {
            this.XOR(byArray2, n3, n4);
        } else {
            this.XOR(byArray, n3, n4);
        }
    }

    private void XOR(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            this.state[n5] = (byte)(this.state[n5] ^ byArray[n2++]);
        }
    }

    public int getBlockSize() {
        return this.RATE_INBYTES;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhotonBeetleParameters {
        pb32,
        pb128;

    }
}

