/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class XoodyakDigest
implements Digest {
    private byte[] state;
    private int phase;
    private MODE mode;
    private int Rabsorb;
    private final int f_bPrime = 48;
    private final int Rhash = 16;
    private final int PhaseDown = 1;
    private final int PhaseUp = 2;
    private final int NLANES = 12;
    private final int NROWS = 3;
    private final int NCOLUMS = 4;
    private final int MAXROUNDS = 12;
    private final int TAGLEN = 16;
    private final int[] RC = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public XoodyakDigest() {
        this.state = new byte[48];
        this.reset();
    }

    public String getAlgorithmName() {
        return "Xoodyak Hash";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte by) {
        this.buffer.write(by);
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3;
        if (32 + n2 > byArray.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] byArray2 = this.buffer.toByteArray();
        int n4 = 0;
        int n5 = this.buffer.size();
        int n6 = 3;
        do {
            if (this.phase != 2) {
                this.Up(null, 0, 0, 0);
            }
            n3 = Math.min(n5, this.Rabsorb);
            this.Down(byArray2, n4, n3, n6);
            n6 = 0;
            n4 += n3;
        } while ((n5 -= n3) != 0);
        this.Up(byArray, n2, 16, 64);
        this.Down(null, 0, 0, 0);
        this.Up(byArray, n2 + 16, 16, 0);
        return 32;
    }

    public void reset() {
        Arrays.fill(this.state, (byte)0);
        this.phase = 2;
        this.mode = MODE.ModeHash;
        this.Rabsorb = 16;
        this.buffer.reset();
    }

    private void Up(byte[] byArray, int n2, int n3, int n4) {
        if (this.mode != MODE.ModeHash) {
            this.state[47] = (byte)(this.state[47] ^ n4);
        }
        int[] nArray = new int[12];
        Pack.littleEndianToInt(this.state, 0, nArray, 0, nArray.length);
        int[] nArray2 = new int[12];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        for (int i2 = 0; i2 < 12; ++i2) {
            int n5;
            int n6;
            for (n6 = 0; n6 < 4; ++n6) {
                nArray3[n6] = nArray[this.index(n6, 0)] ^ nArray[this.index(n6, 1)] ^ nArray[this.index(n6, 2)];
            }
            for (n6 = 0; n6 < 4; ++n6) {
                n5 = nArray3[n6 + 3 & 3];
                nArray4[n6] = this.ROTL32(n5, 5) ^ this.ROTL32(n5, 14);
            }
            for (n6 = 0; n6 < 4; ++n6) {
                for (n5 = 0; n5 < 3; ++n5) {
                    int n7 = this.index(n6, n5);
                    nArray[n7] = nArray[n7] ^ nArray4[n6];
                }
            }
            for (n6 = 0; n6 < 4; ++n6) {
                nArray2[this.index((int)n6, (int)0)] = nArray[this.index(n6, 0)];
                nArray2[this.index((int)n6, (int)1)] = nArray[this.index(n6 + 3, 1)];
                nArray2[this.index((int)n6, (int)2)] = this.ROTL32(nArray[this.index(n6, 2)], 11);
            }
            nArray2[0] = nArray2[0] ^ this.RC[i2];
            for (n6 = 0; n6 < 4; ++n6) {
                for (n5 = 0; n5 < 3; ++n5) {
                    nArray[this.index((int)n6, (int)n5)] = nArray2[this.index(n6, n5)] ^ ~nArray2[this.index(n6, n5 + 1)] & nArray2[this.index(n6, n5 + 2)];
                }
            }
            for (n6 = 0; n6 < 4; ++n6) {
                nArray2[this.index((int)n6, (int)0)] = nArray[this.index(n6, 0)];
                nArray2[this.index((int)n6, (int)1)] = this.ROTL32(nArray[this.index(n6, 1)], 1);
                nArray2[this.index((int)n6, (int)2)] = this.ROTL32(nArray[this.index(n6 + 2, 2)], 8);
            }
            System.arraycopy(nArray2, 0, nArray, 0, 12);
        }
        Pack.intToLittleEndian(nArray, 0, nArray.length, this.state, 0);
        this.phase = 2;
        if (byArray != null) {
            System.arraycopy(this.state, 0, byArray, n2, n3);
        }
    }

    void Down(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n5++;
            this.state[n6] = (byte)(this.state[n6] ^ byArray[n2++]);
        }
        int n7 = n3;
        this.state[n7] = (byte)(this.state[n7] ^ 1);
        this.state[47] = (byte)(this.state[47] ^ (this.mode == MODE.ModeHash ? n4 & 1 : n4));
        this.phase = 1;
    }

    private int index(int n2, int n3) {
        return n3 % 3 * 4 + n2 % 4;
    }

    private int ROTL32(int n2, int n3) {
        return n2 << (n3 & 0x1F) ^ n2 >>> (32 - n3 & 0x1F);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        ModeHash,
        ModeKeyed;

    }
}

