/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class RIPEMD160Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 20;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] X = new int[16];
    private int xOff;

    public RIPEMD160Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public RIPEMD160Digest(CryptoServicePurpose cryptoServicePurpose) {
        super(cryptoServicePurpose);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.reset();
    }

    public RIPEMD160Digest(RIPEMD160Digest rIPEMD160Digest) {
        super(rIPEMD160Digest);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.copyIn(rIPEMD160Digest);
    }

    private void copyIn(RIPEMD160Digest rIPEMD160Digest) {
        super.copyIn(rIPEMD160Digest);
        this.H0 = rIPEMD160Digest.H0;
        this.H1 = rIPEMD160Digest.H1;
        this.H2 = rIPEMD160Digest.H2;
        this.H3 = rIPEMD160Digest.H3;
        this.H4 = rIPEMD160Digest.H4;
        System.arraycopy(rIPEMD160Digest.X, 0, this.X, 0, rIPEMD160Digest.X.length);
        this.xOff = rIPEMD160Digest.xOff;
    }

    public String getAlgorithmName() {
        return "RIPEMD160";
    }

    public int getDigestSize() {
        return 20;
    }

    protected void processWord(byte[] byArray, int n2) {
        this.X[this.xOff++] = Pack.littleEndianToInt(byArray, n2);
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l2) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(l2 >>> 32);
    }

    public int doFinal(byte[] byArray, int n2) {
        this.finish();
        Pack.intToLittleEndian(this.H0, byArray, n2);
        Pack.intToLittleEndian(this.H1, byArray, n2 + 4);
        Pack.intToLittleEndian(this.H2, byArray, n2 + 8);
        Pack.intToLittleEndian(this.H3, byArray, n2 + 12);
        Pack.intToLittleEndian(this.H4, byArray, n2 + 16);
        this.reset();
        return 20;
    }

    public void reset() {
        super.reset();
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int RL(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private int f1(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    private int f2(int n2, int n3, int n4) {
        return n2 & n3 | ~n2 & n4;
    }

    private int f3(int n2, int n3, int n4) {
        return (n2 | ~n3) ^ n4;
    }

    private int f4(int n2, int n3, int n4) {
        return n2 & n4 | n3 & ~n4;
    }

    private int f5(int n2, int n3, int n4) {
        return n2 ^ (n3 | ~n4);
    }

    protected void processBlock() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n6 = this.H0;
        int n8 = n5 = this.H1;
        int n9 = n4 = this.H2;
        int n10 = n3 = this.H3;
        int n11 = n2 = this.H4;
        n7 = this.RL(n7 + this.f1(n8, n9, n10) + this.X[0], 11) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f1(n7, n8, n9) + this.X[1], 14) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f1(n11, n7, n8) + this.X[2], 15) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f1(n10, n11, n7) + this.X[3], 12) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f1(n9, n10, n11) + this.X[4], 5) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f1(n8, n9, n10) + this.X[5], 8) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f1(n7, n8, n9) + this.X[6], 7) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f1(n11, n7, n8) + this.X[7], 9) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f1(n10, n11, n7) + this.X[8], 11) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f1(n9, n10, n11) + this.X[9], 13) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f1(n8, n9, n10) + this.X[10], 14) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f1(n7, n8, n9) + this.X[11], 15) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f1(n11, n7, n8) + this.X[12], 6) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f1(n10, n11, n7) + this.X[13], 7) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f1(n9, n10, n11) + this.X[14], 9) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f1(n8, n9, n10) + this.X[15], 8) + n11;
        n9 = this.RL(n9, 10);
        n6 = this.RL(n6 + this.f5(n5, n4, n3) + this.X[5] + 1352829926, 8) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f5(n6, n5, n4) + this.X[14] + 1352829926, 9) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f5(n2, n6, n5) + this.X[7] + 1352829926, 9) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f5(n3, n2, n6) + this.X[0] + 1352829926, 11) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f5(n4, n3, n2) + this.X[9] + 1352829926, 13) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f5(n5, n4, n3) + this.X[2] + 1352829926, 15) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f5(n6, n5, n4) + this.X[11] + 1352829926, 15) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f5(n2, n6, n5) + this.X[4] + 1352829926, 5) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f5(n3, n2, n6) + this.X[13] + 1352829926, 7) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f5(n4, n3, n2) + this.X[6] + 1352829926, 7) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f5(n5, n4, n3) + this.X[15] + 1352829926, 8) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f5(n6, n5, n4) + this.X[8] + 1352829926, 11) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f5(n2, n6, n5) + this.X[1] + 1352829926, 14) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f5(n3, n2, n6) + this.X[10] + 1352829926, 14) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f5(n4, n3, n2) + this.X[3] + 1352829926, 12) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f5(n5, n4, n3) + this.X[12] + 1352829926, 6) + n2;
        n4 = this.RL(n4, 10);
        n11 = this.RL(n11 + this.f2(n7, n8, n9) + this.X[7] + 1518500249, 7) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f2(n11, n7, n8) + this.X[4] + 1518500249, 6) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f2(n10, n11, n7) + this.X[13] + 1518500249, 8) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f2(n9, n10, n11) + this.X[1] + 1518500249, 13) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f2(n8, n9, n10) + this.X[10] + 1518500249, 11) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f2(n7, n8, n9) + this.X[6] + 1518500249, 9) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f2(n11, n7, n8) + this.X[15] + 1518500249, 7) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f2(n10, n11, n7) + this.X[3] + 1518500249, 15) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f2(n9, n10, n11) + this.X[12] + 1518500249, 7) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f2(n8, n9, n10) + this.X[0] + 1518500249, 12) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f2(n7, n8, n9) + this.X[9] + 1518500249, 15) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f2(n11, n7, n8) + this.X[5] + 1518500249, 9) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f2(n10, n11, n7) + this.X[2] + 1518500249, 11) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f2(n9, n10, n11) + this.X[14] + 1518500249, 7) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f2(n8, n9, n10) + this.X[11] + 1518500249, 13) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f2(n7, n8, n9) + this.X[8] + 1518500249, 12) + n10;
        n8 = this.RL(n8, 10);
        n2 = this.RL(n2 + this.f4(n6, n5, n4) + this.X[6] + 1548603684, 9) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f4(n2, n6, n5) + this.X[11] + 1548603684, 13) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f4(n3, n2, n6) + this.X[3] + 1548603684, 15) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f4(n4, n3, n2) + this.X[7] + 1548603684, 7) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f4(n5, n4, n3) + this.X[0] + 1548603684, 12) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f4(n6, n5, n4) + this.X[13] + 1548603684, 8) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f4(n2, n6, n5) + this.X[5] + 1548603684, 9) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f4(n3, n2, n6) + this.X[10] + 1548603684, 11) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f4(n4, n3, n2) + this.X[14] + 1548603684, 7) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f4(n5, n4, n3) + this.X[15] + 1548603684, 7) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f4(n6, n5, n4) + this.X[8] + 1548603684, 12) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f4(n2, n6, n5) + this.X[12] + 1548603684, 7) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f4(n3, n2, n6) + this.X[4] + 1548603684, 6) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f4(n4, n3, n2) + this.X[9] + 1548603684, 15) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f4(n5, n4, n3) + this.X[1] + 1548603684, 13) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f4(n6, n5, n4) + this.X[2] + 1548603684, 11) + n3;
        n5 = this.RL(n5, 10);
        n10 = this.RL(n10 + this.f3(n11, n7, n8) + this.X[3] + 1859775393, 11) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f3(n10, n11, n7) + this.X[10] + 1859775393, 13) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f3(n9, n10, n11) + this.X[14] + 1859775393, 6) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f3(n8, n9, n10) + this.X[4] + 1859775393, 7) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f3(n7, n8, n9) + this.X[9] + 1859775393, 14) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f3(n11, n7, n8) + this.X[15] + 1859775393, 9) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f3(n10, n11, n7) + this.X[8] + 1859775393, 13) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f3(n9, n10, n11) + this.X[1] + 1859775393, 15) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f3(n8, n9, n10) + this.X[2] + 1859775393, 14) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f3(n7, n8, n9) + this.X[7] + 1859775393, 8) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f3(n11, n7, n8) + this.X[0] + 1859775393, 13) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f3(n10, n11, n7) + this.X[6] + 1859775393, 6) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f3(n9, n10, n11) + this.X[13] + 1859775393, 5) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f3(n8, n9, n10) + this.X[11] + 1859775393, 12) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f3(n7, n8, n9) + this.X[5] + 1859775393, 7) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f3(n11, n7, n8) + this.X[12] + 1859775393, 5) + n9;
        n7 = this.RL(n7, 10);
        n3 = this.RL(n3 + this.f3(n2, n6, n5) + this.X[15] + 1836072691, 9) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f3(n3, n2, n6) + this.X[5] + 1836072691, 7) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f3(n4, n3, n2) + this.X[1] + 1836072691, 15) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f3(n5, n4, n3) + this.X[3] + 1836072691, 11) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f3(n6, n5, n4) + this.X[7] + 1836072691, 8) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f3(n2, n6, n5) + this.X[14] + 1836072691, 6) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f3(n3, n2, n6) + this.X[6] + 1836072691, 6) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f3(n4, n3, n2) + this.X[9] + 1836072691, 14) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f3(n5, n4, n3) + this.X[11] + 1836072691, 12) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f3(n6, n5, n4) + this.X[8] + 1836072691, 13) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f3(n2, n6, n5) + this.X[12] + 1836072691, 5) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f3(n3, n2, n6) + this.X[2] + 1836072691, 14) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f3(n4, n3, n2) + this.X[10] + 1836072691, 13) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f3(n5, n4, n3) + this.X[0] + 1836072691, 13) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f3(n6, n5, n4) + this.X[4] + 1836072691, 7) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f3(n2, n6, n5) + this.X[13] + 1836072691, 5) + n4;
        n6 = this.RL(n6, 10);
        n9 = this.RL(n9 + this.f4(n10, n11, n7) + this.X[1] + -1894007588, 11) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f4(n9, n10, n11) + this.X[9] + -1894007588, 12) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f4(n8, n9, n10) + this.X[11] + -1894007588, 14) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f4(n7, n8, n9) + this.X[10] + -1894007588, 15) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f4(n11, n7, n8) + this.X[0] + -1894007588, 14) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f4(n10, n11, n7) + this.X[8] + -1894007588, 15) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f4(n9, n10, n11) + this.X[12] + -1894007588, 9) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f4(n8, n9, n10) + this.X[4] + -1894007588, 8) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f4(n7, n8, n9) + this.X[13] + -1894007588, 9) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f4(n11, n7, n8) + this.X[3] + -1894007588, 14) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f4(n10, n11, n7) + this.X[7] + -1894007588, 5) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f4(n9, n10, n11) + this.X[15] + -1894007588, 6) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f4(n8, n9, n10) + this.X[14] + -1894007588, 8) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f4(n7, n8, n9) + this.X[5] + -1894007588, 6) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f4(n11, n7, n8) + this.X[6] + -1894007588, 5) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f4(n10, n11, n7) + this.X[2] + -1894007588, 12) + n8;
        n11 = this.RL(n11, 10);
        n4 = this.RL(n4 + this.f2(n3, n2, n6) + this.X[8] + 2053994217, 15) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f2(n4, n3, n2) + this.X[6] + 2053994217, 5) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f2(n5, n4, n3) + this.X[4] + 2053994217, 8) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f2(n6, n5, n4) + this.X[1] + 2053994217, 11) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f2(n2, n6, n5) + this.X[3] + 2053994217, 14) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f2(n3, n2, n6) + this.X[11] + 2053994217, 14) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f2(n4, n3, n2) + this.X[15] + 2053994217, 6) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f2(n5, n4, n3) + this.X[0] + 2053994217, 14) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f2(n6, n5, n4) + this.X[5] + 2053994217, 6) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f2(n2, n6, n5) + this.X[12] + 2053994217, 9) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f2(n3, n2, n6) + this.X[2] + 2053994217, 12) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f2(n4, n3, n2) + this.X[13] + 2053994217, 9) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f2(n5, n4, n3) + this.X[9] + 2053994217, 12) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f2(n6, n5, n4) + this.X[7] + 2053994217, 5) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f2(n2, n6, n5) + this.X[10] + 2053994217, 15) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f2(n3, n2, n6) + this.X[14] + 2053994217, 8) + n5;
        n2 = this.RL(n2, 10);
        n8 = this.RL(n8 + this.f5(n9, n10, n11) + this.X[4] + -1454113458, 9) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f5(n8, n9, n10) + this.X[0] + -1454113458, 15) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f5(n7, n8, n9) + this.X[5] + -1454113458, 5) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f5(n11, n7, n8) + this.X[9] + -1454113458, 11) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f5(n10, n11, n7) + this.X[7] + -1454113458, 6) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f5(n9, n10, n11) + this.X[12] + -1454113458, 8) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f5(n8, n9, n10) + this.X[2] + -1454113458, 13) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f5(n7, n8, n9) + this.X[10] + -1454113458, 12) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f5(n11, n7, n8) + this.X[14] + -1454113458, 5) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f5(n10, n11, n7) + this.X[1] + -1454113458, 12) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f5(n9, n10, n11) + this.X[3] + -1454113458, 13) + n7;
        n10 = this.RL(n10, 10);
        n7 = this.RL(n7 + this.f5(n8, n9, n10) + this.X[8] + -1454113458, 14) + n11;
        n9 = this.RL(n9, 10);
        n11 = this.RL(n11 + this.f5(n7, n8, n9) + this.X[11] + -1454113458, 11) + n10;
        n8 = this.RL(n8, 10);
        n10 = this.RL(n10 + this.f5(n11, n7, n8) + this.X[6] + -1454113458, 8) + n9;
        n7 = this.RL(n7, 10);
        n9 = this.RL(n9 + this.f5(n10, n11, n7) + this.X[15] + -1454113458, 5) + n8;
        n11 = this.RL(n11, 10);
        n8 = this.RL(n8 + this.f5(n9, n10, n11) + this.X[13] + -1454113458, 6) + n7;
        n10 = this.RL(n10, 10);
        n5 = this.RL(n5 + this.f1(n4, n3, n2) + this.X[12], 8) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f1(n5, n4, n3) + this.X[15], 5) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f1(n6, n5, n4) + this.X[10], 12) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f1(n2, n6, n5) + this.X[4], 9) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f1(n3, n2, n6) + this.X[1], 12) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f1(n4, n3, n2) + this.X[5], 5) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f1(n5, n4, n3) + this.X[8], 14) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f1(n6, n5, n4) + this.X[7], 6) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f1(n2, n6, n5) + this.X[6], 8) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f1(n3, n2, n6) + this.X[2], 13) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f1(n4, n3, n2) + this.X[13], 6) + n6;
        n3 = this.RL(n3, 10);
        n6 = this.RL(n6 + this.f1(n5, n4, n3) + this.X[14], 5) + n2;
        n4 = this.RL(n4, 10);
        n2 = this.RL(n2 + this.f1(n6, n5, n4) + this.X[0], 15) + n3;
        n5 = this.RL(n5, 10);
        n3 = this.RL(n3 + this.f1(n2, n6, n5) + this.X[3], 13) + n4;
        n6 = this.RL(n6, 10);
        n4 = this.RL(n4 + this.f1(n3, n2, n6) + this.X[9], 11) + n5;
        n2 = this.RL(n2, 10);
        n5 = this.RL(n5 + this.f1(n4, n3, n2) + this.X[11], 11) + n6;
        n3 = this.RL(n3, 10);
        this.H1 = this.H2 + n10 + n2;
        this.H2 = this.H3 + n11 + n6;
        this.H3 = this.H4 + n7 + n5;
        this.H4 = this.H0 + n8 + n4;
        this.H0 = n3 += n9 + this.H1;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    public Memoable copy() {
        return new RIPEMD160Digest(this);
    }

    public void reset(Memoable memoable) {
        RIPEMD160Digest rIPEMD160Digest = (RIPEMD160Digest)memoable;
        this.copyIn(rIPEMD160Digest);
    }

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 128, this.purpose);
    }
}

