/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.OutputLengthException;

public class AsconDigest
implements ExtendedDigest {
    AsconParameters asconParameters;
    private final String algorithmName;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private long x0;
    private long x1;
    private long x2;
    private long x3;
    private long x4;
    private final int CRYPTO_BYTES = 32;
    private final int ASCON_PB_ROUNDS;

    public AsconDigest(AsconParameters asconParameters) {
        this.asconParameters = asconParameters;
        switch (asconParameters) {
            case AsconHash: {
                this.ASCON_PB_ROUNDS = 12;
                this.algorithmName = "Ascon-Hash";
                break;
            }
            case AsconHashA: {
                this.ASCON_PB_ROUNDS = 8;
                this.algorithmName = "Ascon-HashA";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Ascon Hash");
            }
        }
        this.reset();
    }

    private long ROR(long l2, int n2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }

    private void ROUND(long l2) {
        long l3 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ l2 ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ l2);
        long l4 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ l2 ^ (this.x1 ^ this.x2 ^ l2) & (this.x1 ^ this.x3);
        long l5 = this.x1 ^ this.x2 ^ this.x4 ^ l2 ^ this.x3 & this.x4;
        long l6 = this.x0 ^ this.x1 ^ this.x2 ^ l2 ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long l7 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = l3 ^ this.ROR(l3, 19) ^ this.ROR(l3, 28);
        this.x1 = l4 ^ this.ROR(l4, 39) ^ this.ROR(l4, 61);
        this.x2 = l5 ^ this.ROR(l5, 1) ^ this.ROR(l5, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = l6 ^ this.ROR(l6, 10) ^ this.ROR(l6, 17);
        this.x4 = l7 ^ this.ROR(l7, 7) ^ this.ROR(l7, 41);
    }

    private void P(int n2) {
        if (n2 == 12) {
            this.ROUND(240L);
            this.ROUND(225L);
            this.ROUND(210L);
            this.ROUND(195L);
        }
        if (n2 >= 8) {
            this.ROUND(180L);
            this.ROUND(165L);
        }
        this.ROUND(150L);
        this.ROUND(135L);
        this.ROUND(120L);
        this.ROUND(105L);
        this.ROUND(90L);
        this.ROUND(75L);
    }

    private long PAD(int n2) {
        return 128L << 56 - (n2 << 3);
    }

    private long LOADBYTES(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 |= ((long)byArray[i2 + n2] & 0xFFL) << (7 - i2 << 3);
        }
        return l2;
    }

    private void STOREBYTES(byte[] byArray, int n2, long l2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2 + n2] = (byte)(l2 >>> (7 - i2 << 3));
        }
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getDigestSize() {
        return 32;
    }

    public int getByteLength() {
        return 8;
    }

    public void update(byte by) {
        this.buffer.write(by);
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3;
        if (32 + n2 > byArray.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] byArray2 = this.buffer.toByteArray();
        int n4 = 0;
        int n5 = 8;
        for (n3 = this.buffer.size(); n3 >= n5; n3 -= n5) {
            this.x0 ^= this.LOADBYTES(byArray2, n4, 8);
            this.P(this.ASCON_PB_ROUNDS);
            n4 += n5;
        }
        this.x0 ^= this.LOADBYTES(byArray2, n4, n3);
        this.x0 ^= this.PAD(n3);
        int n6 = 12;
        this.P(n6);
        for (n3 = 32; n3 > n5; n3 -= n5) {
            this.STOREBYTES(byArray, n2, this.x0, 8);
            this.P(this.ASCON_PB_ROUNDS);
            n2 += n5;
        }
        this.STOREBYTES(byArray, n2, this.x0, n3);
        this.reset();
        return 32;
    }

    public void reset() {
        this.buffer.reset();
        switch (this.asconParameters) {
            case AsconHashA: {
                this.x0 = 92044056785660070L;
                this.x1 = 8326807761760157607L;
                this.x2 = 3371194088139667532L;
                this.x3 = -2956994353054992515L;
                this.x4 = -6828509670848688761L;
                break;
            }
            case AsconHash: {
                this.x0 = -1255492011513352131L;
                this.x1 = -8380609354527731710L;
                this.x2 = -5437372128236807582L;
                this.x3 = 4834782570098516968L;
                this.x4 = 3787428097924915520L;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AsconParameters {
        AsconHash,
        AsconHashA;

    }
}

