/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.cms.MACProvider;
import org.bouncycastle.util.Arrays;

public final class InputStreamWithMAC
extends InputStream {
    private final InputStream base;
    private MACProvider macProvider;
    private byte[] mac;
    private boolean baseFinished;
    private int index;

    InputStreamWithMAC(InputStream inputStream, MACProvider mACProvider) {
        this.base = inputStream;
        this.macProvider = mACProvider;
        this.baseFinished = false;
        this.index = 0;
    }

    public InputStreamWithMAC(InputStream inputStream, byte[] byArray) {
        this.base = inputStream;
        this.mac = byArray;
        this.baseFinished = false;
        this.index = 0;
    }

    public int read() throws IOException {
        int n2;
        if (!this.baseFinished) {
            n2 = this.base.read();
            if (n2 < 0) {
                this.baseFinished = true;
                if (this.macProvider != null) {
                    this.macProvider.init();
                    this.mac = this.macProvider.getMAC();
                }
                return this.mac[this.index++] & 0xFF;
            }
        } else {
            if (this.index >= this.mac.length) {
                return -1;
            }
            return this.mac[this.index++] & 0xFF;
        }
        return n2;
    }

    public byte[] getMAC() {
        if (!this.baseFinished) {
            throw new IllegalStateException("input stream not fully processed");
        }
        return Arrays.clone(this.mac);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("input array is null");
        }
        if (n2 < 0 || byArray.length < n2 + n3) {
            throw new IndexOutOfBoundsException("invalid off(" + n2 + ") and len(" + n3 + ")");
        }
        if (!this.baseFinished) {
            int n4 = this.base.read(byArray, n2, n3);
            if (n4 < 0) {
                this.baseFinished = true;
                if (this.macProvider != null) {
                    this.macProvider.init();
                    this.mac = this.macProvider.getMAC();
                }
                if (n3 >= this.mac.length) {
                    System.arraycopy(this.mac, 0, byArray, n2, this.mac.length);
                    this.index = this.mac.length;
                    return this.mac.length;
                }
                System.arraycopy(this.mac, 0, byArray, n2, n3);
                this.index += n3;
                return n3;
            }
            return n4;
        }
        if (this.index < this.mac.length) {
            if (n3 >= this.mac.length - this.index) {
                System.arraycopy(this.mac, this.index, byArray, n2, this.mac.length - this.index);
                int n5 = this.mac.length - this.index;
                this.index = this.mac.length;
                return n5;
            }
            System.arraycopy(this.mac, this.index, byArray, n2, n3);
            this.index += n3;
            return n3;
        }
        return -1;
    }
}

