/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.LocaleUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1GeneralizedTime.class, 24){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1GeneralizedTime.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    public static ASN1GeneralizedTime getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1GeneralizedTime)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return (ASN1GeneralizedTime)TYPE.getContextInstance(aSN1TaggedObject, bl2);
    }

    public ASN1GeneralizedTime(String string) {
        this.contents = Strings.toByteArray(string);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public ASN1GeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", LocaleUtil.EN_Locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.contents = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1GeneralizedTime(Date date, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.contents = Strings.toByteArray(simpleDateFormat.format(date));
    }

    ASN1GeneralizedTime(byte[] byArray) {
        if (byArray.length < 4) {
            throw new IllegalArgumentException("GeneralizedTime string too short");
        }
        this.contents = byArray;
        if (!(this.isDigit(0) && this.isDigit(1) && this.isDigit(2) && this.isDigit(3))) {
            throw new IllegalArgumentException("illegal characters in GeneralizedTime string");
        }
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.contents);
    }

    public String getTime() {
        String string = Strings.fromByteArray(this.contents);
        if (string.charAt(string.length() - 1) == 'Z') {
            return string.substring(0, string.length() - 1) + "GMT+00:00";
        }
        int n2 = string.length() - 6;
        char c2 = string.charAt(n2);
        if ((c2 == '-' || c2 == '+') && string.indexOf("GMT") == n2 - 3) {
            return string;
        }
        n2 = string.length() - 5;
        c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2, n2 + 3) + ":" + string.substring(n2 + 3);
        }
        n2 = string.length() - 3;
        c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2) + ":00";
        }
        return string + this.calculateGMTOffset(string);
    }

    private String calculateGMTOffset(String string) {
        String string2 = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n2 = timeZone.getRawOffset();
        if (n2 < 0) {
            string2 = "-";
            n2 = -n2;
        }
        int n3 = n2 / 3600000;
        int n4 = (n2 - n3 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime()) {
                SimpleDateFormat simpleDateFormat;
                if (this.hasFractionalSeconds()) {
                    string = this.pruneFractionalSeconds(string);
                }
                if (timeZone.inDaylightTime((simpleDateFormat = this.calculateGMTDateFormat()).parse(string + "GMT" + string2 + this.convert(n3) + ":" + this.convert(n4)))) {
                    n3 += string2.equals("+") ? 1 : -1;
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return "GMT" + string2 + this.convert(n3) + ":" + this.convert(n4);
    }

    private SimpleDateFormat calculateGMTDateFormat() {
        SimpleDateFormat simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmssz") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmmz") : new SimpleDateFormat("yyyyMMddHHz")));
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat;
    }

    private String pruneFractionalSeconds(String string) {
        char c2;
        int n2;
        String string2 = string.substring(14);
        for (n2 = 1; n2 < string2.length() && '0' <= (c2 = string2.charAt(n2)) && c2 <= '9'; ++n2) {
        }
        if (n2 - 1 > 3) {
            string2 = string2.substring(0, 4) + string2.substring(n2);
            string = string.substring(0, 14) + string2;
        } else if (n2 - 1 == 1) {
            string2 = string2.substring(0, n2) + "00" + string2.substring(n2);
            string = string.substring(0, 14) + string2;
        } else if (n2 - 1 == 2) {
            string2 = string2.substring(0, n2) + "0" + string2.substring(n2);
            string = string.substring(0, 14) + string2;
        }
        return string;
    }

    private String convert(int n2) {
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string;
        String string2 = string = Strings.fromByteArray(this.contents);
        if (string.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'", LocaleUtil.EN_Locale) : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss'Z'", LocaleUtil.EN_Locale) : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm'Z'", LocaleUtil.EN_Locale) : new SimpleDateFormat("yyyyMMddHH'Z'", LocaleUtil.EN_Locale)));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (string.indexOf(45) > 0 || string.indexOf(43) > 0) {
            string2 = this.getTime();
            simpleDateFormat = this.calculateGMTDateFormat();
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm") : new SimpleDateFormat("yyyyMMddHH")));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            string2 = this.pruneFractionalSeconds(string2);
        }
        return simpleDateFormat.parse(string2);
    }

    protected boolean hasFractionalSeconds() {
        for (int i2 = 0; i2 != this.contents.length; ++i2) {
            if (this.contents[i2] != 46 || i2 != 14) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSeconds() {
        return this.isDigit(12) && this.isDigit(13);
    }

    protected boolean hasMinutes() {
        return this.isDigit(10) && this.isDigit(11);
    }

    private boolean isDigit(int n2) {
        return this.contents.length > n2 && this.contents[n2] >= 48 && this.contents[n2] <= 57;
    }

    final boolean encodeConstructed() {
        return false;
    }

    int encodedLength(boolean bl2) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl2, this.contents.length);
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl2, 24, this.contents);
    }

    ASN1Primitive toDERObject() {
        return new DERGeneralizedTime(this.contents);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.contents, ((ASN1GeneralizedTime)aSN1Primitive).contents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1GeneralizedTime createPrimitive(byte[] byArray) {
        return new ASN1GeneralizedTime(byArray);
    }
}

