/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.util.LittleEndianOutput;

public final class LittleEndianOutputStream
extends FilterOutputStream
implements LittleEndianOutput {
    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writeByte(int v2) {
        try {
            this.out.write(v2);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeDouble(double v2) {
        this.writeLong(Double.doubleToLongBits(v2));
    }

    @Override
    public void writeInt(int v2) {
        int b3 = v2 >>> 24 & 0xFF;
        int b2 = v2 >>> 16 & 0xFF;
        int b1 = v2 >>> 8 & 0xFF;
        int b0 = v2 & 0xFF;
        try {
            this.out.write(b0);
            this.out.write(b1);
            this.out.write(b2);
            this.out.write(b3);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeLong(long v2) {
        this.writeInt((int)v2);
        this.writeInt((int)(v2 >> 32));
    }

    @Override
    public void writeShort(int v2) {
        int b1 = v2 >>> 8 & 0xFF;
        int b0 = v2 & 0xFF;
        try {
            this.out.write(b0);
            this.out.write(b1);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void write(byte[] b2) {
        try {
            super.write(b2);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void write(byte[] b2, int off, int len) {
        try {
            super.write(b2, off, len);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void writeUInt(long value) {
        try {
            this.out.write((byte)(value & 0xFFL));
            this.out.write((byte)(value >>> 8 & 0xFFL));
            this.out.write((byte)(value >>> 16 & 0xFFL));
            this.out.write((byte)(value >>> 24 & 0xFFL));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void putUShort(int value) {
        try {
            this.out.write((byte)(value & 0xFF));
            this.out.write((byte)(value >>> 8 & 0xFF));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

