/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.OldFileFormatException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Removal;

public class WorkbookFactory {
    public static Workbook create(boolean xssf) throws IOException {
        if (xssf) {
            return WorkbookFactory.createXSSFWorkbook(new Object[0]);
        }
        return WorkbookFactory.createHSSFWorkbook(new Object[0]);
    }

    public static Workbook create(POIFSFileSystem fs) throws IOException {
        return WorkbookFactory.create(fs, null);
    }

    private static Workbook create(POIFSFileSystem fs, String password) throws IOException {
        return WorkbookFactory.create(fs.getRoot(), password);
    }

    public static Workbook create(DirectoryNode root) throws IOException {
        return WorkbookFactory.create(root, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook create(DirectoryNode root, String password) throws IOException {
        if (root.hasEntry("EncryptedPackage")) {
            InputStream stream = null;
            try {
                stream = DocumentFactoryHelper.getDecryptedStream(root, password);
                Workbook workbook = WorkbookFactory.createXSSFWorkbook(stream);
                return workbook;
            }
            finally {
                IOUtils.closeQuietly(stream);
                root.getFileSystem().close();
            }
        }
        boolean passwordSet = false;
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword(password);
            passwordSet = true;
        }
        try {
            Workbook workbook = WorkbookFactory.createHSSFWorkbook(root);
            return workbook;
        }
        finally {
            if (passwordSet) {
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
    }

    @Deprecated
    @Removal(version="4.2.0")
    public static Workbook create(Object pkg) throws IOException {
        return WorkbookFactory.createXSSFWorkbook(pkg);
    }

    public static Workbook create(InputStream inp) throws IOException, EncryptedDocumentException {
        return WorkbookFactory.create(inp, null);
    }

    public static Workbook create(InputStream inp, String password) throws IOException, EncryptedDocumentException {
        InputStream is = FileMagic.prepareToCheckMagic(inp);
        FileMagic fm = FileMagic.valueOf(is);
        switch (fm) {
            case OLE2: {
                POIFSFileSystem fs = new POIFSFileSystem(is);
                return WorkbookFactory.create(fs, password);
            }
            case OOXML: {
                return WorkbookFactory.createXSSFWorkbook(is);
            }
        }
        throw new IOException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static Workbook create(File file) throws IOException, EncryptedDocumentException {
        return WorkbookFactory.create(file, null);
    }

    public static Workbook create(File file, String password) throws IOException, EncryptedDocumentException {
        return WorkbookFactory.create(file, password, false);
    }

    public static Workbook create(File file, String password, boolean readOnly) throws IOException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(file, readOnly);
            return WorkbookFactory.create(fs, password);
        }
        catch (OfficeXmlFileException e2) {
            IOUtils.closeQuietly(fs);
            return WorkbookFactory.createXSSFWorkbook(file, readOnly);
        }
        catch (RuntimeException e3) {
            IOUtils.closeQuietly(fs);
            throw e3;
        }
    }

    private static Workbook createHSSFWorkbook(Object ... args) throws IOException, EncryptedDocumentException {
        return WorkbookFactory.createWorkbook("org.apache.poi.hssf.usermodel.HSSFWorkbookFactory", args);
    }

    private static Workbook createXSSFWorkbook(Object ... args) throws IOException, EncryptedDocumentException {
        return WorkbookFactory.createWorkbook("org.apache.poi.xssf.usermodel.XSSFWorkbookFactory", args);
    }

    private static Workbook createWorkbook(String factoryClass, Object[] args) throws IOException, EncryptedDocumentException {
        try {
            Class<?> clazz = WorkbookFactory.class.getClassLoader().loadClass(factoryClass);
            Class[] argsClz = new Class[args.length];
            int i2 = 0;
            for (Object o2 : args) {
                Class<Object> c2 = o2.getClass();
                if (Boolean.class.isAssignableFrom(c2)) {
                    c2 = Boolean.TYPE;
                } else if (InputStream.class.isAssignableFrom(c2)) {
                    c2 = InputStream.class;
                } else if (File.class.isAssignableFrom(c2)) {
                    c2 = File.class;
                }
                argsClz[i2++] = c2;
            }
            Method m2 = clazz.getMethod("createWorkbook", argsClz);
            return (Workbook)m2.invoke(null, args);
        }
        catch (InvocationTargetException e2) {
            Throwable t2 = e2.getCause();
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            if (t2 instanceof EncryptedDocumentException) {
                throw (EncryptedDocumentException)t2;
            }
            if (t2 instanceof OldFileFormatException) {
                throw (OldFileFormatException)t2;
            }
            if (t2 instanceof RuntimeException) {
                throw (RuntimeException)t2;
            }
            throw new IOException(t2.getMessage(), t2);
        }
        catch (Exception e3) {
            throw new IOException(e3);
        }
    }
}

