/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.apache.poi.sl.draw.DrawPictureShape;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.draw.PathGradientPaint;
import org.apache.poi.sl.usermodel.AbstractColorStyle;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class DrawPaint {
    private static final POILogger LOG = POILogFactory.getLogger(DrawPaint.class);
    private static final Color TRANSPARENT = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    protected PlaceableShape<?, ?> shape;

    public DrawPaint(PlaceableShape<?, ?> shape) {
        this.shape = shape;
    }

    public static PaintStyle.SolidPaint createSolidPaint(Color color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public static PaintStyle.SolidPaint createSolidPaint(ColorStyle color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint) {
        return this.getPaint(graphics, paint, PaintStyle.PaintModifier.NORM);
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint, PaintStyle.PaintModifier modifier) {
        if (modifier == PaintStyle.PaintModifier.NONE) {
            return TRANSPARENT;
        }
        if (paint instanceof PaintStyle.SolidPaint) {
            return this.getSolidPaint((PaintStyle.SolidPaint)paint, graphics, modifier);
        }
        if (paint instanceof PaintStyle.GradientPaint) {
            return this.getGradientPaint((PaintStyle.GradientPaint)paint, graphics);
        }
        if (paint instanceof PaintStyle.TexturePaint) {
            return this.getTexturePaint((PaintStyle.TexturePaint)paint, graphics);
        }
        return TRANSPARENT;
    }

    protected Paint getSolidPaint(PaintStyle.SolidPaint fill, Graphics2D graphics, final PaintStyle.PaintModifier modifier) {
        final ColorStyle orig = fill.getSolidColor();
        AbstractColorStyle cs = new AbstractColorStyle(){

            @Override
            public Color getColor() {
                return orig.getColor();
            }

            @Override
            public int getAlpha() {
                return orig.getAlpha();
            }

            @Override
            public int getHueOff() {
                return orig.getHueOff();
            }

            @Override
            public int getHueMod() {
                return orig.getHueMod();
            }

            @Override
            public int getSatOff() {
                return orig.getSatOff();
            }

            @Override
            public int getSatMod() {
                return orig.getSatMod();
            }

            @Override
            public int getLumOff() {
                return orig.getLumOff();
            }

            @Override
            public int getLumMod() {
                return orig.getLumMod();
            }

            @Override
            public int getShade() {
                return this.scale(orig.getShade(), PaintStyle.PaintModifier.DARKEN_LESS, PaintStyle.PaintModifier.DARKEN);
            }

            @Override
            public int getTint() {
                return this.scale(orig.getTint(), PaintStyle.PaintModifier.LIGHTEN_LESS, PaintStyle.PaintModifier.LIGHTEN);
            }

            private int scale(int value, PaintStyle.PaintModifier lessModifier, PaintStyle.PaintModifier moreModifier) {
                int delta = modifier == lessModifier ? 20000 : (modifier == moreModifier ? 40000 : 0);
                return Math.min(100000, Math.max(0, value) + delta);
            }
        };
        return DrawPaint.applyColorTransform(cs);
    }

    protected Paint getGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        switch (fill.getGradientType()) {
            case linear: {
                return this.createLinearGradientPaint(fill, graphics);
            }
            case circular: {
                return this.createRadialGradientPaint(fill, graphics);
            }
            case shape: {
                return this.createPathGradientPaint(fill, graphics);
            }
        }
        throw new UnsupportedOperationException("gradient fill of type " + fill + " not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Paint getTexturePaint(PaintStyle.TexturePaint fill, Graphics2D graphics) {
        InputStream is = fill.getImageData();
        if (is == null) {
            return TRANSPARENT;
        }
        assert (graphics != null);
        ImageRenderer renderer = DrawPictureShape.getImageRenderer(graphics, fill.getContentType());
        try {
            try {
                renderer.loadImage(is, fill.getContentType());
            }
            finally {
                is.close();
            }
        }
        catch (IOException e2) {
            LOG.log(7, "Can't load image data - using transparent color", e2);
            return TRANSPARENT;
        }
        int alpha = fill.getAlpha();
        if (0 <= alpha && alpha < 100000) {
            renderer.setAlpha((float)alpha / 100000.0f);
        }
        Rectangle2D textAnchor = this.shape.getAnchor();
        BufferedImage image = "image/x-wmf".equals(fill.getContentType()) ? renderer.getImage(new Dimension((int)textAnchor.getWidth(), (int)textAnchor.getHeight())) : renderer.getImage();
        if (image == null) {
            LOG.log(7, "Can't load image data");
            return TRANSPARENT;
        }
        return new TexturePaint(image, textAnchor);
    }

    public static Color applyColorTransform(ColorStyle color) {
        if (color == null || color.getColor() == null) {
            return TRANSPARENT;
        }
        Color result = color.getColor();
        double alpha = DrawPaint.getAlpha(result, color);
        double[] hsl = DrawPaint.RGB2HSL(result);
        DrawPaint.applyHslModOff(hsl, 0, color.getHueMod(), color.getHueOff());
        DrawPaint.applyHslModOff(hsl, 1, color.getSatMod(), color.getSatOff());
        DrawPaint.applyHslModOff(hsl, 2, color.getLumMod(), color.getLumOff());
        DrawPaint.applyShade(hsl, color);
        DrawPaint.applyTint(hsl, color);
        result = DrawPaint.HSL2RGB(hsl[0], hsl[1], hsl[2], alpha);
        return result;
    }

    private static double getAlpha(Color c2, ColorStyle fc) {
        double alpha = (double)c2.getAlpha() / 255.0;
        int fcAlpha = fc.getAlpha();
        if (fcAlpha != -1) {
            alpha *= (double)fcAlpha / 100000.0;
        }
        return Math.min(1.0, Math.max(0.0, alpha));
    }

    private static void applyHslModOff(double[] hsl, int hslPart, int mod, int off) {
        if (mod == -1) {
            mod = 100000;
        }
        if (off == -1) {
            off = 0;
        }
        if (mod != 100000 || off != 0) {
            double fOff = (double)off / 1000.0;
            double fMod = (double)mod / 100000.0;
            hsl[hslPart] = hsl[hslPart] * fMod + fOff;
        }
    }

    private static void applyShade(double[] hsl, ColorStyle fc) {
        int shade = fc.getShade();
        if (shade == -1) {
            return;
        }
        double shadePct = (double)shade / 100000.0;
        hsl[2] = hsl[2] * (1.0 - shadePct);
    }

    private static void applyTint(double[] hsl, ColorStyle fc) {
        int tint = fc.getTint();
        if (tint == -1) {
            return;
        }
        double tintPct = (double)tint / 100000.0;
        hsl[2] = hsl[2] * (1.0 - tintPct) + (100.0 - 100.0 * (1.0 - tintPct));
    }

    protected Paint createLinearGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        Point2D p2;
        double angle = fill.getGradientAngle();
        if (!fill.isRotatedWithShape()) {
            angle -= this.shape.getRotation();
        }
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        AffineTransform at2 = AffineTransform.getRotateInstance(Math.toRadians(angle), anchor.getCenterX(), anchor.getCenterY());
        double diagonal = Math.sqrt(Math.pow(anchor.getWidth(), 2.0) + Math.pow(anchor.getHeight(), 2.0));
        Point2D p1 = at2.transform(new Point2D.Double(anchor.getCenterX() - diagonal / 2.0, anchor.getCenterY()), null);
        return p1.equals(p2 = at2.transform(new Point2D.Double(anchor.getMaxX(), anchor.getCenterY()), null)) || fill.getGradientFractions().length < 2 ? null : this.safeFractions((f2, c2) -> new LinearGradientPaint(p1, p2, (float[])f2, (Color[])c2), fill);
    }

    protected Paint createRadialGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        Point2D.Double pCenter = new Point2D.Double(anchor.getCenterX(), anchor.getCenterY());
        float radius = (float)Math.max(anchor.getWidth(), anchor.getHeight());
        return this.safeFractions((f2, c2) -> new RadialGradientPaint(pCenter, radius, (float[])f2, (Color[])c2), fill);
    }

    protected Paint createPathGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        return this.safeFractions(PathGradientPaint::new, fill);
    }

    private Paint safeFractions(BiFunction<float[], Color[], Paint> init, PaintStyle.GradientPaint fill) {
        float[] fractions = fill.getGradientFractions();
        ColorStyle[] styles = fill.getGradientColors();
        TreeMap<Float, Color> m2 = new TreeMap<Float, Color>();
        for (int i2 = 0; i2 < fractions.length; ++i2) {
            m2.put(Float.valueOf(fractions[i2]), styles[i2] == null ? TRANSPARENT : DrawPaint.applyColorTransform(styles[i2]));
        }
        Color[] colors = new Color[m2.size()];
        if (fractions.length != m2.size()) {
            fractions = new float[m2.size()];
        }
        int i3 = 0;
        for (Map.Entry me : m2.entrySet()) {
            fractions[i3] = ((Float)me.getKey()).floatValue();
            colors[i3] = (Color)me.getValue();
            ++i3;
        }
        return init.apply(fractions, colors);
    }

    public static Color HSL2RGB(double h2, double s2, double l2, double alpha) {
        s2 = Math.max(0.0, Math.min(100.0, s2));
        l2 = Math.max(0.0, Math.min(100.0, l2));
        if (alpha < 0.0 || alpha > 1.0) {
            String message = "Color parameter outside of expected range - Alpha: " + alpha;
            throw new IllegalArgumentException(message);
        }
        h2 %= 360.0;
        double q2 = (l2 /= 100.0) < 0.5 ? l2 * (1.0 + s2) : l2 + (s2 /= 100.0) - s2 * l2;
        double p2 = 2.0 * l2 - q2;
        double r2 = Math.max(0.0, DrawPaint.HUE2RGB(p2, q2, (h2 /= 360.0) + 0.3333333333333333));
        double g2 = Math.max(0.0, DrawPaint.HUE2RGB(p2, q2, h2));
        double b2 = Math.max(0.0, DrawPaint.HUE2RGB(p2, q2, h2 - 0.3333333333333333));
        r2 = Math.min(r2, 1.0);
        g2 = Math.min(g2, 1.0);
        b2 = Math.min(b2, 1.0);
        return new Color((float)r2, (float)g2, (float)b2, (float)alpha);
    }

    private static double HUE2RGB(double p2, double q2, double h2) {
        if (h2 < 0.0) {
            h2 += 1.0;
        }
        if (h2 > 1.0) {
            h2 -= 1.0;
        }
        if (6.0 * h2 < 1.0) {
            return p2 + (q2 - p2) * 6.0 * h2;
        }
        if (2.0 * h2 < 1.0) {
            return q2;
        }
        if (3.0 * h2 < 2.0) {
            return p2 + (q2 - p2) * 6.0 * (0.6666666666666666 - h2);
        }
        return p2;
    }

    private static double[] RGB2HSL(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        double r2 = rgb[0];
        double g2 = rgb[1];
        double b2 = rgb[2];
        double min = Math.min(r2, Math.min(g2, b2));
        double max = Math.max(r2, Math.max(g2, b2));
        double h2 = 0.0;
        if (max == min) {
            h2 = 0.0;
        } else if (max == r2) {
            h2 = (60.0 * (g2 - b2) / (max - min) + 360.0) % 360.0;
        } else if (max == g2) {
            h2 = 60.0 * (b2 - r2) / (max - min) + 120.0;
        } else if (max == b2) {
            h2 = 60.0 * (r2 - g2) / (max - min) + 240.0;
        }
        double l2 = (max + min) / 2.0;
        double s2 = max == min ? 0.0 : (l2 <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new double[]{h2, s2 * 100.0, l2 * 100.0};
    }

    public static int srgb2lin(float sRGB) {
        if ((double)sRGB <= 0.04045) {
            return (int)Math.rint(100000.0 * (double)sRGB / 12.92);
        }
        return (int)Math.rint(100000.0 * Math.pow(((double)sRGB + 0.055) / 1.055, 2.4));
    }

    public static float lin2srgb(int linRGB) {
        if ((double)linRGB <= 0.0031308) {
            return (float)((double)linRGB / 100000.0 * 12.92);
        }
        return (float)(1.055 * Math.pow((double)linRGB / 100000.0, 0.4166666666666667) - 0.055);
    }

    static void fillPaintWorkaround(Graphics2D graphics, Shape shape) {
        try {
            graphics.fill(shape);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            LOG.log(5, "IBM JDK failed with TexturePaintContext AIOOBE - try adding the following to the VM parameter:\n-Xjit:exclude={sun/java2d/pipe/AlphaPaintPipe.renderPathTile(Ljava/lang/Object;[BIIIIII)V} and search for 'JIT Problem Determination for IBM SDK using -Xjit' (http://www-01.ibm.com/support/docview.wss?uid=swg21294023) for how to add/determine further excludes", e2);
        }
    }

    private static class SimpleSolidPaint
    implements PaintStyle.SolidPaint {
        private final ColorStyle solidColor;

        SimpleSolidPaint(final Color color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = new AbstractColorStyle(){

                @Override
                public Color getColor() {
                    return new Color(color.getRed(), color.getGreen(), color.getBlue());
                }

                @Override
                public int getAlpha() {
                    return (int)Math.round((double)color.getAlpha() * 100000.0 / 255.0);
                }

                @Override
                public int getHueOff() {
                    return -1;
                }

                @Override
                public int getHueMod() {
                    return -1;
                }

                @Override
                public int getSatOff() {
                    return -1;
                }

                @Override
                public int getSatMod() {
                    return -1;
                }

                @Override
                public int getLumOff() {
                    return -1;
                }

                @Override
                public int getLumMod() {
                    return -1;
                }

                @Override
                public int getShade() {
                    return -1;
                }

                @Override
                public int getTint() {
                    return -1;
                }
            };
        }

        SimpleSolidPaint(ColorStyle color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = color;
        }

        @Override
        public ColorStyle getSolidColor() {
            return this.solidColor;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof PaintStyle.SolidPaint)) {
                return false;
            }
            return Objects.equals(this.getSolidColor(), ((PaintStyle.SolidPaint)o2).getSolidColor());
        }

        public int hashCode() {
            return Objects.hash(this.solidColor);
        }
    }
}

