/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import org.apache.poi.poifs.filesystem.POIFSDocumentPath;

public class DocumentDescriptor {
    private POIFSDocumentPath path;
    private String name;
    private int hashcode;

    public DocumentDescriptor(POIFSDocumentPath path, String name) {
        if (path == null) {
            throw new NullPointerException("path must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.path = path;
        this.name = name;
    }

    public boolean equals(Object o2) {
        boolean rval = false;
        if (o2 != null && o2.getClass() == this.getClass()) {
            if (this == o2) {
                rval = true;
            } else {
                DocumentDescriptor descriptor = (DocumentDescriptor)o2;
                rval = this.path.equals(descriptor.path) && this.name.equals(descriptor.name);
            }
        }
        return rval;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.path.hashCode() ^ this.name.hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(40 * (this.path.length() + 1));
        for (int j2 = 0; j2 < this.path.length(); ++j2) {
            buffer.append(this.path.getComponent(j2)).append("/");
        }
        buffer.append(this.name);
        return buffer.toString();
    }
}

