/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

final class LocalFileRandomAccessContent
extends AbstractRandomAccessContent {
    private static final int BYTE_VALUE_MASK = 255;
    private final RandomAccessFile raf;
    private final InputStream rafis;

    LocalFileRandomAccessContent(File localFile, RandomAccessMode mode) throws FileSystemException {
        super(mode);
        try {
            this.raf = new RandomAccessFile(localFile, mode.getModeString());
            this.rafis = new InputStream(){

                @Override
                public int available() throws IOException {
                    long available = LocalFileRandomAccessContent.this.raf.length() - LocalFileRandomAccessContent.this.raf.getFilePointer();
                    if (available > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)available;
                }

                @Override
                public void close() throws IOException {
                    LocalFileRandomAccessContent.this.raf.close();
                }

                @Override
                public int read() throws IOException {
                    try {
                        return LocalFileRandomAccessContent.this.raf.readByte() & 0xFF;
                    }
                    catch (EOFException e2) {
                        return -1;
                    }
                }

                @Override
                public int read(byte[] b2) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(b2);
                }

                @Override
                public int read(byte[] b2, int off, int len) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(b2, off, len);
                }

                @Override
                public long skip(long n2) throws IOException {
                    LocalFileRandomAccessContent.this.raf.seek(LocalFileRandomAccessContent.this.raf.getFilePointer() + n2);
                    return n2;
                }
            };
        }
        catch (FileNotFoundException e2) {
            throw new FileSystemException("vfs.provider/random-access-open-failed.error", (Object)localFile);
        }
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }

    @Override
    public long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    @Override
    public void readFully(byte[] b2) throws IOException {
        this.raf.readFully(b2);
    }

    @Override
    public void readFully(byte[] b2, int off, int len) throws IOException {
        this.raf.readFully(b2, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.raf.setLength(newLength);
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        return this.raf.skipBytes(n2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.raf.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.raf.write(b2, off, len);
    }

    @Override
    public void write(int b2) throws IOException {
        this.raf.write(b2);
    }

    @Override
    public void writeBoolean(boolean v2) throws IOException {
        this.raf.writeBoolean(v2);
    }

    @Override
    public void writeByte(int v2) throws IOException {
        this.raf.writeByte(v2);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        this.raf.writeBytes(s2);
    }

    @Override
    public void writeChar(int v2) throws IOException {
        this.raf.writeChar(v2);
    }

    @Override
    public void writeChars(String s2) throws IOException {
        this.raf.writeChars(s2);
    }

    @Override
    public void writeDouble(double v2) throws IOException {
        this.raf.writeDouble(v2);
    }

    @Override
    public void writeFloat(float v2) throws IOException {
        this.raf.writeFloat(v2);
    }

    @Override
    public void writeInt(int v2) throws IOException {
        this.raf.writeInt(v2);
    }

    @Override
    public void writeLong(long v2) throws IOException {
        this.raf.writeLong(v2);
    }

    @Override
    public void writeShort(int v2) throws IOException {
        this.raf.writeShort(v2);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.raf.writeUTF(str);
    }
}

