/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsRandomAccessContent
extends AbstractRandomAccessContent {
    private final FSDataInputStream fis;
    private final FileSystem fs;
    private final Path path;

    public HdfsRandomAccessContent(Path path, FileSystem fs) throws IOException {
        super(RandomAccessMode.READ);
        this.fs = fs;
        this.path = path;
        this.fis = this.fs.open(this.path);
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.fis.getPos();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fis;
    }

    @Override
    public long length() throws IOException {
        return this.fs.getFileStatus(this.path).getLen();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.fis.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.fis.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.fis.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.fis.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.fis.readFloat();
    }

    @Override
    public void readFully(byte[] b2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(byte[] b2, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readInt() throws IOException {
        return this.fis.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.fis.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.fis.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.fis.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.fis.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.fis.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.fis.readUTF();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.fis.seek(pos);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        throw new UnsupportedOperationException();
    }
}

