/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FTPClientWrapper;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;

public class FtpFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(FtpFileSystem.class);
    private final AtomicReference<FtpClient> idleClient = new AtomicReference();

    public FtpFileSystem(GenericFileName rootName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.idleClient.set(ftpClient);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(FtpFileProvider.CAPABILITIES);
    }

    private void closeConnection(FtpClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e2) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.ftp/close-connection.error", e2);
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new FtpFileObject(name, this, this.getRootName());
    }

    protected FTPClientWrapper createWrapper() throws FileSystemException {
        return new FTPClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions());
    }

    @Override
    protected void doCloseCommunicationLink() {
        FtpClient idle = this.idleClient.getAndSet(null);
        if (idle != null) {
            this.closeConnection(idle);
        }
    }

    public FtpClient getClient() throws FileSystemException {
        FtpClient client = this.idleClient.getAndSet(null);
        if (client == null || !client.isConnected()) {
            client = this.createWrapper();
        }
        return client;
    }

    public void putClient(FtpClient client) {
        if (!this.idleClient.compareAndSet(null, client)) {
            this.closeConnection(client);
        }
    }
}

