/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class FtpFileObject
extends AbstractFileObject<FtpFileSystem> {
    private static final long DEFAULT_TIMESTAMP = 0L;
    private static final Map<String, FTPFile> EMPTY_FTP_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final FTPFile UNKNOWN = new FTPFile();
    private static final Log log = LogFactory.getLog(FtpFileObject.class);
    private volatile boolean mdtmSet;
    private final String relPath;
    private volatile FTPFile ftpFile;
    private volatile Map<String, FTPFile> childMap;
    private volatile FileObject linkDestination;
    private final AtomicBoolean inRefresh = new AtomicBoolean();

    protected FtpFileObject(AbstractFileName name, FtpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, fileSystem);
        String relPath = UriParser.decode(rootName.getRelativeName(name));
        this.relPath = ".".equals(relPath) ? null : relPath;
    }

    @Override
    protected void doAttach() throws IOException {
    }

    @Override
    protected void doCreateFolder() throws Exception {
        boolean ok;
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ok = client.makeDirectory(this.relPath);
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", (Object)this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.ftpFile != null) {
                boolean ok;
                FtpClient ftpClient = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
                try {
                    ok = this.ftpFile.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
                }
                finally {
                    ((FtpFileSystem)this.getAbstractFileSystem()).putClient(ftpClient);
                }
                if (!ok) {
                    throw new FileSystemException("vfs.provider.ftp/delete-file.error", (Object)this.getName());
                }
                this.ftpFile = null;
            }
            this.childMap = EMPTY_FTP_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.ftpFile = null;
            this.childMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.childMap != null) {
            return;
        }
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            String path = this.ftpFile != null && this.ftpFile.isSymbolicLink() ? this.getFileSystem().getFileSystemManager().resolveName(this.getParent().getName(), this.ftpFile.getLink()).getPath() : this.relPath;
            Object[] tmpChildren = client.listFiles(path);
            if (ArrayUtils.isEmpty(tmpChildren)) {
                this.childMap = EMPTY_FTP_FILE_MAP;
            } else {
                this.childMap = new TreeMap<String, FTPFile>();
                for (int i2 = 0; i2 < tmpChildren.length; ++i2) {
                    Object child = tmpChildren[i2];
                    if (child == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug(Messages.getString("vfs.provider.ftp/invalid-directory-entry.debug", i2, this.relPath));
                        continue;
                    }
                    if (".".equals(((FTPFile)child).getName()) || "..".equals(((FTPFile)child).getName())) continue;
                    this.childMap.put(((FTPFile)child).getName(), (FTPFile)child);
                }
            }
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.ftpFile == null) {
                return 0L;
            }
            if (this.ftpFile.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return this.ftpFile.getSize();
                }
                return linkDest.getContent().getSize();
            }
            return this.ftpFile.getSize();
        }
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            InputStream inputStream = client.retrieveFileStream(this.relPath, 0);
            if (inputStream == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return new FtpInputStream(client, inputStream, bufferSize);
        }
        catch (Exception e2) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetLastModifiedTime() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.ftpFile == null) {
                return 0L;
            }
            if (this.ftpFile.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return this.getTimestampMillis();
                }
                return linkDest.getContent().getLastModifiedTime();
            }
            return this.getTimestampMillis();
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            OutputStream out = bAppend ? client.appendFileStream(this.relPath) : client.storeFileStream(this.relPath);
            FileSystemException.requireNonNull(out, "vfs.provider.ftp/output-error.debug", this.getName(), client.getReplyString());
            return new FtpOutputStream(client, out);
        }
        catch (Exception e2) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e2;
        }
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new FtpRandomAccessContent(this, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.ftpFile == null) {
                this.setFTPFile(false);
            }
            if (this.ftpFile == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.ftpFile.isDirectory()) {
                return FileType.FOLDER;
            }
            if (this.ftpFile.isFile()) {
                return FileType.FILE;
            }
            if (this.ftpFile.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return FileType.IMAGINARY;
                }
                return linkDest.getType();
            }
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", (Object)this.getName());
    }

    @Override
    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        if (this.childMap == null) {
            return null;
        }
        String[] childNames = (String[])this.childMap.values().stream().map(FTPFile::getName).toArray(String[]::new);
        return UriParser.encode(childNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.ftpFile != null && this.ftpFile.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return null;
                }
                return linkDest.getChildren();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRename(FileObject newFile) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            FtpClient ftpClient = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
            try {
                String newName = ((FtpFileObject)FileObjectUtils.getAbstractFileObject(newFile)).getRelPath();
                ok = ftpClient.rename(this.relPath, newName);
            }
            finally {
                ((FtpFileSystem)this.getAbstractFileSystem()).putClient(ftpClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/rename-file.error", this.getName().toString(), newFile);
            }
            this.ftpFile = null;
            this.childMap = EMPTY_FTP_FILE_MAP;
        }
    }

    private FTPFile getChildFile(String name, boolean flush) throws IOException {
        if (flush && !this.inRefresh.get()) {
            this.childMap = null;
        }
        this.doGetChildren();
        return this.childMap != null ? this.childMap.get(name) : null;
    }

    @Override
    public FileObject[] getChildren() throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException(this.getName());
            }
        }
        catch (Exception ex) {
            throw new FileNotFolderException(this.getName(), (Throwable)ex);
        }
        try {
            this.inRefresh.set(true);
            FileObject[] fileObjectArray = super.getChildren();
            return fileObjectArray;
        }
        finally {
            this.inRefresh.set(false);
        }
    }

    FtpInputStream getInputStream(long filePointer) throws IOException {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            InputStream instr = client.retrieveFileStream(this.relPath, filePointer);
            FileSystemException.requireNonNull(instr, "vfs.provider.ftp/input-error.debug", this.getName(), client.getReplyString());
            return new FtpInputStream(client, instr);
        }
        catch (IOException e2) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String path;
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                path = this.ftpFile == null ? null : this.ftpFile.getLink();
            }
            FileName parent = this.getName().getParent();
            FileName relativeTo = parent == null ? this.getName() : parent;
            FileName linkDestinationName = this.getFileSystem().getFileSystemManager().resolveName(relativeTo, path);
            this.linkDestination = this.getFileSystem().resolveFile(linkDestinationName);
        }
        return this.linkDestination;
    }

    String getRelPath() {
        return this.relPath;
    }

    private long getTimestampMillis() throws IOException {
        FtpFileSystem abstractFileSystem = (FtpFileSystem)this.getAbstractFileSystem();
        Boolean mdtmLastModifiedTime = FtpFileSystemConfigBuilder.getInstance().getMdtmLastModifiedTime(abstractFileSystem.getFileSystemOptions());
        if (mdtmLastModifiedTime != null && mdtmLastModifiedTime.booleanValue()) {
            FtpClient client = abstractFileSystem.getClient();
            if (!this.mdtmSet && client.hasFeature("MDTM")) {
                Instant mdtmInstant = client.mdtmInstant(this.relPath);
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                long epochMilli = mdtmInstant.toEpochMilli();
                calendar.setTimeInMillis(epochMilli);
                this.ftpFile.setTimestamp(calendar);
                this.mdtmSet = true;
            }
        }
        return this.ftpFile.getTimestamp().getTime().getTime();
    }

    private boolean isCircular(FileObject linkDest) throws FileSystemException {
        return linkDest.getName().getPathDecoded().equals(this.getName().getPathDecoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChange() throws IOException {
        this.childMap = null;
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.ftpFile = UNKNOWN;
            }
            return;
        }
        this.setFTPFile(true);
    }

    @Override
    protected void onChildrenChanged(FileName child, FileType newType) {
        if (this.childMap != null && newType.equals((Object)FileType.IMAGINARY)) {
            try {
                this.childMap.remove(UriParser.decode(child.getBaseName()));
            }
            catch (FileSystemException e2) {
                throw new RuntimeException(e2.getMessage());
            }
        } else {
            this.childMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws FileSystemException {
        if (this.inRefresh.compareAndSet(false, true)) {
            try {
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.ftpFile = null;
                }
            }
            finally {
                this.inRefresh.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFTPFile(boolean flush) throws IOException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            FTPFile newFileInfo;
            FtpFileObject parent = (FtpFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
            if (parent != null) {
                newFileInfo = parent.getChildFile(UriParser.decode(this.getName().getBaseName()), flush);
            } else {
                newFileInfo = new FTPFile();
                newFileInfo.setType(1);
            }
            this.ftpFile = newFileInfo == null ? UNKNOWN : newFileInfo;
        }
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient client, OutputStream outstr) {
            super(outstr);
            this.client = client;
        }

        @Override
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                ((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", (Object)FtpFileObject.this.getName());
            }
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient client, InputStream in) {
            super(in);
            this.client = client;
        }

        public FtpInputStream(FtpClient client, InputStream in, int bufferSize) {
            super(in, bufferSize);
            this.client = client;
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        private boolean isTransferAbortedOkReplyCode() throws IOException {
            List<Integer> transferAbortedOkReplyCodes = FtpFileSystemConfigBuilder.getInstance().getTransferAbortedOkReplyCodes(((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).getFileSystemOptions());
            return transferAbortedOkReplyCodes != null && transferAbortedOkReplyCodes.contains(this.client.getReplyCode());
        }

        @Override
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand() || this.isTransferAbortedOkReplyCode();
            }
            finally {
                ((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", (Object)FtpFileObject.this.getName());
            }
        }
    }
}

