/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.Messages;

public class DefaultFileReplicator
extends AbstractVfsComponent
implements FileReplicator,
TemporaryFileStore {
    private static final Log log = LogFactory.getLog(DefaultFileReplicator.class);
    private static final int MASK = 65535;
    private static final Random random = new Random();
    private static final char[] TMP_RESERVED_CHARS = new char[]{'?', '/', '\\', ' ', '&', '\"', '\'', '*', '#', ';', ':', '<', '>', '|'};
    private final ArrayList<Object> copies = new ArrayList();
    private long filecount;
    private File tempDir;
    private boolean tempDirMessageLogged;

    public DefaultFileReplicator() {
    }

    public DefaultFileReplicator(File tempDir) {
        this.tempDir = tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(Object file) {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File allocateFile(String baseName) throws FileSystemException {
        String basename = this.createFilename(baseName);
        DefaultFileReplicator defaultFileReplicator = this;
        synchronized (defaultFileReplicator) {
            ++this.filecount;
        }
        return this.createAndAddFile(this.tempDir, basename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String[] list;
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            while (!this.copies.isEmpty()) {
                this.deleteFile((File)this.removeFile());
            }
        }
        if (this.tempDir != null && this.tempDir.exists() && (list = this.tempDir.list()) != null && list.length == 0) {
            this.tempDir.delete();
            this.tempDir = null;
        }
    }

    protected File createAndAddFile(File parent, String basename) throws FileSystemException {
        File file = this.createFile(this.tempDir, basename);
        this.addFile(file);
        return file;
    }

    protected File createFile(File parent, String name) throws FileSystemException {
        return new File(parent, UriParser.decode(name));
    }

    protected String createFilename(String baseName) {
        String safeBasename = UriParser.encode(baseName, TMP_RESERVED_CHARS).replace('%', '_');
        return "tmp_" + this.getFilecount() + "_" + safeBasename;
    }

    protected void deleteFile(File file) {
        try {
            FileObject fileObject = this.getContext().toFileObject(file);
            fileObject.deleteAll();
        }
        catch (FileSystemException e2) {
            String message = Messages.getString("vfs.impl/delete-temp.warn", (Object)file.getName());
            VfsLog.warn(this.getLogger(), log, message, e2);
        }
    }

    protected long getFilecount() {
        return this.filecount;
    }

    @Override
    public void init() throws FileSystemException {
        if (this.tempDir == null) {
            String baseTmpDir = System.getProperty("java.io.tmpdir");
            this.tempDir = new File(baseTmpDir, "vfs_cache").getAbsoluteFile();
        }
        this.filecount = random.nextInt() & 0xFFFF;
        if (!this.tempDirMessageLogged) {
            String message = Messages.getString("vfs.impl/temp-dir.debug", (Object)this.tempDir);
            VfsLog.debug(this.getLogger(), log, message);
            this.tempDirMessageLogged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeFile() {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            return this.copies.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFile(Object file) {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.remove(file);
        }
    }

    @Override
    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        String basename = srcFile.getName().getBaseName();
        File file = this.allocateFile(basename);
        FileObject destFile = this.getContext().toFileObject(file);
        destFile.copyFrom(srcFile, selector);
        return file;
    }
}

