/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Serializable;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.NotFileFilter;

public class CanWriteFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final FileFilter CAN_WRITE = new CanWriteFileFilter();
    public static final FileFilter CANNOT_WRITE = new NotFileFilter(CAN_WRITE);

    protected CanWriteFileFilter() {
    }

    @Override
    public boolean accept(FileSelectInfo fileSelectInfo) throws FileSystemException {
        try (FileObject file = fileSelectInfo.getFile();){
            FileSystem fileSystem = file.getFileSystem();
            if (file.exists()) {
                if (!fileSystem.hasCapability(Capability.WRITE_CONTENT)) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = file.isWriteable();
                return bl3;
            }
            if (!fileSystem.hasCapability(Capability.CREATE)) {
                boolean bl4 = false;
                return bl4;
            }
            boolean bl5 = file.getParent().isWriteable();
            return bl5;
        }
    }
}

