/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

public final class VFS {
    private static FileSystemManager instance;
    private static Boolean uriStyle;

    public static synchronized void close() {
        if (instance != null) {
            instance.close();
            instance = null;
        }
    }

    private static FileSystemManager createFileSystemManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> clazz = Class.forName(managerClassName);
            FileSystemManager manager = (FileSystemManager)clazz.newInstance();
            if (manager instanceof AbstractFileSystem) {
                ((AbstractFileSystem)((Object)manager)).init();
            } else {
                Method method = MethodUtils.getMatchingMethod(clazz, "init", new Class[0]);
                if (method != null) {
                    method.invoke((Object)manager, (Object[])null);
                }
            }
            return manager;
        }
        catch (InvocationTargetException e2) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, e2.getTargetException());
        }
        catch (Exception e3) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, (Throwable)e3);
        }
    }

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = VFS.reset();
        }
        return instance;
    }

    public static boolean isUriStyle() {
        if (uriStyle == null) {
            uriStyle = Boolean.FALSE;
        }
        return uriStyle;
    }

    public static synchronized FileSystemManager reset() throws FileSystemException {
        VFS.close();
        instance = VFS.createFileSystemManager("org.apache.commons.vfs2.impl.StandardFileSystemManager");
        return instance;
    }

    public static synchronized void setManager(FileSystemManager manager) {
        instance = manager;
    }

    public static void setUriStyle(boolean uriStyle) {
        if (VFS.uriStyle != null && VFS.uriStyle != uriStyle) {
            throw new IllegalStateException("VFS.uriStyle was already set differently.");
        }
        VFS.uriStyle = uriStyle;
    }

    private VFS() {
    }
}

