/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.mac;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.mac.MAC;

public class BaseMAC
implements MAC {
    private final String algorithm;
    private final int defbsize;
    private final int bsize;
    private final byte[] tmp;
    private final boolean etm;
    private Mac mac;

    public BaseMAC(String algorithm, int bsize, int defbsize) {
        this(algorithm, bsize, defbsize, false);
    }

    public BaseMAC(String algorithm, int bsize, int defbsize, boolean isEtm) {
        this.algorithm = algorithm;
        this.bsize = bsize;
        this.defbsize = defbsize;
        this.etm = isEtm;
        this.tmp = new byte[defbsize];
    }

    @Override
    public byte[] doFinal() {
        return this.resizeToHashSize(this.mac.doFinal());
    }

    @Override
    public byte[] doFinal(byte[] input) {
        return this.resizeToHashSize(this.mac.doFinal(input));
    }

    @Override
    public void doFinal(byte[] buf, int offset) {
        try {
            if (this.bsize != this.defbsize) {
                this.mac.doFinal(this.tmp, 0);
                System.arraycopy(this.tmp, 0, buf, offset, this.bsize);
            } else {
                this.mac.doFinal(buf, offset);
            }
        }
        catch (ShortBufferException e2) {
            throw new SSHRuntimeException(e2);
        }
    }

    private byte[] resizeToHashSize(byte[] buf) {
        if (this.bsize == this.defbsize) {
            return buf;
        }
        byte[] result = new byte[this.bsize];
        System.arraycopy(buf, 0, result, 0, this.bsize);
        return result;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init(byte[] key) {
        if (key.length > this.defbsize) {
            byte[] tmp = new byte[this.defbsize];
            System.arraycopy(key, 0, tmp, 0, this.defbsize);
            key = tmp;
        }
        SecretKeySpec skey = new SecretKeySpec(key, this.algorithm);
        try {
            this.mac = SecurityUtils.getMAC(this.algorithm);
            this.mac.init(skey);
        }
        catch (GeneralSecurityException e2) {
            throw new SSHRuntimeException(e2);
        }
    }

    @Override
    public void update(byte[] foo, int s2, int l2) {
        this.mac.update(foo, s2, l2);
    }

    @Override
    public void update(byte[] foo) {
        this.mac.update(foo, 0, foo.length);
    }

    @Override
    public void update(long i2) {
        this.tmp[0] = (byte)(i2 >>> 24);
        this.tmp[1] = (byte)(i2 >>> 16);
        this.tmp[2] = (byte)(i2 >>> 8);
        this.tmp[3] = (byte)i2;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public boolean isEtm() {
        return this.etm;
    }
}

