/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.random.Random;

public abstract class DHBase {
    protected final KeyPairGenerator generator;
    protected final KeyAgreement agreement;
    private byte[] e;
    private BigInteger K;

    public DHBase(String generator, String agreement) {
        try {
            this.generator = SecurityUtils.getKeyPairGenerator(generator);
            this.agreement = SecurityUtils.getKeyAgreement(agreement);
        }
        catch (GeneralSecurityException e2) {
            throw new SSHRuntimeException(e2);
        }
    }

    abstract void computeK(byte[] var1) throws GeneralSecurityException;

    public abstract void init(AlgorithmParameterSpec var1, Factory<Random> var2) throws GeneralSecurityException;

    void setE(byte[] e2) {
        this.e = e2;
    }

    void setK(BigInteger k2) {
        this.K = k2;
    }

    public byte[] getE() {
        return this.e;
    }

    public BigInteger getK() {
        return this.K;
    }
}

