/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.SSHPacketHandler;
import net.schmizz.sshj.transport.Converter;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.compression.Compression;
import net.schmizz.sshj.transport.mac.MAC;
import org.slf4j.Logger;

final class Decoder
extends Converter {
    private static final int MAX_PACKET_LEN = 262144;
    private final Logger log;
    private final SSHPacketHandler packetHandler;
    private final SSHPacket inputBuffer = new SSHPacket();
    private final SSHPacket uncompressBuffer = new SSHPacket();
    private byte[] macResult;
    private int packetLength = -1;
    private int needed = 8;

    Decoder(Transport packetHandler) {
        this.packetHandler = packetHandler;
        this.log = packetHandler.getConfig().getLoggerFactory().getLogger(this.getClass());
    }

    private int decode() throws SSHException {
        int need;
        while (true) {
            SSHPacket plain;
            if (this.packetLength == -1) {
                assert (this.inputBuffer.rpos() == 0) : "buffer cleared";
                need = this.cipherSize - this.inputBuffer.available();
                if (need > 0) break;
                if (this.authMode) {
                    this.packetLength = this.decryptLengthAAD();
                    continue;
                }
                if (this.etm) {
                    this.packetLength = this.inputBuffer.readUInt32AsInt();
                    this.checkPacketLength(this.packetLength);
                    continue;
                }
                this.packetLength = this.decryptLength();
                continue;
            }
            assert (this.inputBuffer.rpos() == 4) : "packet length read";
            int n2 = this.authMode ? this.packetLength + this.cipherSize - this.inputBuffer.available() : (need = this.packetLength + (this.mac != null ? this.mac.getBlockSize() : 0) - this.inputBuffer.available());
            if (need > 0) break;
            this.seq = this.seq + 1L & 0xFFFFFFFFL;
            if (this.authMode) {
                this.cipher.update(this.inputBuffer.array(), 4, this.packetLength);
            } else if (this.etm) {
                this.checkMAC(this.inputBuffer.array());
                this.decryptBuffer(4, this.packetLength);
            } else {
                this.decryptBuffer(this.cipherSize, this.packetLength + 4 - this.cipherSize);
                if (this.mac != null) {
                    this.checkMAC(this.inputBuffer.array());
                }
            }
            this.inputBuffer.wpos(this.packetLength + 4 - this.inputBuffer.readByte());
            SSHPacket sSHPacket = plain = this.usingCompression() ? this.decompressed() : this.inputBuffer;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received packet #{}: {}", (Object)this.seq, (Object)plain.printHex());
            }
            this.packetHandler.handle(plain.readMessageID(), plain);
            this.inputBuffer.clear();
            this.packetLength = -1;
        }
        return need;
    }

    private void checkMAC(byte[] data) throws TransportException {
        if (this.mac == null) {
            return;
        }
        this.mac.update(this.seq);
        this.mac.update(data, 0, this.packetLength + 4);
        this.mac.doFinal(this.macResult, 0);
        if (!ByteArrayUtils.equals(this.macResult, 0, data, this.packetLength + 4, this.mac.getBlockSize())) {
            throw new TransportException(DisconnectReason.MAC_ERROR, "MAC Error");
        }
    }

    private SSHPacket decompressed() throws TransportException {
        this.uncompressBuffer.clear();
        this.compression.uncompress(this.inputBuffer, this.uncompressBuffer);
        return this.uncompressBuffer;
    }

    private int decryptLengthAAD() throws TransportException {
        int len;
        this.cipher.setSequenceNumber(this.seq + 1L & 0xFFFFFFFFL);
        this.cipher.updateAAD(this.inputBuffer.array(), 0, 4);
        try {
            len = this.inputBuffer.readUInt32AsInt();
        }
        catch (Buffer.BufferException be2) {
            throw new TransportException(be2);
        }
        this.checkPacketLength(len);
        return len;
    }

    private int decryptLength() throws TransportException {
        int len;
        this.decryptBuffer(0, this.cipherSize);
        try {
            len = this.inputBuffer.readUInt32AsInt();
        }
        catch (Buffer.BufferException be2) {
            throw new TransportException(be2);
        }
        this.checkPacketLength(len);
        return len;
    }

    private void decryptBuffer(int offset, int length) {
        this.cipher.update(this.inputBuffer.array(), offset, length);
    }

    private void checkPacketLength(int len) throws TransportException {
        if (len < 5 || len > 262144) {
            this.log.error("Error decoding packet (invalid length) {}", (Object)this.inputBuffer.printHex());
            throw new TransportException(DisconnectReason.PROTOCOL_ERROR, "invalid packet length: " + len);
        }
    }

    int received(byte[] b2, int len) throws SSHException {
        this.inputBuffer.putRawBytes(b2, 0, len);
        this.needed = this.needed <= len ? this.decode() : (this.needed -= len);
        return this.needed;
    }

    @Override
    void setAlgorithms(Cipher cipher, MAC mac, Compression compression) {
        super.setAlgorithms(cipher, mac, compression);
        if (mac != null) {
            this.macResult = new byte[mac.getBlockSize()];
        }
    }

    @Override
    Compression.Mode getCompressionType() {
        return Compression.Mode.INFLATE;
    }

    int getMaxPacketLength() {
        return 262144;
    }
}

