/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import com.hierynomus.sshj.sftp.RemoteResourceFilterConverter;
import com.hierynomus.sshj.sftp.RemoteResourceSelector;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteResource;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;

public class RemoteDirectory
extends RemoteResource {
    public RemoteDirectory(SFTPEngine requester, String path, byte[] handle) {
        super(requester, path, handle);
    }

    public List<RemoteResourceInfo> scan(RemoteResourceFilter filter) throws IOException {
        return this.scan(RemoteResourceFilterConverter.selectorFrom(filter));
    }

    public List<RemoteResourceInfo> scan(RemoteResourceSelector selector) throws IOException {
        if (selector == null) {
            selector = RemoteResourceSelector.ALL;
        }
        LinkedList<RemoteResourceInfo> remoteResourceInfos = new LinkedList<RemoteResourceInfo>();
        block9: while (true) {
            Response response = this.requester.request(this.newRequest(PacketType.READDIR)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS);
            switch (response.getType()) {
                case NAME: {
                    int count = response.readUInt32AsInt();
                    int i2 = 0;
                    while (true) {
                        if (i2 >= count) continue block9;
                        String name = response.readString(this.requester.sub.getRemoteCharset());
                        response.readString();
                        FileAttributes attrs = response.readFileAttributes();
                        PathComponents comps = this.requester.getPathHelper().getComponents(this.path, name);
                        RemoteResourceInfo inf = new RemoteResourceInfo(comps, attrs);
                        if (!".".equals(name) && !"..".equals(name)) {
                            RemoteResourceSelector.Result selectionResult = selector.select(inf);
                            switch (selectionResult) {
                                case ACCEPT: {
                                    remoteResourceInfos.add(inf);
                                    break;
                                }
                                case CONTINUE: {
                                    break;
                                }
                                case BREAK: {
                                    return remoteResourceInfos;
                                }
                            }
                        }
                        ++i2;
                    }
                }
                case STATUS: {
                    response.ensureStatusIs(Response.StatusCode.EOF);
                    return remoteResourceInfos;
                }
                default: {
                    throw new SFTPException("Unexpected packet: " + (Object)((Object)response.getType()));
                }
            }
            break;
        }
    }
}

