/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannel;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannelOpener;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.transport.TransportException;

public class X11Forwarder
extends AbstractForwardedChannelOpener {
    private final ConnectListener listener;

    public X11Forwarder(Connection conn, ConnectListener listener) {
        super("x11", conn);
        this.listener = listener;
    }

    @Override
    public void handleOpen(SSHPacket buf) throws ConnectionException, TransportException {
        try {
            this.callListener(this.listener, new X11Channel(this.conn, buf.readUInt32AsInt(), buf.readUInt32(), buf.readUInt32(), buf.readString(), buf.readUInt32AsInt()));
        }
        catch (Buffer.BufferException be2) {
            throw new ConnectionException(be2);
        }
    }

    public void stop() {
        this.conn.forget(this);
    }

    public static class X11Channel
    extends AbstractForwardedChannel {
        public static final String TYPE = "x11";

        public X11Channel(Connection conn, int recipient, long remoteWinSize, long remoteMaxPacketSize, String origIP, int origPort) {
            super(conn, TYPE, recipient, remoteWinSize, remoteMaxPacketSize, origIP, origPort);
        }
    }
}

