/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.ErrorDeliveryUtil;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.ChannelInputStream;
import net.schmizz.sshj.connection.channel.ChannelOutputStream;
import net.schmizz.sshj.connection.channel.Window;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;

public abstract class AbstractChannel
implements Channel {
    private static final int REMOTE_MAX_PACKET_SIZE_CEILING = 0x100000;
    protected final LoggerFactory loggerFactory;
    protected final Logger log;
    protected final Transport trans;
    protected final Connection conn;
    private final String type;
    private final int id;
    private int recipient;
    private final Charset remoteCharset;
    private boolean eof = false;
    private final Queue<Event<ConnectionException>> chanReqResponseEvents = new LinkedList<Event<ConnectionException>>();
    private final ReentrantLock openCloseLock = new ReentrantLock();
    protected final Event<ConnectionException> openEvent;
    protected final Event<ConnectionException> closeEvent;
    private boolean closeRequested;
    protected final Window.Local lwin;
    private final ChannelInputStream in;
    protected Window.Remote rwin;
    private ChannelOutputStream out;
    private volatile boolean autoExpand = false;

    protected AbstractChannel(Connection conn, String type) {
        this(conn, type, null);
    }

    protected AbstractChannel(Connection conn, String type, Charset remoteCharset) {
        this.conn = conn;
        this.loggerFactory = conn.getTransport().getConfig().getLoggerFactory();
        this.type = type;
        this.log = this.loggerFactory.getLogger(this.getClass());
        this.trans = conn.getTransport();
        this.remoteCharset = remoteCharset != null ? remoteCharset : IOUtils.UTF8;
        this.id = conn.nextID();
        this.lwin = new Window.Local(conn.getWindowSize(), conn.getMaxPacketSize(), this.loggerFactory);
        this.in = new ChannelInputStream(this, this.trans, this.lwin);
        this.openEvent = new Event<ConnectionException>("chan#" + this.id + " / open", ConnectionException.chainer, this.openCloseLock, this.loggerFactory);
        this.closeEvent = new Event<ConnectionException>("chan#" + this.id + " / close", ConnectionException.chainer, this.openCloseLock, this.loggerFactory);
    }

    protected void init(int recipient, long remoteWinSize, long remoteMaxPacketSize) {
        this.recipient = recipient;
        this.rwin = new Window.Remote(remoteWinSize, (int)Math.min(remoteMaxPacketSize, 0x100000L), this.conn.getTimeoutMs(), this.loggerFactory);
        this.out = new ChannelOutputStream(this, this.trans, this.rwin);
        this.log.debug("Initialized - {}", (Object)this);
    }

    @Override
    public boolean getAutoExpand() {
        return this.autoExpand;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public int getLocalMaxPacketSize() {
        return this.lwin.getMaxPacketSize();
    }

    @Override
    public long getLocalWinSize() {
        return this.lwin.getSize();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public int getRecipient() {
        return this.recipient;
    }

    @Override
    public Charset getRemoteCharset() {
        return this.remoteCharset;
    }

    @Override
    public int getRemoteMaxPacketSize() {
        return this.rwin.getMaxPacketSize();
    }

    @Override
    public long getRemoteWinSize() {
        return this.rwin.getSize();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        switch (msg) {
            case CHANNEL_DATA: {
                this.receiveInto(this.in, buf);
                break;
            }
            case CHANNEL_EXTENDED_DATA: {
                this.gotExtendedData(buf);
                break;
            }
            case CHANNEL_WINDOW_ADJUST: {
                this.gotWindowAdjustment(buf);
                break;
            }
            case CHANNEL_REQUEST: {
                this.gotChannelRequest(buf);
                break;
            }
            case CHANNEL_SUCCESS: {
                this.gotResponse(true);
                break;
            }
            case CHANNEL_FAILURE: {
                this.gotResponse(false);
                break;
            }
            case CHANNEL_EOF: {
                this.gotEOF();
                break;
            }
            case CHANNEL_CLOSE: {
                this.gotClose();
                break;
            }
            default: {
                this.gotUnknown(msg, buf);
            }
        }
    }

    @Override
    public boolean isEOF() {
        return this.eof;
    }

    @Override
    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    private void gotClose() throws TransportException {
        this.log.debug("Got close");
        try {
            this.closeAllStreams();
            this.sendClose();
        }
        finally {
            this.finishOff();
        }
    }

    protected void closeAllStreams() {
        IOUtils.closeQuietly(this.in, this.out);
    }

    @Override
    public void notifyError(SSHException error) {
        this.log.debug("Channel #{} got notified of {}", (Object)this.getID(), (Object)error.toString());
        ErrorDeliveryUtil.alertEvents((Throwable)error, this.openEvent, this.closeEvent);
        ErrorDeliveryUtil.alertEvents((Throwable)error, this.chanReqResponseEvents);
        this.in.notifyError(error);
        if (this.out != null) {
            this.out.notifyError(error);
        }
        this.finishOff();
    }

    @Override
    public void setAutoExpand(boolean autoExpand) {
        this.autoExpand = autoExpand;
    }

    @Override
    public void close() throws ConnectionException, TransportException {
        block5: {
            this.openCloseLock.lock();
            try {
                block6: {
                    if (!this.isOpen()) break block5;
                    try {
                        this.sendClose();
                    }
                    catch (TransportException e2) {
                        if (this.closeEvent.inError()) break block6;
                        throw e2;
                    }
                }
                this.closeEvent.await(this.conn.getTimeoutMs(), TimeUnit.MILLISECONDS);
            }
            finally {
                this.openCloseLock.unlock();
            }
        }
    }

    @Override
    public void join() throws ConnectionException {
        this.closeEvent.await();
    }

    @Override
    public void join(long timeout, TimeUnit unit) throws ConnectionException {
        this.closeEvent.await(timeout, unit);
    }

    protected void sendClose() throws TransportException {
        this.openCloseLock.lock();
        try {
            if (!this.closeRequested) {
                this.log.debug("Sending close");
                this.trans.write(this.newBuffer(Message.CHANNEL_CLOSE));
            }
        }
        finally {
            this.closeRequested = true;
            this.openCloseLock.unlock();
        }
    }

    @Override
    public boolean isOpen() {
        this.openCloseLock.lock();
        try {
            boolean bl2 = this.openEvent.isSet() && !this.closeEvent.isSet() && !this.closeRequested;
            return bl2;
        }
        finally {
            this.openCloseLock.unlock();
        }
    }

    boolean whileOpen(TransportRunnable runnable) throws TransportException, ConnectionException {
        this.openCloseLock.lock();
        try {
            if (this.isOpen()) {
                runnable.run();
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            this.openCloseLock.unlock();
        }
        return false;
    }

    private void gotChannelRequest(SSHPacket buf) throws ConnectionException, TransportException {
        String reqType;
        try {
            reqType = buf.readString();
            buf.readBoolean();
        }
        catch (Buffer.BufferException be2) {
            throw new ConnectionException(be2);
        }
        this.log.debug("Got chan request for `{}`", (Object)reqType);
        this.handleRequest(reqType, buf);
    }

    private void gotWindowAdjustment(SSHPacket buf) throws ConnectionException {
        long howMuch;
        try {
            howMuch = buf.readUInt32();
        }
        catch (Buffer.BufferException be2) {
            throw new ConnectionException(be2);
        }
        this.log.debug("Received window adjustment for {} bytes", (Object)howMuch);
        this.rwin.expand(howMuch);
    }

    protected void finishOff() {
        this.conn.forget(this);
        this.closeEvent.set();
    }

    protected void gotExtendedData(SSHPacket buf) throws SSHException {
        throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Extended data not supported on " + this.type + " channel");
    }

    protected void gotUnknown(Message msg, SSHPacket buf) throws ConnectionException, TransportException {
        this.log.warn("Got unknown packet with type {}", (Object)msg);
    }

    protected void handleRequest(String reqType, SSHPacket buf) throws ConnectionException, TransportException {
        this.trans.write(this.newBuffer(Message.CHANNEL_FAILURE));
    }

    protected SSHPacket newBuffer(Message cmd) {
        return (SSHPacket)new SSHPacket(cmd).putUInt32FromInt(this.recipient);
    }

    protected void receiveInto(ChannelInputStream stream, SSHPacket buf) throws SSHException {
        int len;
        try {
            len = buf.readUInt32AsInt();
        }
        catch (Buffer.BufferException be2) {
            throw new ConnectionException(be2);
        }
        if (len < 0 || len > this.getLocalMaxPacketSize() || len > buf.available()) {
            throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Bad item length: " + len);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("IN #{}: {}", (Object)this.id, (Object)ByteArrayUtils.printHex(buf.array(), buf.rpos(), len));
        }
        stream.receive(buf.array(), buf.rpos(), len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event<ConnectionException> sendChannelRequest(String reqType, boolean wantReply, Buffer.PlainBuffer reqSpecific) throws TransportException {
        this.log.debug("Sending channel request for `{}`", (Object)reqType);
        Queue<Event<ConnectionException>> queue = this.chanReqResponseEvents;
        synchronized (queue) {
            this.trans.write((SSHPacket)((SSHPacket)((SSHPacket)this.newBuffer(Message.CHANNEL_REQUEST).putString(reqType)).putBoolean(wantReply)).putBuffer(reqSpecific));
            Event<ConnectionException> responseEvent = null;
            if (wantReply) {
                responseEvent = new Event<ConnectionException>("chan#" + this.id + " / chanreq for " + reqType, ConnectionException.chainer, this.loggerFactory);
                this.chanReqResponseEvents.add(responseEvent);
            }
            return responseEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotResponse(boolean success) throws ConnectionException {
        Queue<Event<ConnectionException>> queue = this.chanReqResponseEvents;
        synchronized (queue) {
            Event<ConnectionException> responseEvent = this.chanReqResponseEvents.poll();
            if (responseEvent != null) {
                if (success) {
                    responseEvent.set();
                } else {
                    responseEvent.deliverError(new ConnectionException("Request failed"));
                }
            } else {
                throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Received response to channel request when none was requested");
            }
        }
    }

    private void gotEOF() throws TransportException {
        this.log.debug("Got EOF");
        this.eofInputStreams();
    }

    protected void eofInputStreams() {
        this.in.eof();
        this.eof = true;
    }

    public String toString() {
        return "< " + this.type + " channel: id=" + this.id + ", recipient=" + this.recipient + ", localWin=" + this.lwin + ", remoteWin=" + this.rwin + " >";
    }

    public static interface TransportRunnable {
        public void run() throws TransportException, ConnectionException;
    }
}

