/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Event;
import net.schmizz.concurrent.ExceptionChainer;
import net.schmizz.sshj.common.LoggerFactory;
import org.slf4j.Logger;

public class StreamCopier {
    private static final Listener NULL_LISTENER = new Listener(){

        @Override
        public void reportProgress(long transferred) {
        }
    };
    private final LoggerFactory loggerFactory;
    private final Logger log;
    private final InputStream in;
    private final OutputStream out;
    private Listener listener = NULL_LISTENER;
    private int bufSize = 1;
    private boolean keepFlushing = true;
    private long length = -1L;

    public StreamCopier(InputStream in, OutputStream out, LoggerFactory loggerFactory) {
        this.in = in;
        this.out = out;
        this.loggerFactory = loggerFactory;
        this.log = loggerFactory.getLogger(this.getClass());
    }

    public StreamCopier bufSize(int bufSize) {
        this.bufSize = bufSize;
        return this;
    }

    public StreamCopier keepFlushing(boolean keepFlushing) {
        this.keepFlushing = keepFlushing;
        return this;
    }

    public StreamCopier listener(Listener listener) {
        this.listener = listener == null ? NULL_LISTENER : listener;
        return this;
    }

    public StreamCopier length(long length) {
        this.length = length;
        return this;
    }

    public Event<IOException> spawn(String name) {
        return this.spawn(name, false);
    }

    public Event<IOException> spawnDaemon(String name) {
        return this.spawn(name, true);
    }

    private Event<IOException> spawn(final String name, final boolean daemon) {
        final Event<IOException> doneEvent = new Event<IOException>("copyDone", new ExceptionChainer<IOException>(){

            @Override
            public IOException chain(Throwable t2) {
                return t2 instanceof IOException ? (IOException)t2 : new IOException(t2);
            }
        }, this.loggerFactory);
        new Thread(){
            {
                this.setName(name);
                this.setDaemon(daemon);
            }

            @Override
            public void run() {
                try {
                    StreamCopier.this.log.debug("Will copy from {} to {}", (Object)StreamCopier.this.in, (Object)StreamCopier.this.out);
                    StreamCopier.this.copy();
                    StreamCopier.this.log.debug("Done copying from {}", (Object)StreamCopier.this.in);
                    doneEvent.set();
                }
                catch (IOException ioe) {
                    StreamCopier.this.log.error(String.format("In pipe from %1$s to %2$s", StreamCopier.this.in.toString(), StreamCopier.this.out.toString()), ioe);
                    doneEvent.deliverError(ioe);
                }
            }
        }.start();
        return doneEvent;
    }

    public long copy() throws IOException {
        long count;
        byte[] buf = new byte[this.bufSize];
        int read = 0;
        long startTime = System.nanoTime();
        if (this.length == -1L) {
            while ((read = this.in.read(buf)) != -1) {
                count += this.write(buf, count, read);
            }
        } else {
            for (count = 0L; count < this.length && (read = this.in.read(buf, 0, (int)Math.min((long)this.bufSize, this.length - count))) != -1; count += this.write(buf, count, read)) {
            }
        }
        if (!this.keepFlushing) {
            this.out.flush();
        }
        double timeSeconds = (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) / 1000.0;
        double sizeKiB = (double)count / 1024.0;
        this.log.debug(String.format("%1$,.1f KiB transferred in %2$,.1f seconds (%3$,.2f KiB/s)", sizeKiB, timeSeconds, sizeKiB / timeSeconds));
        if (read == -1) {
            this.out.close();
            if (this.length != -1L) {
                throw new IOException("Encountered EOF, could not transfer " + this.length + " bytes");
            }
        }
        return count;
    }

    private long write(byte[] buf, long curPos, int len) throws IOException {
        this.out.write(buf, 0, len);
        if (this.keepFlushing) {
            this.out.flush();
        }
        this.listener.reportProgress(curPos + (long)len);
        return len;
    }

    public static interface Listener {
        public void reportProgress(long var1) throws IOException;
    }
}

