/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import com.hierynomus.sshj.common.ThreadNameProvider;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.LoginContext;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.SocketClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.ConnectionImpl;
import net.schmizz.sshj.connection.channel.direct.DirectConnection;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionChannel;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.RemotePortForwarder;
import net.schmizz.sshj.connection.channel.forwarded.X11Forwarder;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.StatefulSFTPClient;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.TransportImpl;
import net.schmizz.sshj.transport.compression.DelayedZlibCompression;
import net.schmizz.sshj.transport.compression.NoneCompression;
import net.schmizz.sshj.transport.compression.ZlibCompression;
import net.schmizz.sshj.transport.verification.AlgorithmsVerifier;
import net.schmizz.sshj.transport.verification.FingerprintVerifier;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import net.schmizz.sshj.userauth.UserAuth;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.UserAuthImpl;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyPairWrapper;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import net.schmizz.sshj.userauth.method.AuthGssApiWithMic;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUpdateProvider;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.userauth.password.Resource;
import net.schmizz.sshj.xfer.scp.SCPFileTransfer;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;

public class SSHClient
extends SocketClient
implements Closeable,
SessionFactory {
    public static final int DEFAULT_PORT = 22;
    protected final LoggerFactory loggerFactory;
    protected final Logger log;
    protected final Transport trans;
    protected final UserAuth auth;
    protected final Connection conn;
    private final List<LocalPortForwarder> forwarders = new ArrayList<LocalPortForwarder>();
    protected Charset remoteCharset = IOUtils.UTF8;

    public SSHClient() {
        this(new DefaultConfig());
    }

    public SSHClient(Config config) {
        super(22);
        this.loggerFactory = config.getLoggerFactory();
        this.log = this.loggerFactory.getLogger(this.getClass());
        this.trans = new TransportImpl(config);
        this.auth = new UserAuthImpl(this.trans);
        this.conn = new ConnectionImpl(this.trans, config.getKeepAliveProvider());
    }

    public void addHostKeyVerifier(HostKeyVerifier verifier) {
        this.trans.addHostKeyVerifier(verifier);
    }

    public void addAlgorithmsVerifier(AlgorithmsVerifier verifier) {
        this.trans.addAlgorithmsVerifier(verifier);
    }

    public void addHostKeyVerifier(String fingerprint) {
        this.addHostKeyVerifier(FingerprintVerifier.getInstance(fingerprint));
    }

    public void auth(String username, AuthMethod ... methods) throws UserAuthException, TransportException {
        this.checkConnected();
        this.auth(username, Arrays.asList(methods));
    }

    public void auth(String username, Iterable<AuthMethod> methods) throws UserAuthException, TransportException {
        this.checkConnected();
        LinkedList<UserAuthException> savedEx = new LinkedList<UserAuthException>();
        for (AuthMethod method : methods) {
            method.setLoggerFactory(this.loggerFactory);
            try {
                if (!this.auth.authenticate(username, (Service)((Object)this.conn), method, this.trans.getTimeoutMs())) continue;
                return;
            }
            catch (UserAuthException e2) {
                savedEx.push(e2);
            }
        }
        throw new UserAuthException("Exhausted available authentication methods", (Throwable)savedEx.peek());
    }

    public void authPassword(String username, String password) throws UserAuthException, TransportException {
        this.authPassword(username, password.toCharArray());
    }

    public void authPassword(String username, final char[] password) throws UserAuthException, TransportException {
        try {
            this.authPassword(username, new PasswordFinder(){

                @Override
                public char[] reqPassword(Resource<?> resource) {
                    return (char[])password.clone();
                }

                @Override
                public boolean shouldRetry(Resource<?> resource) {
                    return false;
                }
            });
        }
        finally {
            PasswordUtils.blankOut(password);
        }
    }

    public void authPassword(String username, PasswordFinder pfinder) throws UserAuthException, TransportException {
        this.auth(username, new AuthPassword(pfinder), new AuthKeyboardInteractive(new PasswordResponseProvider(pfinder)));
    }

    public void authPassword(String username, PasswordFinder pfinder, PasswordUpdateProvider newPasswordProvider) throws UserAuthException, TransportException {
        this.auth(username, new AuthPassword(pfinder, newPasswordProvider), new AuthKeyboardInteractive(new PasswordResponseProvider(pfinder)));
    }

    public void authPublickey(String username) throws UserAuthException, TransportException {
        String base = System.getProperty("user.home") + File.separator + ".ssh" + File.separator;
        this.authPublickey(username, base + "id_rsa", base + "id_dsa", base + "id_ed25519", base + "id_ecdsa");
    }

    public void authPublickey(String username, Iterable<KeyProvider> keyProviders) throws UserAuthException, TransportException {
        LinkedList<AuthMethod> am2 = new LinkedList<AuthMethod>();
        for (KeyProvider kp : keyProviders) {
            am2.add(new AuthPublickey(kp));
        }
        this.auth(username, am2);
    }

    public void authPublickey(String username, KeyProvider ... keyProviders) throws UserAuthException, TransportException {
        this.authPublickey(username, Arrays.asList(keyProviders));
    }

    public void authPublickey(String username, String ... locations) throws UserAuthException, TransportException {
        LinkedList<KeyProvider> keyProviders = new LinkedList<KeyProvider>();
        for (String loc : locations) {
            try {
                this.log.debug("Attempting to load key from: {}", (Object)loc);
                keyProviders.add(this.loadKeys(loc));
            }
            catch (IOException logged) {
                this.log.info("Could not load keys from {} due to: {}", (Object)loc, (Object)logged.getMessage());
            }
        }
        this.authPublickey(username, keyProviders);
    }

    public void authGssApiWithMic(String username, LoginContext context, Oid supportedOid, Oid ... supportedOids) throws UserAuthException, TransportException {
        ArrayList<Oid> oids = new ArrayList<Oid>(Arrays.asList(supportedOids));
        oids.add(0, supportedOid);
        this.auth(username, new AuthGssApiWithMic(context, oids));
    }

    @Override
    public void disconnect() throws IOException {
        this.conn.getKeepAlive().interrupt();
        for (LocalPortForwarder forwarder : this.forwarders) {
            try {
                forwarder.close();
            }
            catch (IOException e2) {
                this.log.warn("Error closing forwarder", e2);
            }
        }
        this.forwarders.clear();
        this.trans.disconnect();
        super.disconnect();
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.trans.getRemoteSocketAddress();
    }

    public Charset getRemoteCharset() {
        return this.remoteCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotePortForwarder getRemotePortForwarder() {
        Connection connection = this.conn;
        synchronized (connection) {
            RemotePortForwarder rpf = (RemotePortForwarder)this.conn.get("forwarded-tcpip");
            if (rpf == null) {
                rpf = new RemotePortForwarder(this.conn);
                this.conn.attach(rpf);
            }
            return rpf;
        }
    }

    public Transport getTransport() {
        return this.trans;
    }

    public UserAuth getUserAuth() {
        return this.auth;
    }

    public boolean isAuthenticated() {
        return this.trans.isAuthenticated();
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() && this.trans.isRunning();
    }

    public KeyProvider loadKeys(KeyPair kp) {
        return new KeyPairWrapper(kp);
    }

    public KeyProvider loadKeys(String location) throws IOException {
        return this.loadKeys(location, (PasswordFinder)null);
    }

    public KeyProvider loadKeys(String location, char[] passphrase) throws IOException {
        return this.loadKeys(location, PasswordUtils.createOneOff(passphrase));
    }

    public KeyProvider loadKeys(String location, PasswordFinder passwordFinder) throws IOException {
        File loc = new File(location);
        KeyFormat format = KeyProviderUtil.detectKeyFileFormat(loc);
        FileKeyProvider fkp = (FileKeyProvider)Factory.Named.Util.create(this.trans.getConfig().getFileKeyProviderFactories(), format.toString());
        if (fkp == null) {
            throw new SSHException("No provider available for " + (Object)((Object)format) + " key file");
        }
        fkp.init(loc, passwordFinder);
        return fkp;
    }

    public KeyProvider loadKeys(String location, String passphrase) throws IOException {
        return this.loadKeys(location, passphrase.toCharArray());
    }

    public KeyProvider loadKeys(String privateKey, String publicKey, PasswordFinder passwordFinder) throws IOException {
        KeyFormat format = KeyProviderUtil.detectKeyFileFormat(privateKey, publicKey != null);
        FileKeyProvider fkp = (FileKeyProvider)Factory.Named.Util.create(this.trans.getConfig().getFileKeyProviderFactories(), format.toString());
        if (fkp == null) {
            throw new SSHException("No provider available for " + (Object)((Object)format) + " key file");
        }
        fkp.init(privateKey, publicKey, passwordFinder);
        return fkp;
    }

    public void loadKnownHosts() throws IOException {
        boolean loaded = false;
        File sshDir = OpenSSHKnownHosts.detectSSHDir();
        if (sshDir != null) {
            for (File loc : Arrays.asList(new File(sshDir, "known_hosts"), new File(sshDir, "known_hosts2"))) {
                try {
                    this.loadKnownHosts(loc);
                    loaded = true;
                }
                catch (IOException iOException) {}
            }
        }
        if (!loaded) {
            throw new IOException("Could not load known_hosts");
        }
    }

    public void loadKnownHosts(File location) throws IOException {
        this.addHostKeyVerifier(new OpenSSHKnownHosts(location, this.loggerFactory));
    }

    public LocalPortForwarder newLocalPortForwarder(Parameters parameters, ServerSocket serverSocket) {
        LocalPortForwarder forwarder = new LocalPortForwarder(this.conn, parameters, serverSocket, this.loggerFactory);
        this.forwarders.add(forwarder);
        return forwarder;
    }

    public DirectConnection newDirectConnection(String hostname, int port) throws IOException {
        DirectConnection tunnel = new DirectConnection(this.conn, hostname, port);
        tunnel.open();
        return tunnel;
    }

    public X11Forwarder registerX11Forwarder(ConnectListener listener) {
        X11Forwarder x11f = new X11Forwarder(this.conn, listener);
        this.conn.attach(x11f);
        return x11f;
    }

    public SCPFileTransfer newSCPFileTransfer() {
        this.checkConnected();
        this.checkAuthenticated();
        return new SCPFileTransfer(this, this.loggerFactory);
    }

    public SFTPClient newSFTPClient() throws IOException {
        this.checkConnected();
        this.checkAuthenticated();
        return new SFTPClient(this);
    }

    public StatefulSFTPClient newStatefulSFTPClient() throws IOException {
        this.checkConnected();
        this.checkAuthenticated();
        return new StatefulSFTPClient(this);
    }

    public void rekey() throws TransportException {
        this.doKex();
    }

    public void setRemoteCharset(Charset remoteCharset) {
        this.remoteCharset = remoteCharset != null ? remoteCharset : IOUtils.UTF8;
    }

    @Override
    public Session startSession() throws ConnectionException, TransportException {
        this.checkConnected();
        this.checkAuthenticated();
        SessionChannel sess = new SessionChannel(this.conn, this.remoteCharset);
        sess.open();
        return sess;
    }

    public void useCompression() throws TransportException {
        this.trans.getConfig().setCompressionFactories(Arrays.asList(new DelayedZlibCompression.Factory(), new ZlibCompression.Factory(), new NoneCompression.Factory()));
        if (this.isConnected()) {
            this.rekey();
        }
    }

    @Override
    protected void onConnect() throws IOException {
        super.onConnect();
        this.trans.init(this.getRemoteHostname(), this.getRemotePort(), this.getInputStream(), this.getOutputStream());
        this.doKex();
        KeepAlive keepAliveThread = this.conn.getKeepAlive();
        if (keepAliveThread.isEnabled()) {
            ThreadNameProvider.setThreadName(this.conn.getKeepAlive(), this.trans);
            keepAliveThread.start();
        }
    }

    protected void doKex() throws TransportException {
        this.checkConnected();
        long start = System.currentTimeMillis();
        this.trans.doKex();
        this.log.debug("Key exchange took {} seconds", (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    private void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private void checkAuthenticated() {
        if (!this.isAuthenticated()) {
            throw new IllegalStateException("Not authenticated");
        }
    }
}

