/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.keepalive;

import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.ConnectionImpl;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;

public abstract class KeepAlive
extends Thread {
    protected final Logger log;
    protected final ConnectionImpl conn;
    protected int keepAliveInterval = 0;

    protected KeepAlive(ConnectionImpl conn, String name) {
        this.conn = conn;
        this.log = conn.getTransport().getConfig().getLoggerFactory().getLogger(this.getClass());
        this.setName(name);
        this.setDaemon(true);
    }

    public boolean isEnabled() {
        return this.keepAliveInterval > 0;
    }

    public synchronized int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public synchronized void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    @Override
    public void run() {
        block5: {
            this.log.debug("{} Started with interval [{} seconds]", (Object)this.getClass().getSimpleName(), (Object)this.keepAliveInterval);
            try {
                while (!this.isInterrupted()) {
                    int interval = this.getKeepAliveInterval();
                    if (this.conn.getTransport().isRunning()) {
                        this.log.debug("{} Sending after interval [{} seconds]", (Object)this.getClass().getSimpleName(), (Object)interval);
                        this.doKeepAlive();
                    }
                    TimeUnit.SECONDS.sleep(interval);
                }
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                this.log.trace("{} Interrupted while sleeping", (Object)this.getClass().getSimpleName());
            }
            catch (Exception e3) {
                if (this.isInterrupted()) break block5;
                this.conn.getTransport().die(e3);
            }
        }
        this.log.debug("{} Stopped", (Object)this.getClass().getSimpleName());
    }

    protected abstract void doKeepAlive() throws TransportException, ConnectionException;
}

