/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.ExceptionChainer;
import net.schmizz.sshj.common.LoggerFactory;
import org.slf4j.Logger;

public class Promise<V, T extends Throwable> {
    private final Logger log;
    private final String name;
    private final ExceptionChainer<T> chainer;
    private final ReentrantLock lock;
    private final Condition cond;
    private V val;
    private T pendingEx;

    public Promise(String name, ExceptionChainer<T> chainer, LoggerFactory loggerFactory) {
        this(name, chainer, null, loggerFactory);
    }

    public Promise(String name, ExceptionChainer<T> chainer, ReentrantLock lock, LoggerFactory loggerFactory) {
        this.name = name;
        this.chainer = chainer;
        this.lock = lock == null ? new ReentrantLock() : lock;
        this.log = loggerFactory.getLogger(this.getClass());
        this.cond = this.lock.newCondition();
    }

    public void deliver(V val) {
        this.lock.lock();
        try {
            this.log.debug("Setting <<{}>> to `{}`", (Object)this.name, (Object)val);
            this.val = val;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deliverError(Throwable e2) {
        this.lock.lock();
        try {
            this.pendingEx = this.chainer.chain(e2);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.pendingEx = null;
            this.log.debug("Clearing <<{}>>", (Object)this.name);
            this.val = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public V retrieve() throws T {
        return this.tryRetrieve(0L, TimeUnit.SECONDS);
    }

    public V retrieve(long timeout, TimeUnit unit) throws T {
        V value = this.tryRetrieve(timeout, unit);
        if (value == null) {
            throw this.chainer.chain(new TimeoutException("Timeout expired: " + timeout + " " + (Object)((Object)unit)));
        }
        return value;
    }

    public V tryRetrieve(long timeout, TimeUnit unit) throws T {
        this.lock.lock();
        try {
            if (this.pendingEx != null) {
                throw this.pendingEx;
            }
            if (this.val != null) {
                V v2 = this.val;
                return v2;
            }
            this.log.debug("Awaiting <<{}>>", (Object)this.name);
            if (timeout == 0L) {
                while (this.val == null && this.pendingEx == null) {
                    this.cond.await();
                }
            } else if (!this.cond.await(timeout, unit)) {
                V v3 = null;
                return v3;
            }
            if (this.pendingEx != null) {
                this.log.error("<<{}>> woke to: {}", (Object)this.name, (Object)((Throwable)this.pendingEx).toString());
                throw this.pendingEx;
            }
            V v4 = this.val;
            return v4;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw this.chainer.chain(ie);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDelivered() {
        this.lock.lock();
        try {
            boolean bl2 = this.pendingEx == null && this.val != null;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean inError() {
        this.lock.lock();
        try {
            boolean bl2 = this.pendingEx != null;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isFulfilled() {
        this.lock.lock();
        try {
            boolean bl2 = this.pendingEx != null || this.val != null;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasWaiters() {
        this.lock.lock();
        try {
            boolean bl2 = this.lock.hasWaiters(this.cond);
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public String toString() {
        return this.name;
    }
}

