/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.security.spec.KeySpec;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;

public class EdDSAPublicKeySpec
implements KeySpec {
    private final GroupElement A;
    private final GroupElement Aneg;
    private final EdDSAParameterSpec spec;

    public EdDSAPublicKeySpec(byte[] pk, EdDSAParameterSpec spec) {
        if (pk.length != spec.getCurve().getField().getb() / 8) {
            throw new IllegalArgumentException("public-key length is wrong");
        }
        this.A = new GroupElement(spec.getCurve(), pk);
        this.Aneg = this.A.negate();
        this.Aneg.precompute(false);
        this.spec = spec;
    }

    public EdDSAPublicKeySpec(GroupElement A2, EdDSAParameterSpec spec) {
        this.A = A2;
        this.Aneg = A2.negate();
        this.Aneg.precompute(false);
        this.spec = spec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        return this.Aneg;
    }

    public EdDSAParameterSpec getParams() {
        return this.spec;
    }
}

