/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.bigint;

import java.io.Serializable;
import java.math.BigInteger;
import net.i2p.crypto.eddsa.math.Encoding;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.bigint.BigIntegerFieldElement;

public class BigIntegerLittleEndianEncoding
extends Encoding
implements Serializable {
    private static final long serialVersionUID = 3984579843759837L;
    private BigInteger mask;

    @Override
    public synchronized void setField(Field f2) {
        super.setField(f2);
        this.mask = BigInteger.ONE.shiftLeft(f2.getb() - 1).subtract(BigInteger.ONE);
    }

    @Override
    public byte[] encode(FieldElement x2) {
        return this.encode(((BigIntegerFieldElement)x2).bi.and(this.mask));
    }

    public byte[] encode(BigInteger x2) {
        int i2;
        if (this.f == null) {
            throw new IllegalStateException("field not set");
        }
        byte[] in = x2.toByteArray();
        byte[] out = new byte[this.f.getb() / 8];
        for (i2 = 0; i2 < in.length; ++i2) {
            out[i2] = in[in.length - 1 - i2];
        }
        for (i2 = in.length; i2 < out.length; ++i2) {
            out[i2] = 0;
        }
        return out;
    }

    @Override
    public FieldElement decode(byte[] in) {
        if (this.f == null) {
            throw new IllegalStateException("field not set");
        }
        if (in.length != this.f.getb() / 8) {
            throw new IllegalArgumentException("Not a valid encoding");
        }
        return new BigIntegerFieldElement(this.f, this.toBigInteger(in).and(this.mask));
    }

    public BigInteger toBigInteger(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i2 = 0; i2 < in.length; ++i2) {
            out[i2] = in[in.length - 1 - i2];
        }
        return new BigInteger(1, out);
    }

    @Override
    public boolean isNegative(FieldElement x2) {
        return ((BigIntegerFieldElement)x2).bi.testBit(0);
    }
}

