/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math;

import java.io.Serializable;
import java.util.Arrays;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.FieldElement;

public class GroupElement
implements Serializable {
    private static final long serialVersionUID = 2395879087349587L;
    final Curve curve;
    final Representation repr;
    final FieldElement X;
    final FieldElement Y;
    final FieldElement Z;
    final FieldElement T;
    GroupElement[][] precmp;
    GroupElement[] dblPrecmp;

    public static GroupElement p2(Curve curve, FieldElement X2, FieldElement Y2, FieldElement Z2) {
        return new GroupElement(curve, Representation.P2, X2, Y2, Z2, null);
    }

    public static GroupElement p3(Curve curve, FieldElement X2, FieldElement Y2, FieldElement Z2, FieldElement T2) {
        return new GroupElement(curve, Representation.P3, X2, Y2, Z2, T2);
    }

    public static GroupElement p1p1(Curve curve, FieldElement X2, FieldElement Y2, FieldElement Z2, FieldElement T2) {
        return new GroupElement(curve, Representation.P1P1, X2, Y2, Z2, T2);
    }

    public static GroupElement precomp(Curve curve, FieldElement ypx, FieldElement ymx, FieldElement xy2d) {
        return new GroupElement(curve, Representation.PRECOMP, ypx, ymx, xy2d, null);
    }

    public static GroupElement cached(Curve curve, FieldElement YpX, FieldElement YmX, FieldElement Z2, FieldElement T2d) {
        return new GroupElement(curve, Representation.CACHED, YpX, YmX, Z2, T2d);
    }

    public GroupElement(Curve curve, Representation repr, FieldElement X2, FieldElement Y2, FieldElement Z2, FieldElement T2) {
        this.curve = curve;
        this.repr = repr;
        this.X = X2;
        this.Y = Y2;
        this.Z = Z2;
        this.T = T2;
    }

    public GroupElement(Curve curve, byte[] s2) {
        FieldElement y2 = curve.getField().fromByteArray(s2);
        FieldElement yy = y2.square();
        FieldElement u2 = yy.subtractOne();
        FieldElement v2 = yy.multiply(curve.getD()).addOne();
        FieldElement v3 = v2.square().multiply(v2);
        FieldElement x2 = v3.square().multiply(v2).multiply(u2);
        x2 = x2.pow22523();
        x2 = v3.multiply(u2).multiply(x2);
        FieldElement vxx = x2.square().multiply(v2);
        FieldElement check = vxx.subtract(u2);
        if (check.isNonZero()) {
            check = vxx.add(u2);
            if (check.isNonZero()) {
                throw new IllegalArgumentException("not a valid GroupElement");
            }
            x2 = x2.multiply(curve.getI());
        }
        if ((x2.isNegative() ? 1 : 0) != Utils.bit(s2, curve.getField().getb() - 1)) {
            x2 = x2.negate();
        }
        this.curve = curve;
        this.repr = Representation.P3;
        this.X = x2;
        this.Y = y2;
        this.Z = curve.getField().ONE;
        this.T = this.X.multiply(this.Y);
    }

    public Curve getCurve() {
        return this.curve;
    }

    public Representation getRepresentation() {
        return this.repr;
    }

    public FieldElement getX() {
        return this.X;
    }

    public FieldElement getY() {
        return this.Y;
    }

    public FieldElement getZ() {
        return this.Z;
    }

    public FieldElement getT() {
        return this.T;
    }

    public byte[] toByteArray() {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement recip = this.Z.invert();
                FieldElement x2 = this.X.multiply(recip);
                FieldElement y2 = this.Y.multiply(recip);
                byte[] s2 = y2.toByteArray();
                int n2 = s2.length - 1;
                s2[n2] = (byte)(s2[n2] | (x2.isNegative() ? -128 : 0));
                return s2;
            }
        }
        return this.toP2().toByteArray();
    }

    public GroupElement toP2() {
        return this.toRep(Representation.P2);
    }

    public GroupElement toP3() {
        return this.toRep(Representation.P3);
    }

    public GroupElement toCached() {
        return this.toRep(Representation.CACHED);
    }

    private GroupElement toRep(Representation repr) {
        switch (this.repr) {
            case P2: {
                switch (repr) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case P3: {
                switch (repr) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.Y.add(this.X), this.Y.subtract(this.X), this.Z, this.T.multiply(this.curve.get2D()));
                    }
                }
                throw new IllegalArgumentException();
            }
            case P1P1: {
                switch (repr) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T));
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y));
                    }
                    case P1P1: {
                        return GroupElement.p1p1(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
            case PRECOMP: {
                switch (repr) {
                    case PRECOMP: {
                        return GroupElement.precomp(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case CACHED: {
                switch (repr) {
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public synchronized void precompute(boolean precomputeSingle) {
        int i2;
        GroupElement Bi;
        if (precomputeSingle && this.precmp == null) {
            this.precmp = new GroupElement[32][8];
            Bi = this;
            for (i2 = 0; i2 < 32; ++i2) {
                GroupElement Bij = Bi;
                for (int j2 = 0; j2 < 8; ++j2) {
                    FieldElement recip = Bij.Z.invert();
                    FieldElement x2 = Bij.X.multiply(recip);
                    FieldElement y2 = Bij.Y.multiply(recip);
                    this.precmp[i2][j2] = GroupElement.precomp(this.curve, y2.add(x2), y2.subtract(x2), x2.multiply(y2).multiply(this.curve.get2D()));
                    Bij = Bij.add(Bi.toCached()).toP3();
                }
                for (int k2 = 0; k2 < 8; ++k2) {
                    Bi = Bi.add(Bi.toCached()).toP3();
                }
            }
        }
        if (this.dblPrecmp != null) {
            return;
        }
        this.dblPrecmp = new GroupElement[8];
        Bi = this;
        for (i2 = 0; i2 < 8; ++i2) {
            FieldElement recip = Bi.Z.invert();
            FieldElement x3 = Bi.X.multiply(recip);
            FieldElement y3 = Bi.Y.multiply(recip);
            this.dblPrecmp[i2] = GroupElement.precomp(this.curve, y3.add(x3), y3.subtract(x3), x3.multiply(y3).multiply(this.curve.get2D()));
            Bi = this.add(this.add(Bi.toCached()).toP3().toCached()).toP3();
        }
    }

    public GroupElement dbl() {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement XX = this.X.square();
                FieldElement YY = this.Y.square();
                FieldElement B2 = this.Z.squareAndDouble();
                FieldElement A2 = this.X.add(this.Y);
                FieldElement AA = A2.square();
                FieldElement Yn = YY.add(XX);
                FieldElement Zn = YY.subtract(XX);
                return GroupElement.p1p1(this.curve, AA.subtract(Yn), Yn, Zn, B2.subtract(Zn));
            }
        }
        throw new UnsupportedOperationException();
    }

    private GroupElement madd(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A2 = YpX.multiply(q2.X);
        FieldElement B2 = YmX.multiply(q2.Y);
        FieldElement C2 = q2.Z.multiply(this.T);
        FieldElement D2 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, A2.subtract(B2), A2.add(B2), D2.add(C2), D2.subtract(C2));
    }

    private GroupElement msub(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A2 = YpX.multiply(q2.Y);
        FieldElement B2 = YmX.multiply(q2.X);
        FieldElement C2 = q2.Z.multiply(this.T);
        FieldElement D2 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, A2.subtract(B2), A2.add(B2), D2.subtract(C2), D2.add(C2));
    }

    public GroupElement add(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A2 = YpX.multiply(q2.X);
        FieldElement B2 = YmX.multiply(q2.Y);
        FieldElement C2 = q2.T.multiply(this.T);
        FieldElement ZZ = this.Z.multiply(q2.Z);
        FieldElement D2 = ZZ.add(ZZ);
        return GroupElement.p1p1(this.curve, A2.subtract(B2), A2.add(B2), D2.add(C2), D2.subtract(C2));
    }

    public GroupElement sub(GroupElement q2) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (q2.repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement YpX = this.Y.add(this.X);
        FieldElement YmX = this.Y.subtract(this.X);
        FieldElement A2 = YpX.multiply(q2.Y);
        FieldElement B2 = YmX.multiply(q2.X);
        FieldElement C2 = q2.T.multiply(this.T);
        FieldElement ZZ = this.Z.multiply(q2.Z);
        FieldElement D2 = ZZ.add(ZZ);
        return GroupElement.p1p1(this.curve, A2.subtract(B2), A2.add(B2), D2.subtract(C2), D2.add(C2));
    }

    public GroupElement negate() {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        return this.curve.getZero(Representation.P3).sub(this.toCached()).toP3();
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroupElement)) {
            return false;
        }
        GroupElement ge = (GroupElement)obj;
        if (!this.repr.equals((Object)ge.repr)) {
            try {
                ge = ge.toRep(this.repr);
            }
            catch (RuntimeException e2) {
                return false;
            }
        }
        switch (this.repr) {
            case P2: 
            case P3: {
                if (this.Z.equals(ge.Z)) {
                    return this.X.equals(ge.X) && this.Y.equals(ge.Y);
                }
                FieldElement x1 = this.X.multiply(ge.Z);
                FieldElement y1 = this.Y.multiply(ge.Z);
                FieldElement x2 = ge.X.multiply(this.Z);
                FieldElement y2 = ge.Y.multiply(this.Z);
                return x1.equals(x2) && y1.equals(y2);
            }
            case P1P1: {
                return this.toP2().equals(ge);
            }
            case PRECOMP: {
                return this.X.equals(ge.X) && this.Y.equals(ge.Y) && this.Z.equals(ge.Z);
            }
            case CACHED: {
                if (this.Z.equals(ge.Z)) {
                    return this.X.equals(ge.X) && this.Y.equals(ge.Y) && this.T.equals(ge.T);
                }
                FieldElement x3 = this.X.multiply(ge.Z);
                FieldElement y3 = this.Y.multiply(ge.Z);
                FieldElement t3 = this.T.multiply(ge.Z);
                FieldElement x4 = ge.X.multiply(this.Z);
                FieldElement y4 = ge.Y.multiply(this.Z);
                FieldElement t4 = ge.T.multiply(this.Z);
                return x3.equals(x4) && y3.equals(y4) && t3.equals(t4);
            }
        }
        return false;
    }

    static byte[] toRadix16(byte[] a2) {
        int i2;
        byte[] e2 = new byte[64];
        for (i2 = 0; i2 < 32; ++i2) {
            e2[2 * i2 + 0] = (byte)(a2[i2] & 0xF);
            e2[2 * i2 + 1] = (byte)(a2[i2] >> 4 & 0xF);
        }
        int carry = 0;
        i2 = 0;
        while (i2 < 63) {
            int n2 = i2;
            e2[n2] = (byte)(e2[n2] + carry);
            carry = e2[i2] + 8;
            int n3 = i2++;
            e2[n3] = (byte)(e2[n3] - ((carry >>= 4) << 4));
        }
        e2[63] = (byte)(e2[63] + carry);
        return e2;
    }

    GroupElement cmov(GroupElement u2, int b2) {
        return GroupElement.precomp(this.curve, this.X.cmov(u2.X, b2), this.Y.cmov(u2.Y, b2), this.Z.cmov(u2.Z, b2));
    }

    GroupElement select(int pos, int b2) {
        int bnegative = Utils.negative(b2);
        int babs = b2 - ((-bnegative & b2) << 1);
        GroupElement t2 = this.curve.getZero(Representation.PRECOMP).cmov(this.precmp[pos][0], Utils.equal(babs, 1)).cmov(this.precmp[pos][1], Utils.equal(babs, 2)).cmov(this.precmp[pos][2], Utils.equal(babs, 3)).cmov(this.precmp[pos][3], Utils.equal(babs, 4)).cmov(this.precmp[pos][4], Utils.equal(babs, 5)).cmov(this.precmp[pos][5], Utils.equal(babs, 6)).cmov(this.precmp[pos][6], Utils.equal(babs, 7)).cmov(this.precmp[pos][7], Utils.equal(babs, 8));
        GroupElement tminus = GroupElement.precomp(this.curve, t2.Y, t2.X, t2.Z.negate());
        return t2.cmov(tminus, bnegative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupElement scalarMultiply(byte[] a2) {
        byte[] e2 = GroupElement.toRadix16(a2);
        GroupElement h2 = this.curve.getZero(Representation.P3);
        GroupElement groupElement = this;
        synchronized (groupElement) {
            GroupElement t2;
            int i2;
            for (i2 = 1; i2 < 64; i2 += 2) {
                t2 = this.select(i2 / 2, e2[i2]);
                h2 = h2.madd(t2).toP3();
            }
            h2 = h2.dbl().toP2().dbl().toP2().dbl().toP2().dbl().toP3();
            for (i2 = 0; i2 < 64; i2 += 2) {
                t2 = this.select(i2 / 2, e2[i2]);
                h2 = h2.madd(t2).toP3();
            }
        }
        return h2;
    }

    static byte[] slide(byte[] a2) {
        int i2;
        byte[] r2 = new byte[256];
        for (i2 = 0; i2 < 256; ++i2) {
            r2[i2] = (byte)(1 & a2[i2 >> 3] >> (i2 & 7));
        }
        block1: for (i2 = 0; i2 < 256; ++i2) {
            if (r2[i2] == 0) continue;
            block2: for (int b2 = 1; b2 <= 6 && i2 + b2 < 256; ++b2) {
                if (r2[i2 + b2] == 0) continue;
                if (r2[i2] + (r2[i2 + b2] << b2) <= 15) {
                    int n2 = i2;
                    r2[n2] = (byte)(r2[n2] + (r2[i2 + b2] << b2));
                    r2[i2 + b2] = 0;
                    continue;
                }
                if (r2[i2] - (r2[i2 + b2] << b2) < -15) continue block1;
                int n3 = i2;
                r2[n3] = (byte)(r2[n3] - (r2[i2 + b2] << b2));
                for (int k2 = i2 + b2; k2 < 256; ++k2) {
                    if (r2[k2] == 0) {
                        r2[k2] = 1;
                        continue block2;
                    }
                    r2[k2] = 0;
                }
            }
        }
        return r2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupElement doubleScalarMultiplyVariableTime(GroupElement A2, byte[] a2, byte[] b2) {
        int i2;
        byte[] aslide = GroupElement.slide(a2);
        byte[] bslide = GroupElement.slide(b2);
        GroupElement r2 = this.curve.getZero(Representation.P2);
        for (i2 = 255; i2 >= 0 && aslide[i2] == 0 && bslide[i2] == 0; --i2) {
        }
        GroupElement groupElement = this;
        synchronized (groupElement) {
            while (i2 >= 0) {
                GroupElement t2 = r2.dbl();
                if (aslide[i2] > 0) {
                    t2 = t2.toP3().madd(A2.dblPrecmp[aslide[i2] / 2]);
                } else if (aslide[i2] < 0) {
                    t2 = t2.toP3().msub(A2.dblPrecmp[-aslide[i2] / 2]);
                }
                if (bslide[i2] > 0) {
                    t2 = t2.toP3().madd(this.dblPrecmp[bslide[i2] / 2]);
                } else if (bslide[i2] < 0) {
                    t2 = t2.toP3().msub(this.dblPrecmp[-bslide[i2] / 2]);
                }
                r2 = t2.toP2();
                --i2;
            }
        }
        return r2;
    }

    public boolean isOnCurve() {
        return this.isOnCurve(this.curve);
    }

    public boolean isOnCurve(Curve curve) {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement recip = this.Z.invert();
                FieldElement x2 = this.X.multiply(recip);
                FieldElement y2 = this.Y.multiply(recip);
                FieldElement xx = x2.square();
                FieldElement yy = y2.square();
                FieldElement dxxyy = curve.getD().multiply(xx).multiply(yy);
                return curve.getField().ONE.add(dxxyy).add(xx).equals(yy);
            }
        }
        return this.toP2().isOnCurve(curve);
    }

    public String toString() {
        return "[GroupElement\nX=" + this.X + "\nY=" + this.Y + "\nZ=" + this.Z + "\nT=" + this.T + "\n]";
    }

    public static enum Representation {
        P2,
        P3,
        P1P1,
        PRECOMP,
        CACHED;

    }
}

