/*
 * Decompiled with CFR 0.152.
 */
package load.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import load.file.CustomLogger;
import load.file.MainApp;
import org.apache.commons.lang.SystemUtils;

public class Ping {
    public void doCommand(List<String> object) {
        object = new ProcessBuilder((List<String>)object);
        object = ((ProcessBuilder)object).start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(((Process)object).getErrorStream()));
        System.out.println("Here is the standard output of the command:\n");
        while ((object = bufferedReader.readLine()) != null) {
            System.out.println((String)object);
        }
        System.out.println("Here is the standard error of the command (if any):\n");
        while ((object = bufferedReader2.readLine()) != null) {
            System.out.println((String)object);
        }
    }

    public static boolean isReachable(String object) {
        Object object2 = new ArrayList<String>();
        try {
            object2.add("ping");
            if (SystemUtils.IS_OS_WINDOWS) {
                object2.add("-n");
            } else if (SystemUtils.IS_OS_UNIX) {
                object2.add("-c");
            } else {
                throw new UnsupportedOperationException(ResourceBundle.getBundle("load/file/Bundle").getString("UNSUPPORTED OPERATING SYSTEM"));
            }
            object2.add("1");
            object2.add(object);
            object = new ProcessBuilder((List<String>)object2);
            object = ((ProcessBuilder)object).start();
            object = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            while ((object2 = ((BufferedReader)object).readLine()) != null) {
                if (!((String)object2).toLowerCase().contains("100% packet loss")) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Logger.getLogger(Ping.class.getName()).log(Level.SEVERE, null, exception);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReachable2(String string) {
        CustomLogger.getInstance();
        try {
            Object object = InetAddress.getByName(string);
            if (((InetAddress)object).isReachable(2000)) {
                CustomLogger.getInstance().writeLog(MainApp.INFO, string, " is reachable");
                System.out.printf("%s is reachable%n", object);
                return true;
            }
            CustomLogger.getInstance().writeLog(MainApp.INFO, string, " could not be contacted via ICMP");
            System.out.printf("%s could not be contacted via ICMP%n", object);
            try {
                object = new Socket();
                Throwable throwable = null;
                try {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(string, 80);
                    ((Socket)object).connect(inetSocketAddress, 2000);
                    System.out.printf("%s is reachable via TCP port 80%n", string);
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            ((Socket)object).close();
                            throw throwable4;
                        }
                        try {
                            ((Socket)object).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                ((Socket)object).close();
                return true;
            }
            catch (IOException iOException) {
                CustomLogger.getInstance().writeLog(MainApp.INFO, string, " could not be contacted via TCP port 80");
                System.out.printf("%s could not be contacted via TCP port 80%n", string);
                return false;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(Ping.class.getName()).log(Level.SEVERE, null, exception);
        }
        return false;
    }

    public static String getIPv4Address() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (((NetworkInterface)object).isLoopback() || ((NetworkInterface)object).isVirtual() || !((NetworkInterface)object).isUp()) continue;
                object = ((NetworkInterface)object).getInetAddresses();
                while (object.hasMoreElements()) {
                    InetAddress inetAddress = (InetAddress)object.nextElement();
                    if (inetAddress.getHostAddress().indexOf(":") != -1) continue;
                    arrayList.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            SocketException socketException2 = socketException;
            socketException.printStackTrace();
        }
        return ((Object)arrayList).toString();
    }

    public static boolean isPostgreSQLReachable(String object, String string, int n2, String string2, String string3, String string4) {
        CustomLogger.getInstance();
        String string5 = "org.postgresql.Driver";
        object = "jdbc:postgresql://" + (String)object + ":" + n2 + "/" + string2 + "?connectTimeout=5";
        String string6 = string3;
        string2 = string4;
        try {
            Class.forName(string5);
            DriverManager.setLoginTimeout(5);
            object = DriverManager.getConnection((String)object, string6, string2);
            CustomLogger.getInstance().writeLog(MainApp.INFO, string, "CONEXION A LA BASE DE DATOS LOCALHOST REALIZADA CON EXITO! ");
            object.close();
        }
        catch (SQLException sQLException) {
            System.err.println("No se puede conectar a PostgreSQL: " + sQLException.getMessage());
            CustomLogger.getInstance().writeLog(MainApp.INFO, string, "No se puede conectar a PostgreSQL: " + sQLException.getMessage());
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("No se puede conectar a PostgreSQL: " + classNotFoundException.getMessage());
            CustomLogger.getInstance().writeLog(MainApp.INFO, string, "No se puede conectar a PostgreSQL: " + classNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

