/*
 * Decompiled with CFR 0.152.
 */
package load.file;

import com.ucod.lang.LocaleUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Properties;
import load.file.ChooseDevices;
import load.file.CustomLogger;
import load.file.MainApp;
import load.file.ShowConfigs;

public class ConfigProperties {
    private static InputStream a;

    public static void getPropUI() {
        InputStreamReader inputStreamReader = null;
        CustomLogger.getInstance();
        new LocaleUtil(MainApp.supportedLocales, "load/file/Bundle");
        try {
            Properties properties = new Properties();
            LocaleUtil.setCurrentLocale(ConfigFile.getLocaleLang());
            File file = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "ui.properties") : new File(File.separator + "tmp" + File.separator + "ui.properties");
            if (!file.exists()) {
                ConfigProperties.setPropValuesDefault();
                file = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "ui.properties") : new File(File.separator + "tmp" + File.separator + "ui.properties");
            }
            a = new FileInputStream(file);
            inputStreamReader = MainApp.isWindows() ? new InputStreamReader(a, "ISO-8859-1") : new InputStreamReader(a, "UTF-8");
            properties.load(inputStreamReader);
            ConfigFile.setUiIsruning(properties.getProperty("UiIsruning") != null ? properties.getProperty("UiIsruning").equals("1") : ConfigProperties.getPropValuesDefault("UiIsruning").equals("0"));
            return;
        }
        catch (Exception exception) {
            ConfigProperties.setPropUIDefault();
            System.out.println("Exception: " + exception);
            return;
        }
        finally {
            inputStreamReader.close();
            a.close();
        }
    }

    public static void getProcessRunning() {
        InputStreamReader inputStreamReader = null;
        new LocaleUtil(MainApp.supportedLocales, "load/file/Bundle");
        CustomLogger.getInstance();
        try {
            Properties properties = new Properties();
            LocaleUtil.setCurrentLocale(ConfigFile.getLocaleLang());
            File file = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "processrunning.properties") : new File(File.separator + "tmp" + File.separator + "processrunning.properties");
            if (!file.exists()) {
                ConfigProperties.setProcessDefault();
                file = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "processrunning.properties") : new File(File.separator + "tmp" + File.separator + "processrunning.properties");
            }
            a = new FileInputStream(file);
            inputStreamReader = MainApp.isWindows() ? new InputStreamReader(a, "ISO-8859-1") : new InputStreamReader(a, "UTF-8");
            properties.load(inputStreamReader);
            ConfigFile.setProcessIsruning(properties.getProperty("processrunning") != null ? properties.getProperty("processrunning").equals("1") : ConfigProperties.getPropValuesDefault("processrunning").equals("0"));
            return;
        }
        catch (Exception exception) {
            ConfigProperties.setProcessDefault();
            System.out.println("Exception: " + exception);
            return;
        }
        finally {
            inputStreamReader.close();
            a.close();
        }
    }

    public static boolean isUIRunning() {
        try {
            ConfigProperties.getPropUI();
            return ConfigFile.isUiIsruning();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isProcessRunning() {
        try {
            ConfigProperties.getProcessRunning();
            return ConfigFile.isProcessRuning();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void getPropValues() {
        InputStreamReader inputStreamReader = null;
        CustomLogger.getInstance();
        try {
            Properties properties = new Properties();
            new LocaleUtil(MainApp.supportedLocales, "load/file/Bundle");
            File file = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "config_loadfile.properties") : new File(File.separator + "tmp" + File.separator + "config_loadfile.properties");
            if (!file.exists()) {
                ConfigProperties.setPropValuesDefault();
                file = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "config_loadfile.properties") : new File(File.separator + "tmp" + File.separator + "config_loadfile.properties");
            }
            a = new FileInputStream(file);
            inputStreamReader = MainApp.isWindows() ? new InputStreamReader(a, "ISO-8859-1") : new InputStreamReader(a, "UTF-8");
            properties.load(inputStreamReader);
            ConfigFile.setLocaleLang(properties.getProperty("lang") != null ? properties.getProperty("lang") : ConfigProperties.getPropValuesDefault("lang"));
            ConfigFile.setFilePath(properties.getProperty("importpath") != null ? properties.getProperty("importpath") : ConfigProperties.getPropValuesDefault("importpath"), true);
            ConfigFile.setFileLabelsPath(properties.getProperty("importlabelspath") != null ? properties.getProperty("importlabelspath") : ConfigProperties.getPropValuesDefault("importlabelspath"), true);
            ConfigFile.setFilePathNovedades(properties.getProperty("importpathnovedades") != null ? properties.getProperty("importpathnovedades") : ConfigProperties.getPropValuesDefault("importpathnovedades"), true);
            ConfigFile.setFilePathRangos(properties.getProperty("importpathrangos") != null ? properties.getProperty("importpathrangos") : ConfigProperties.getPropValuesDefault("importpathrangos"), true);
            ConfigFile.setLogPath(properties.getProperty("logpath") != null ? properties.getProperty("logpath") : ConfigProperties.getPropValuesDefault("logpath"));
            ConfigFile.setPsqlPath(properties.getProperty("psqlpath") != null ? properties.getProperty("psqlpath") : ConfigProperties.getPropValuesDefault("psqlpath"));
            ConfigFile.setSeparator(properties.getProperty("separator") != null ? properties.getProperty("separator") : ConfigProperties.getPropValuesDefault("separator"));
            ConfigFile.setImportmanual(properties.getProperty("importmanual") != null ? properties.getProperty("importmanual") : ConfigProperties.getPropValuesDefault("importmanual"));
            ConfigFile.setIpv4(properties.getProperty("ipv4") != null ? properties.getProperty("ipv4") : ConfigProperties.getPropValuesDefault("ipv4"));
            ConfigFile.setShowmessage(properties.getProperty("showmessage") != null ? properties.getProperty("showmessage") : ConfigProperties.getPropValuesDefault("showmessage"));
            ConfigFile.setFiletype(properties.getProperty("filetype") != null ? properties.getProperty("filetype") : ConfigProperties.getPropValuesDefault("filetype"));
            ConfigFile.setSendEmail(properties.getProperty("sendEmail") != null ? properties.getProperty("sendEmail").equals("1") : ConfigProperties.getPropValuesDefault("sendEmail").equals("0"));
            ConfigFile.setEmailUser(properties.getProperty("emailUser") != null ? properties.getProperty("emailUser") : ConfigProperties.getPropValuesDefault("emailUser"));
            ConfigFile.setEmailPass(properties.getProperty("emailPass") != null ? MainApp.cputil.decrypt(properties.getProperty("emailPass")) : ConfigProperties.getPropValuesDefault("emailPass"));
            ConfigFile.setEmailHost(properties.getProperty("emailHost") != null ? properties.getProperty("emailHost") : ConfigProperties.getPropValuesDefault("emailHost"));
            ConfigFile.setEmailPort(properties.getProperty("emailPort") != null ? properties.getProperty("emailPort") : ConfigProperties.getPropValuesDefault("emailPort"));
            ConfigFile.setEmailSubject(properties.getProperty("emailSubject") != null ? properties.getProperty("emailSubject") : ConfigProperties.getPropValuesDefault("emailSubject"));
            ConfigFile.setEmailDestinatary(properties.getProperty("emailDestinatary") != null ? properties.getProperty("emailDestinatary").split("\\;") : ConfigProperties.getPropValuesDefault("emailDestinatary").split("\\;"));
            ConfigFile.setSchedulerPeriod(properties.getProperty("schedulerPeriod") != null ? properties.getProperty("schedulerPeriod") : ConfigProperties.getPropValuesDefault("schedulerPeriod"));
            ConfigFile.setSchedulerTimeValue(properties.getProperty("schedulerTimeValue") != null ? properties.getProperty("schedulerTimeValue") : ConfigProperties.getPropValuesDefault("schedulerTimeValue"));
            ConfigFile.setSchedulerHours(properties.getProperty("schedulerHours") != null ? properties.getProperty("schedulerHours").split("\\;") : ConfigProperties.getPropValuesDefault("schedulerHours").split("\\;"));
            ConfigFile.setModeArchive(properties.getProperty("modeArchive") != null ? properties.getProperty("modeArchive") : ConfigProperties.getPropValuesDefault("modeArchive"));
            ConfigFile.setModeImport(properties.getProperty("modeImport") != null ? properties.getProperty("modeImport") : ConfigProperties.getPropValuesDefault("modeImport"));
            ConfigFile.setImportDBType(properties.getProperty("importDBType") != null ? properties.getProperty("importDBType") : ConfigProperties.getPropValuesDefault("importDBType"));
            ConfigFile.setImportDBName(properties.getProperty("importDBName") != null ? properties.getProperty("importDBName") : ConfigProperties.getPropValuesDefault("importDBName"));
            ConfigFile.setImportDBIP(properties.getProperty("importDBIP") != null ? properties.getProperty("importDBIP") : ConfigProperties.getPropValuesDefault("importDBIP"));
            ConfigFile.setImportDBPort(properties.getProperty("importDBPort") != null ? properties.getProperty("importDBPort") : ConfigProperties.getPropValuesDefault("importDBPort"));
            ConfigFile.setImportDBUser(properties.getProperty("importDBUser") != null ? properties.getProperty("importDBUser") : ConfigProperties.getPropValuesDefault("importDBUser"));
            ConfigFile.setImportDBPass(properties.getProperty("importDBPass") != null ? MainApp.cputil.decrypt(properties.getProperty("importDBPass")) : ConfigProperties.getPropValuesDefault("importDBPass"));
            ConfigFile.setImportDBQuery(properties.getProperty("importDBQuery") != null ? properties.getProperty("importDBQuery") : ConfigProperties.getPropValuesDefault("importDBQuery"));
            ConfigFile.setQendraIsActive(properties.getProperty("qendraIsActive") != null ? properties.getProperty("qendraIsActive").equals("1") : ConfigProperties.getPropValuesDefault("qendraIsActive").equals("0"));
            ConfigFile.setUseQendraDefPath(properties.getProperty("qendraUseDefaultPath") != null ? properties.getProperty("qendraUseDefaultPath").equals("1") : ConfigProperties.getPropValuesDefault("qendraUseDefaultPath").equals("1"));
            ConfigFile.setQendraPath(properties.getProperty("qendraPath") != null ? properties.getProperty("qendraPath") : ConfigProperties.getPropValuesDefault("qendraPath"));
            ConfigFile.setDeleteFileInput(properties.getProperty("deletefileinput") != null ? properties.getProperty("deletefileinput") : ConfigProperties.getPropValuesDefault("deletefileinput"));
            ConfigFile.setImportOnlyPrice(properties.getProperty("importOnlyPrice") != null ? properties.getProperty("importOnlyPrice") : ConfigProperties.getPropValuesDefault("importOnlyPrice"));
            ConfigFile.setItensMGVNutInfoFilePath(properties.getProperty("itensMGVNutInfoPath") != null ? properties.getProperty("itensMGVNutInfoPath") : ConfigProperties.getPropValuesDefault("itensMGVNutInfoPath"), true);
            ConfigFile.setItensMGVReceingFilePath(properties.getProperty("itensMGVReceingPath") != null ? properties.getProperty("itensMGVReceingPath") : ConfigProperties.getPropValuesDefault("itensMGVReceingPath"), true);
            ConfigFile.setItensMGVTaraFilePath(properties.getProperty("itensMGVTaraPath") != null ? properties.getProperty("itensMGVTaraPath") : ConfigProperties.getPropValuesDefault("itensMGVTaraPath"), true);
            ConfigFile.setItensMGVConservacionFilePath(properties.getProperty("itensMGVConservacionPath") != null ? properties.getProperty("itensMGVConservacionPath") : ConfigProperties.getPropValuesDefault("itensMGVConservacionPath"), true);
            ConfigFile.setItensMGVExtra2FilePath(properties.getProperty("ItensMGVExtra2FilePath") != null ? properties.getProperty("ItensMGVExtra2FilePath") : ConfigProperties.getPropValuesDefault("ItensMGVExtra2FilePath"), true);
            ConfigFile.setItensMGVIngredientsFilePath(properties.getProperty("ItensMGVIngredientsFilePath") != null ? properties.getProperty("ItensMGVIngredientsFilePath") : ConfigProperties.getPropValuesDefault("ItensMGVIngredientsFilePath"), true);
            ConfigFile.setItensMGVIngredientsFilePath2(properties.getProperty("ItensMGVIngredientsFilePath2") != null ? properties.getProperty("ItensMGVIngredientsFilePath2") : ConfigProperties.getPropValuesDefault("ItensMGVIngredientsFilePath2"), true);
            ConfigFile.setItensMGVPricePointFilePath(properties.getProperty("ItensMGVPricePointFilePath") != null ? properties.getProperty("ItensMGVPricePointFilePath") : ConfigProperties.getPropValuesDefault("ItensMGVPricePointFilePath"), true);
            ConfigFile.setDeleteMissingProducts(properties.getProperty("deleteMissingProducts") != null ? properties.getProperty("deleteMissingProducts") : ConfigProperties.getPropValuesDefault("deleteMissingProducts"));
            ConfigFile.setPriceRange(properties.getProperty("priceRange") != null ? properties.getProperty("priceRange") : ConfigProperties.getPropValuesDefault("priceRange"));
            ConfigFile.setGrToKg(properties.getProperty("GrToKg") != null ? properties.getProperty("GrToKg") : ConfigProperties.getPropValuesDefault("GrToKg"));
            ConfigFile.setHaveHeader(properties.getProperty("HaveHeader") != null ? properties.getProperty("HaveHeader") : ConfigProperties.getPropValuesDefault("HaveHeader"));
            ConfigFile.setEleventasPath(properties.getProperty("eleventasPath") != null ? properties.getProperty("eleventasPath") : ConfigProperties.getPropValuesDefault("eleventasPath"));
            try {
                ConfigFile.setTimeoutProcess(Integer.parseInt(properties.getProperty("timeout") != null ? properties.getProperty("timeout") : ConfigProperties.getPropValuesDefault("timeout")));
            }
            catch (Exception exception) {
                ConfigFile.setTimeoutProcess(180);
            }
            ConfigFile.setFilePathImagenes(properties.getProperty("filepath_imagenes", ""), false);
            if (ConfigFile.getLocaleLang() == null) {
                LocaleUtil.setCurrentLocaleByIndex(1);
            } else {
                LocaleUtil.setCurrentLocale(ConfigFile.getLocaleLang());
            }
            try {
                ConfigFile.setScalesFoundCount(Integer.parseInt(properties.getProperty("scalesFoundCount") != null ? properties.getProperty("scalesFoundCount") : ConfigProperties.getPropValuesDefault("scalesFoundCount")));
            }
            catch (NumberFormatException numberFormatException) {
                ConfigFile.setScalesFoundCount(0);
            }
            return;
        }
        catch (Exception exception) {
            ConfigProperties.setPropValuesDefault();
            if (!MainApp.bRunByCommandLine) {
                ShowConfigs showConfigs = new ShowConfigs();
                showConfigs.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                showConfigs.pack();
                showConfigs.setVisible(true);
                showConfigs.dispose();
            }
            System.out.println("Exception: " + exception);
            return;
        }
        finally {
            inputStreamReader.close();
            a.close();
        }
    }

    public static void setPropUI() {
        CustomLogger.getInstance();
        Object object = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "ui.properties") : new File(File.separator + "tmp" + File.separator + "ui.properties");
        try {
            Properties properties = new Properties();
            properties.setProperty("UiIsruning", ConfigFile.isUiIsruning() ? "1" : "0");
            object = new FileWriter((File)object);
            properties.store((Writer)object, "save settings");
            ((OutputStreamWriter)object).close();
            ConfigProperties.getPropUI();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            ConfigProperties.setPropUIDefault();
            System.out.println("Exception: " + exception);
            return;
        }
    }

    public static void setProcessRunning() {
        CustomLogger.getInstance();
        Object object = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "processrunning.properties") : new File(File.separator + "tmp" + File.separator + "processrunning.properties");
        try {
            Properties properties = new Properties();
            properties.setProperty("processrunning", ConfigFile.isProcessRuning() ? "1" : "0");
            object = new FileWriter((File)object);
            properties.store((Writer)object, "save settings");
            ((OutputStreamWriter)object).close();
            ConfigProperties.getPropUI();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            ConfigProperties.setProcessDefault();
            System.out.println("Exception: " + exception);
            return;
        }
    }

    public static void setPropValues() {
        CustomLogger.getInstance();
        Object object = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "config_loadfile.properties") : new File(File.separator + "tmp" + File.separator + "config_loadfile.properties");
        try {
            Properties properties = new Properties();
            properties.setProperty("lang", ConfigFile.getLocaleLang().toString());
            properties.setProperty("importpath", ConfigFile.getFilePath().trim());
            properties.setProperty("importlabelspath", ConfigFile.getFileLabelsPath().trim());
            properties.setProperty("importpathnovedades", ConfigFile.getFilePathNovedades().trim());
            properties.setProperty("importpathrangos", ConfigFile.getFilePathRangos().trim());
            properties.setProperty("logpath", ConfigFile.getLogPath().trim());
            properties.setProperty("psqlpath", ConfigFile.getPsqlPath().trim());
            properties.setProperty("separator", ConfigFile.getSeparator().trim());
            properties.setProperty("importmanual", ConfigFile.getImportmanual().trim());
            properties.setProperty("deletefileinput", ConfigFile.getDeleteFileInput().trim());
            properties.setProperty("importOnlyPrice", ConfigFile.getImportOnlyPrice().trim());
            properties.setProperty("ipv4", String.join((CharSequence)";", ConfigFile.getIpv4()));
            properties.setProperty("showmessage", ConfigFile.getShowmessage());
            properties.setProperty("filetype", Integer.toString(ConfigFile.getFiletype().ordinal()));
            properties.setProperty("sendEmail", ConfigFile.SendEmail() ? "1" : "0");
            properties.setProperty("emailUser", ConfigFile.getEmailUser());
            properties.setProperty("emailPass", MainApp.cputil.encrypt(ConfigFile.getEmailPass()));
            properties.setProperty("emailHost", ConfigFile.getEmailHost());
            properties.setProperty("emailPort", ConfigFile.getEmailPort());
            properties.setProperty("emailSubject", ConfigFile.getEmailSubject());
            properties.setProperty("emailDestinatary", String.join((CharSequence)";", ConfigFile.getEmailDestinatary()));
            properties.setProperty("schedulerPeriod", ConfigFile.getSchedulerPeriod());
            properties.setProperty("schedulerTimeValue", ConfigFile.getSchedulerTimeValue());
            properties.setProperty("schedulerHours", String.join((CharSequence)";", ConfigFile.getSchedulerHours()));
            properties.setProperty("modeArchive", ChooseDevices.getSelectedOptArchivoCompleto() ? "1" : "0");
            properties.setProperty("modeImport", ChooseDevices.getSelectedOptTodosLosDatos() ? "1" : "0");
            properties.setProperty("importDBType", ConfigFile.getImportDBType());
            properties.setProperty("importDBName", ConfigFile.getImportDBName());
            properties.setProperty("importDBIP", ConfigFile.getImportDBIP());
            properties.setProperty("importDBPort", ConfigFile.getImportDBPort());
            properties.setProperty("importDBUser", ConfigFile.getImportDBUser());
            properties.setProperty("importDBPass", MainApp.cputil.encrypt(ConfigFile.getImportDBPass()));
            properties.setProperty("importDBQuery", ConfigFile.getImportDBQuery());
            properties.setProperty("qendraIsActive", ConfigFile.useQendra() ? "1" : "0");
            properties.setProperty("qendraUseDefaultPath", ConfigFile.useQendraDefPath() ? "1" : "0");
            properties.setProperty("qendraPath", ConfigFile.getQendraPath());
            properties.setProperty("itensMGVReceingPath", ConfigFile.getItensMGVReceingFilePath());
            properties.setProperty("itensMGVNutInfoPath", ConfigFile.getItensMGVNutInfoFilePath());
            properties.setProperty("itensMGVTaraPath", ConfigFile.getItensMGVTaraFilePath());
            properties.setProperty("itensMGVConservacionPath", ConfigFile.getItensMGVConservacionFilePath());
            properties.setProperty("ItensMGVExtra2FilePath", ConfigFile.getItensMGVExtra2FilePath());
            properties.setProperty("ItensMGVIngredientsFilePath", ConfigFile.getItensMGVIngredientsFilePath());
            properties.setProperty("ItensMGVIngredientsFilePath2", ConfigFile.getItensMGVIngredientsFilePath2());
            properties.setProperty("ItensMGVPricePointFilePath", ConfigFile.getItensMGVPricePointFilePath());
            properties.setProperty("deleteMissingProducts", ConfigFile.getDeleteMissingProducts());
            properties.setProperty("qendraIsActive", ConfigFile.useQendra() ? "1" : "0");
            properties.setProperty("priceRange", ConfigFile.isPriceRange());
            properties.setProperty("GrToKg", ConfigFile.isGrToKg());
            properties.setProperty("HaveHeader", ConfigFile.isHaveHeader());
            properties.setProperty("scalesFoundCount", String.valueOf(ConfigFile.getScalesFoundCount()));
            properties.setProperty("eleventasPath", ConfigFile.getEleventasPath());
            properties.setProperty("filepath_imagenes", ConfigFile.getFilePathImagenes());
            properties.setProperty("timeout", String.valueOf(ConfigFile.getTimeoutProcess()));
            object = new FileWriter((File)object);
            properties.store((Writer)object, "save settings");
            ((OutputStreamWriter)object).close();
            ConfigProperties.getPropValues();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            ConfigProperties.setPropValuesDefault();
            if (!MainApp.bRunByCommandLine) {
                object = new ShowConfigs();
                ((Dialog)object).setModal(true);
                ((Window)object).setAlwaysOnTop(true);
                ((Dialog)object).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                ((Window)object).pack();
                ((Dialog)object).setVisible(true);
                ((Window)object).dispose();
            }
            System.out.println("Exception: " + exception);
            return;
        }
    }

    public static void setPropValuesIpv4() {
        CustomLogger.getInstance();
        Object object = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "config_loadfile.properties") : new File(File.separator + "tmp" + File.separator + "config_loadfile.properties");
        System.out.println("setPropValuesIpv4():" + ((File)object).getAbsolutePath());
        CustomLogger.getInstance().writeLog(MainApp.INFO, "", "setPropValuesIpv4():" + ((File)object).getAbsolutePath());
        try {
            Properties properties = new Properties();
            properties.setProperty("lang", ConfigFile.getLocaleLang().toString());
            properties.setProperty("importpath", ConfigFile.getFilePath());
            properties.setProperty("importlabelspath", ConfigFile.getFileLabelsPath());
            properties.setProperty("importpathnovedades", ConfigFile.getFilePathNovedades());
            properties.setProperty("importpathrangos", ConfigFile.getFilePathRangos());
            properties.setProperty("logpath", ConfigFile.getLogPath());
            properties.setProperty("psqlpath", ConfigFile.getPsqlPath());
            properties.setProperty("separator", ConfigFile.getSeparator());
            properties.setProperty("importmanual", ConfigFile.getImportmanual());
            properties.setProperty("deletefileinput", ConfigFile.getDeleteFileInput());
            properties.setProperty("importOnlyPrice", ConfigFile.getImportOnlyPrice());
            properties.setProperty("ipv4", String.join((CharSequence)";", ConfigFile.getIpv4()));
            properties.setProperty("showmessage", ConfigFile.getShowmessage());
            properties.setProperty("filetype", Integer.toString(ConfigFile.getFiletype().ordinal()));
            properties.setProperty("sendEmail", ConfigFile.SendEmail() ? "1" : "0");
            properties.setProperty("emailUser", ConfigFile.getEmailUser());
            properties.setProperty("emailPass", MainApp.cputil.encrypt(ConfigFile.getEmailPass()));
            properties.setProperty("emailHost", ConfigFile.getEmailHost());
            properties.setProperty("emailPort", ConfigFile.getEmailPort());
            properties.setProperty("emailSubject", ConfigFile.getEmailSubject());
            properties.setProperty("emailDestinatary", String.join((CharSequence)";", ConfigFile.getEmailDestinatary()));
            properties.setProperty("schedulerPeriod", ConfigFile.getSchedulerPeriod());
            properties.setProperty("schedulerTimeValue", ConfigFile.getSchedulerTimeValue());
            properties.setProperty("schedulerHours", String.join((CharSequence)";", ConfigFile.getSchedulerHours()));
            properties.setProperty("modeArchive", ChooseDevices.getSelectedOptArchivoCompleto() ? "1" : "0");
            properties.setProperty("modeImport", ChooseDevices.getSelectedOptTodosLosDatos() ? "1" : "0");
            properties.setProperty("importDBType", ConfigFile.getImportDBType());
            properties.setProperty("importDBName", ConfigFile.getImportDBName());
            properties.setProperty("importDBIP", ConfigFile.getImportDBIP());
            properties.setProperty("importDBPort", ConfigFile.getImportDBPort());
            properties.setProperty("importDBUser", ConfigFile.getImportDBUser());
            properties.setProperty("importDBPass", MainApp.cputil.encrypt(ConfigFile.getImportDBPass()));
            properties.setProperty("importDBQuery", ConfigFile.getImportDBQuery());
            properties.setProperty("qendraIsActive", ConfigFile.useQendra() ? "1" : "0");
            properties.setProperty("qendraUseDefaultPath", ConfigFile.useQendraDefPath() ? "1" : "0");
            properties.setProperty("qendraPath", ConfigFile.getQendraPath());
            properties.setProperty("itensMGVReceingPath", ConfigFile.getItensMGVReceingFilePath());
            properties.setProperty("itensMGVNutInfoPath", ConfigFile.getItensMGVNutInfoFilePath());
            properties.setProperty("itensMGVTaraPath", ConfigFile.getItensMGVTaraFilePath());
            properties.setProperty("itensMGVConservacionPath", ConfigFile.getItensMGVConservacionFilePath());
            properties.setProperty("ItensMGVExtra2FilePath", ConfigFile.getItensMGVExtra2FilePath());
            properties.setProperty("ItensMGVIngredientsFilePath", ConfigFile.getItensMGVIngredientsFilePath());
            properties.setProperty("ItensMGVIngredientsFilePath2", ConfigFile.getItensMGVIngredientsFilePath2());
            properties.setProperty("ItensMGVPricePointFilePath", ConfigFile.getItensMGVPricePointFilePath());
            properties.setProperty("deleteMissingProducts", ConfigFile.getDeleteMissingProducts());
            properties.setProperty("priceRange", ConfigFile.isPriceRange());
            properties.setProperty("GrToKg", ConfigFile.isGrToKg());
            properties.setProperty("HaveHeader", ConfigFile.isHaveHeader());
            properties.setProperty("scalesFoundCount", String.valueOf(ConfigFile.getScalesFoundCount()));
            properties.setProperty("eleventasPath", ConfigFile.getEleventasPath());
            properties.setProperty("filepath_imagenes", ConfigFile.getFilePathImagenes());
            properties.setProperty("timeout", String.valueOf(ConfigFile.getTimeoutProcess()));
            object = new FileWriter((File)object);
            properties.store((Writer)object, "save settings");
            ((OutputStreamWriter)object).close();
            ConfigProperties.getPropValues();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return;
        }
    }

    public static void setPropUIDefault() {
        Object object;
        CustomLogger.getInstance();
        try {
            object = new File(System.getProperty("user.home") + File.separator + "ui.properties");
            if (((File)object).exists()) {
                if (MainApp.isWindows()) {
                    Files.move(Paths.get(((File)object).getAbsolutePath(), new String[0]), Paths.get("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "ui.properties", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(Paths.get(((File)object).getAbsolutePath(), new String[0]), Paths.get(File.separator + "tmp" + File.separator + "ui.properties", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        object = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "ui.properties") : new File(File.separator + "tmp" + File.separator + "ui.properties");
        if (!((File)object).exists()) {
            ((File)object).createNewFile();
            try {
                Properties properties = new Properties();
                properties.setProperty("UiIsruning", "0");
                object = new FileWriter((File)object);
                properties.store((Writer)object, "save settings");
                ((OutputStreamWriter)object).close();
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public static void setProcessDefault() {
        Object object;
        CustomLogger.getInstance();
        try {
            object = new File(System.getProperty("user.home") + File.separator + "processrunning.properties");
            if (((File)object).exists()) {
                if (MainApp.isWindows()) {
                    Files.move(Paths.get(((File)object).getAbsolutePath(), new String[0]), Paths.get("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "processrunning.properties", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(Paths.get(((File)object).getAbsolutePath(), new String[0]), Paths.get(File.separator + "tmp" + File.separator + "processrunning.properties", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        object = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "processrunning.properties") : new File(File.separator + "tmp" + File.separator + "processrunning.properties");
        if (!((File)object).exists()) {
            ((File)object).createNewFile();
            try {
                Properties properties = new Properties();
                properties.setProperty("processrunning", "0");
                object = new FileWriter((File)object);
                properties.store((Writer)object, "save settings");
                ((OutputStreamWriter)object).close();
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public static void setPropValuesDefault() {
        Object object;
        CustomLogger.getInstance();
        try {
            object = new File(System.getProperty("user.home") + File.separator + "config_loadfile.properties");
            if (((File)object).exists()) {
                if (MainApp.isWindows()) {
                    Files.move(Paths.get(((File)object).getAbsolutePath(), new String[0]), Paths.get("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "config_loadfile.properties", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(Paths.get(((File)object).getAbsolutePath(), new String[0]), Paths.get(File.separator + "tmp" + File.separator + "config_loadfile.properties", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        object = MainApp.isWindows() ? new File("C:" + File.separator + "SYSTEL" + File.separator + "Importador" + File.separator + "config_loadfile.properties") : new File(File.separator + "tmp" + File.separator + "config_loadfile.properties");
        System.out.println("setPropValuesDefault():" + ((File)object).getAbsolutePath());
        CustomLogger.getInstance().writeLog(MainApp.INFO, "", "setPropValuesDefault():" + ((File)object).getAbsolutePath());
        if (!((File)object).exists()) {
            ((File)object).createNewFile();
            try {
                Properties properties = new Properties();
                properties.setProperty("lang", "es_AR");
                properties.setProperty("importpath", "");
                properties.setProperty("importlabelspath", "");
                properties.setProperty("importpathnovedades", "");
                properties.setProperty("importpathrangos", "");
                properties.setProperty("logpath", "");
                properties.setProperty("psqlpath", "C:\\Program Files\\PostgreSQL\\9.4\\bin\\psql.exe");
                properties.setProperty("separator", ";");
                properties.setProperty("importmanual", "0");
                properties.setProperty("deletefileinput", "0");
                properties.setProperty("importOnlyPrice", "0");
                properties.setProperty("ipv4", "");
                properties.setProperty("showmessage", "1");
                properties.setProperty("filetype", Integer.toString(ConfigFile.FileType.SYSTEL.ordinal()));
                properties.setProperty("sendEmail", "0");
                properties.setProperty("emailUser", "systelqa@gmail.com");
                properties.setProperty("emailPass", "7o7I6qhP5Ok=ZXpmam16eG5kd2treGdmZg==");
                properties.setProperty("emailHost", "smtp.gmail.com");
                properties.setProperty("emailPort", "587");
                properties.setProperty("emailSubject", "Proceso de importaci\u00f3n balanzas Systel");
                properties.setProperty("emailDestinatary", "");
                properties.setProperty("schedulerPeriod", "0");
                properties.setProperty("schedulerTimeValue", "10");
                properties.setProperty("schedulerHours", "");
                properties.setProperty("modeArchive", "1");
                properties.setProperty("modeImport", "1");
                properties.setProperty("importDBType", ConfigFile.DBType.POSTGRESQL);
                properties.setProperty("importDBName", "");
                properties.setProperty("importDBIP", "");
                properties.setProperty("importDBPort", "");
                properties.setProperty("importDBUser", "");
                properties.setProperty("importDBPass", "");
                properties.setProperty("importDBQuery", "");
                properties.setProperty("qendraIsActive", "0");
                properties.setProperty("qendraUseDefaultPath", "1");
                properties.setProperty("qendraPath", "C:\\Program Files\\Qendra\\qendra.fdb");
                properties.setProperty("itensMGVReceingPath", "");
                properties.setProperty("itensMGVNutInfoPath", "");
                properties.setProperty("itensMGVTaraPath", "");
                properties.setProperty("itensMGVConservacionPath", "");
                properties.setProperty("ItensMGVExtra2FilePath", "");
                properties.setProperty("ItensMGVIngredientsFilePath", "");
                properties.setProperty("ItensMGVIngredientsFilePath2", "");
                properties.setProperty("eleventasPath", "");
                properties.setProperty("timeout", "180");
                properties.setProperty("priceRange", "0");
                properties.setProperty("GrToKg", "0");
                properties.setProperty("HaveHeader", "0");
                properties.setProperty("scalesFoundCount", "0");
                object = new FileWriter((File)object);
                properties.store((Writer)object, "save settings");
                ((OutputStreamWriter)object).close();
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public static String getPropUIDefault(String string) {
        int n2 = -1;
        switch (string.hashCode()) {
            case 407064053: {
                if (!string.equals("UiIsruning")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            case 0: {
                return "0";
            }
        }
        return "";
    }

    public static String getPropValuesDefault(String string) {
        int n2 = -1;
        switch (string.hashCode()) {
            case 3314158: {
                if (!string.equals("lang")) break;
                n2 = 0;
                break;
            }
            case -51762045: {
                if (!string.equals("psqlpath")) break;
                n2 = 1;
                break;
            }
            case 1732829925: {
                if (!string.equals("separator")) break;
                n2 = 2;
                break;
            }
            case -1322366037: {
                if (!string.equals("importmanual")) break;
                n2 = 3;
                break;
            }
            case 1766005379: {
                if (!string.equals("deletefileinput")) break;
                n2 = 4;
                break;
            }
            case 1023247064: {
                if (!string.equals("importOnlyPrice")) break;
                n2 = 5;
                break;
            }
            case -321569174: {
                if (!string.equals("showmessage")) break;
                n2 = 6;
                break;
            }
            case -734566730: {
                if (!string.equals("filetype")) break;
                n2 = 7;
                break;
            }
            case 2490612: {
                if (!string.equals("sendEmail")) break;
                n2 = 8;
                break;
            }
            case 420571740: {
                if (!string.equals("schedulerPeriod")) break;
                n2 = 9;
                break;
            }
            case 294389801: {
                if (!string.equals("schedulerTimeValue")) break;
                n2 = 10;
                break;
            }
            case 1852551583: {
                if (!string.equals("modeArchive")) break;
                n2 = 11;
                break;
            }
            case 1115853608: {
                if (!string.equals("modeImport")) break;
                n2 = 12;
                break;
            }
            case 1769406653: {
                if (!string.equals("importDBType")) break;
                n2 = 13;
                break;
            }
            case 303806057: {
                if (!string.equals("qendraIsActive")) break;
                n2 = 14;
                break;
            }
            case 1354534104: {
                if (!string.equals("qendraUseDefaultPath")) break;
                n2 = 15;
                break;
            }
            case -384256065: {
                if (!string.equals("deleteMissingProducts")) break;
                n2 = 16;
                break;
            }
            case -1475740300: {
                if (!string.equals("priceRange")) break;
                n2 = 17;
                break;
            }
            case 2140562658: {
                if (!string.equals("GrToKg")) break;
                n2 = 18;
                break;
            }
            case 600817205: {
                if (!string.equals("HaveHeader")) break;
                n2 = 19;
                break;
            }
            case 765753334: {
                if (!string.equals("scalesFoundCount")) break;
                n2 = 20;
            }
        }
        switch (n2) {
            case 0: {
                return "es_AR";
            }
            case 1: {
                return "C:\\Program Files\\PostgreSQL\\9.4\\bin\\psql.exe";
            }
            case 2: {
                return ";";
            }
            case 3: {
                return "0";
            }
            case 4: {
                return "0";
            }
            case 5: {
                return "0";
            }
            case 6: {
                return "1";
            }
            case 7: {
                return Integer.toString(ConfigFile.FileType.SYSTEL.ordinal());
            }
            case 8: {
                return "0";
            }
            case 9: {
                return "0";
            }
            case 10: {
                return "10";
            }
            case 11: {
                return "1";
            }
            case 12: {
                return "1";
            }
            case 13: {
                return ConfigFile.DBType.POSTGRESQL;
            }
            case 14: {
                return "0";
            }
            case 15: {
                return "1";
            }
            case 16: {
                return "0";
            }
            case 17: {
                return "0";
            }
            case 18: {
                return "0";
            }
            case 19: {
                return "0";
            }
            case 20: {
                return "0";
            }
        }
        return "";
    }

    public static class ConfigFile {
        private static String a;
        private static String b;
        private static String c;
        private static String d;
        private static String e;
        private static String f;
        private static String[] g;
        private static String h;
        private static String i;
        private static String j;
        private static String k;
        private static String l;
        private static FileType m;
        private static Locale n;
        private static String o;
        private static int p;
        private static int q;
        private static String r;
        private static String s;
        private static String t;
        private static String u;
        private static String v;
        private static String w;
        private static String x;
        private static String y;
        private static String z;
        private static String A;
        private static String B;
        private static String C;
        private static String D;
        private static String E;
        private static String F;
        private static String G;
        private static boolean H;
        private static String I;
        private static String J;
        private static String K;
        private static String L;
        private static String[] M;
        private static String N;
        private static boolean O;
        private static boolean P;
        private static String Q;
        private static String R;
        public static final String QENDRA_DEFAULT_PATH = "C:\\Program Files\\Qendra\\qendra.fdb";
        private static String S;
        private static String[] T;
        private static boolean U;
        private static boolean V;
        private static String W;
        private static String X;
        private static String Y;
        private static String Z;
        private static String aa;
        private static String[] ab;
        private static String ac;
        private static String ad;

        public static int getScalesFoundCount() {
            return q;
        }

        public static void setScalesFoundCount(int n2) {
            q = n2;
        }

        public static String isPriceRange() {
            return W;
        }

        public static void setPriceRange(String string) {
            W = string;
        }

        public static String isGrToKg() {
            return X;
        }

        public static void setGrToKg(String string) {
            X = string;
        }

        public static String isHaveHeader() {
            return Y;
        }

        public static void setHaveHeader(String string) {
            Y = string;
        }

        public static boolean isUiIsruning() {
            return U;
        }

        public static boolean isProcessRuning() {
            return V;
        }

        public static void setUiIsruning(boolean bl2) {
            U = bl2;
        }

        public static void setProcessIsruning(boolean bl2) {
            V = bl2;
        }

        public static int getTimeoutProcess() {
            return p;
        }

        public static void setTimeoutProcess(int n2) {
            p = n2;
        }

        public static boolean useQendraDefPath() {
            return P;
        }

        public static void setUseQendraDefPath(boolean bl2) {
            P = bl2;
        }

        public static boolean useQendra() {
            return O;
        }

        public static void setQendraIsActive(boolean bl2) {
            O = bl2;
        }

        public static String getQendraPath() {
            return Q;
        }

        public static void setQendraPath(String string) {
            Q = string;
        }

        public static String getEleventasPath() {
            return R;
        }

        public static void setEleventasPath(String string) {
            R = string;
        }

        public static String getImportDBType() {
            return r;
        }

        public static void setImportDBType(String string) {
            r = string;
        }

        public static String getImportDBName() {
            return s;
        }

        public static void setImportDBName(String string) {
            s = string;
        }

        public static String getImportDBIP() {
            return t;
        }

        public static void setImportDBIP(String string) {
            t = string;
        }

        public static String getImportDBPort() {
            return u;
        }

        public static void setImportDBPort(String string) {
            u = string;
        }

        public static String getImportDBUser() {
            return v;
        }

        public static void setImportDBUser(String string) {
            v = string;
        }

        public static String getImportDBPass() {
            return w;
        }

        public static void setImportDBPass(String string) {
            w = string;
        }

        public static String getImportDBQuery() {
            return x;
        }

        public static void setImportDBQuery(String string) {
            x = string;
        }

        public static String getItensMGVReceingFilePath() {
            return y;
        }

        public static void setItensMGVReceingFilePath(String string, boolean bl2) {
            if (bl2) {
                y = string;
                return;
            }
            y = "";
        }

        public static String getItensMGVNutInfoFilePath() {
            return z;
        }

        public static void setItensMGVNutInfoFilePath(String string, boolean bl2) {
            if (bl2) {
                z = string;
                return;
            }
            z = "";
        }

        public static String getItensMGVTaraFilePath() {
            return B;
        }

        public static String getItensMGVExtra2FilePath() {
            return A;
        }

        public static void setItensMGVExtra2FilePath(String string, boolean bl2) {
            if (bl2) {
                A = string;
                return;
            }
            A = "";
        }

        public static String getItensMGVIngredientsFilePath() {
            return D;
        }

        public static void setItensMGVIngredientsFilePath(String string, boolean bl2) {
            if (bl2) {
                D = string;
                return;
            }
            D = "";
        }

        public static String getItensMGVIngredientsFilePath2() {
            return E;
        }

        public static void setItensMGVIngredientsFilePath2(String string, boolean bl2) {
            if (bl2) {
                E = string;
                return;
            }
            E = "";
        }

        public static void setItensMGVTaraFilePath(String string, boolean bl2) {
            if (bl2) {
                B = string;
                return;
            }
            B = "";
        }

        public static String getItensMGVPricePointFilePath() {
            return F;
        }

        public static void setItensMGVPricePointFilePath(String string, boolean bl2) {
            if (bl2) {
                F = string;
                return;
            }
            F = "";
        }

        public static String[] getSchedulerHours() {
            return ab;
        }

        public static void setSchedulerHours(String[] stringArray) {
            ab = stringArray;
        }

        public static String getSchedulerPeriod() {
            return Z;
        }

        public static void setSchedulerPeriod(String string) {
            Z = string;
        }

        public static String getModeArchive() {
            return ac;
        }

        public static void setModeArchive(String string) {
            ac = string;
        }

        public static String getModeImport() {
            return ad;
        }

        public static void setModeImport(String string) {
            ad = string;
        }

        public static String getSchedulerTimeValue() {
            return aa;
        }

        public static void setSchedulerTimeValue(String string) {
            aa = string;
        }

        public static String getLogPath() {
            return e;
        }

        public static void setLogPath(String string) {
            e = string;
        }

        public static String getPsqlPath() {
            return f;
        }

        public static void setPsqlPath(String string) {
            f = string;
        }

        public static String getShowmessage() {
            return l;
        }

        public static void setShowmessage(String string) {
            l = string;
        }

        public static String getImportmanual() {
            return i;
        }

        public static void setImportmanual(String string) {
            i = string;
        }

        public static String getDeleteFileInput() {
            return j;
        }

        public static void setDeleteFileInput(String string) {
            j = string;
        }

        public static String getImportOnlyPrice() {
            return k;
        }

        public static void setImportOnlyPrice(String string) {
            k = string;
        }

        public static String[] getIpv4() {
            return g;
        }

        public static void setIpv4(String string) {
            g = string.split("\\;");
        }

        public static String getSeparator() {
            return h;
        }

        public static void setSeparator(String string) {
            h = string;
        }

        public static String getFilePath() {
            return a;
        }

        public static void setFilePath(String string, boolean bl2) {
            if (bl2) {
                a = string;
                return;
            }
            a = "";
        }

        public static String getFileLabelsPath() {
            return b;
        }

        public static void setFileLabelsPath(String string, boolean bl2) {
            if (bl2) {
                b = string;
                return;
            }
            b = "";
        }

        public static Locale getLocaleLang() {
            return n;
        }

        public static void setLocaleLang(String string) {
            Locale[] localeArray = MainApp.supportedLocales;
            int n2 = MainApp.supportedLocales.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Locale locale = localeArray[i2];
                if (!locale.toString().equalsIgnoreCase(string)) continue;
                n = locale;
                return;
            }
            n = MainApp.supportedLocales[1];
        }

        public static String getFilePathNovedades() {
            return c;
        }

        public static void setFilePathNovedades(String string, boolean bl2) {
            if (bl2) {
                c = string;
                return;
            }
            c = "";
        }

        public static String getFilePathPricePoint() {
            return F;
        }

        public static void setFilePathPricepoint(String string, boolean bl2) {
            if (bl2) {
                F = string;
                return;
            }
            F = "";
        }

        public static String getItensMGVConservacionFilePath() {
            return C;
        }

        public static void setItensMGVConservacionFilePath(String string, boolean bl2) {
            if (bl2) {
                C = string;
                return;
            }
            C = "";
        }

        public static String getFilePathRangos() {
            return d;
        }

        public static void setFilePathRangos(String string, boolean bl2) {
            if (bl2) {
                d = string;
                return;
            }
            d = "";
        }

        public static FileType getFiletype() {
            return m;
        }

        public static void setFiletype(String string) {
            m = FileType.fromInteger(Integer.parseInt(string));
        }

        public static boolean SendEmail() {
            return H;
        }

        public static void setSendEmail(boolean bl2) {
            H = bl2;
        }

        public static String getEmailUser() {
            return I;
        }

        public static void setEmailUser(String string) {
            I = string;
        }

        public static String getEmailPass() {
            return J;
        }

        public static void setEmailPass(String string) {
            J = string;
        }

        public static String getEmailHost() {
            return K;
        }

        public static void setEmailHost(String string) {
            K = string;
        }

        public static String getEmailPort() {
            return L;
        }

        public static void setEmailPort(String string) {
            L = string;
        }

        public static String[] getEmailDestinatary() {
            return M;
        }

        public static void setEmailDestinatary(String[] stringArray) {
            M = stringArray;
        }

        public static String getEmailSubject() {
            return N;
        }

        public static void setEmailSubject(String string) {
            N = string;
        }

        public static String getFilePathImagenes() {
            return o;
        }

        public static void setFilePathImagenes(String string, boolean bl2) {
            if (bl2) {
                File file = new File(string);
                if (file.exists()) {
                    o = string;
                }
                return;
            }
            o = string;
        }

        public static String getDeleteMissingProducts() {
            return G;
        }

        public static void setDeleteMissingProducts(String string) {
            G = string;
        }

        public static String getDbOriginIP() {
            return S;
        }

        public static void setDbOriginIP(String string) {
            S = string;
        }

        public static String[] getDbDestinyIPs() {
            return T;
        }

        public static void setDbDestinyIPs(String[] stringArray) {
            T = stringArray;
        }

        public static void setDbDestinyIPs(String string) {
            if (string != null && !string.trim().isEmpty()) {
                T = string.split("\\;");
                return;
            }
            T = new String[0];
        }

        static {
            q = 0;
            G = "0";
            I = "";
            J = "";
            K = "";
            L = "";
            N = "";
            S = "";
            T = new String[0];
            U = false;
            V = false;
            W = "0";
            X = "0";
            Y = "0";
        }

        public static class DBType {
            public static String POSTGRESQL = "0";
            public static String FIREBIRD = "1";
            public static String SQLSERVER = "2";
            public static String MARIADB = "3";
            public static String MySQL = "4";
            public static String SQLITE = "5";
        }

        public static enum FileType {
            SYSTEL,
            FIRES,
            INTELLIBUILD,
            COTO,
            DIGI,
            SDR,
            IMP_DB,
            BIZERBA,
            SICAR,
            ITENS_MGV,
            MT8450,
            ITENS_ERPtoMGV,
            SYSTELRDC429,
            ANONIMA,
            ELEVENTAS,
            MY_BUSINESS_POS,
            ITENS_MGV_DEPTO,
            HANBAI_KATANA,
            SYSTEL_DB,
            DIBAL;


            public static FileType fromInteger(int n2) {
                switch (n2) {
                    case 0: {
                        return SYSTEL;
                    }
                    case 1: {
                        return FIRES;
                    }
                    case 2: {
                        return INTELLIBUILD;
                    }
                    case 3: {
                        return COTO;
                    }
                    case 4: {
                        return DIGI;
                    }
                    case 5: {
                        return SDR;
                    }
                    case 6: {
                        return IMP_DB;
                    }
                    case 7: {
                        return BIZERBA;
                    }
                    case 8: {
                        return SICAR;
                    }
                    case 9: {
                        return ITENS_MGV;
                    }
                    case 10: {
                        return MT8450;
                    }
                    case 11: {
                        return ITENS_ERPtoMGV;
                    }
                    case 12: {
                        return SYSTELRDC429;
                    }
                    case 13: {
                        return ANONIMA;
                    }
                    case 14: {
                        return ELEVENTAS;
                    }
                    case 15: {
                        return MY_BUSINESS_POS;
                    }
                    case 16: {
                        return ITENS_MGV_DEPTO;
                    }
                    case 17: {
                        return HANBAI_KATANA;
                    }
                    case 18: {
                        return SYSTEL_DB;
                    }
                    case 19: {
                        return DIBAL;
                    }
                }
                return null;
            }
        }
    }
}

