/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessExecutor {
    public static final String LINE = "line";
    private static final Logger LOGGER = Logger.getLogger(ProcessExecutor.class.getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private List<String> stdOut;
    private List<String> stdErr;
    private List<String> stdAll;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Process process;
    private Map<String, String> environment;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public int executeScript(String script, String ... parameters) throws IOException {
        return this.executeScript(false, false, script, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeScript(boolean storeStdOut, boolean storeStdErr, String script, String ... parameters) throws IOException {
        LOGGER.log(Level.INFO, "script:\n{0}", script);
        File scriptFile = null;
        try {
            scriptFile = this.createScript(script);
            String scriptPath = scriptFile.getPath();
            int parametersCount = parameters.length;
            String[] commandArray = new String[1 + parametersCount];
            commandArray[0] = scriptPath;
            System.arraycopy(parameters, 0, commandArray, 1, parametersCount);
            int n2 = this.executeProcess(storeStdOut, storeStdErr, commandArray);
            return n2;
        }
        finally {
            if (scriptFile != null && !scriptFile.delete()) {
                LOGGER.log(Level.WARNING, "could not delete {0}", scriptFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createScript(String script) throws IOException {
        File scriptFile = null;
        try (OutputStreamWriter fileWriter = null;){
            scriptFile = File.createTempFile("processExecutor", null);
            fileWriter = new FileWriter(scriptFile);
            fileWriter.write(script);
        }
        scriptFile.setExecutable(true);
        return scriptFile;
    }

    public int executeProcess(String ... commandArray) {
        return this.executeProcess(false, false, commandArray);
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public int executeProcess(boolean storeStdOut, boolean storeStdErr, String ... commandArray) {
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("executing \"");
            for (int i2 = 0; i2 < commandArray.length; ++i2) {
                stringBuilder.append(commandArray[i2]);
                if (i2 == commandArray.length - 1) continue;
                stringBuilder.append(" ");
            }
            stringBuilder.append("\"");
            LOGGER.fine(stringBuilder.toString());
        }
        this.stdOut = new ArrayList<String>();
        this.stdErr = new ArrayList<String>();
        this.stdAll = new ArrayList<String>();
        ProcessBuilder processBuilder = new ProcessBuilder(commandArray);
        if (this.environment != null) {
            processBuilder.environment().putAll(this.environment);
        }
        try {
            this.process = processBuilder.start();
            StreamReader stdoutReader = new StreamReader(this.process.getInputStream(), "OUTPUT", this.stdOut, this.stdAll, storeStdOut);
            StreamReader stderrReader = new StreamReader(this.process.getErrorStream(), "ERROR", this.stdErr, this.stdAll, storeStdErr);
            stdoutReader.start();
            stderrReader.start();
            int exitValue = this.process.waitFor();
            LOGGER.log(Level.FINE, "exitValue = {0}", exitValue);
            if (storeStdOut) {
                stdoutReader.join();
            }
            if (storeStdErr) {
                stderrReader.join();
            }
            return exitValue;
        }
        catch (IOException e2) {
            LOGGER.log(Level.WARNING, null, e2);
        }
        catch (InterruptedException e3) {
            LOGGER.log(Level.WARNING, null, e3);
        }
        return -1;
    }

    public String getOutput() {
        return ProcessExecutor.listToString(this.stdAll);
    }

    public String getStdOut() {
        return ProcessExecutor.listToString(this.stdOut);
    }

    public List<String> getStdOutList() {
        return this.stdOut;
    }

    public String getStdErr() {
        return ProcessExecutor.listToString(this.stdErr);
    }

    public List<String> getStdErrList() {
        return this.stdErr;
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private static String listToString(List<String> lines) {
        if (lines == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            stringBuilder.append(line);
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private class StreamReader
    extends Thread {
        private final InputStream inputStream;
        private final String type;
        private final List<String> output;
        private final List<String> all;
        private final boolean storeOutput;

        public StreamReader(InputStream inputStream, String type, List<String> output, List<String> all, boolean storeOutput) {
            super("ProcessExecutor.StreamReader");
            this.inputStream = inputStream;
            this.type = type;
            this.output = output;
            this.all = all;
            this.storeOutput = storeOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((line = reader.readLine()) != null) {
                    ProcessExecutor.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, ProcessExecutor.LINE, null, line));
                    if (!this.storeOutput && !LOGGER.isLoggable(Level.FINE)) continue;
                    String allLine = this.type + ">" + line;
                    if (this.storeOutput) {
                        this.output.add(line);
                        this.all.add(allLine);
                    }
                    LOGGER.fine(allLine);
                }
            }
            catch (Exception e2) {
                LOGGER.log(Level.WARNING, null, e2);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

