/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;

public class ImageTools {
    public static String encodeImage(BufferedImage img) throws IOException {
        ByteArrayOutputStream bObj = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", bObj);
        return ImageTools.byteArrayToString64(bObj.toByteArray());
    }

    public static BufferedImage decodeImage(String str) throws IOException {
        byte[] imageByteArray = ImageTools.string64ToByteArray(str);
        ByteArrayInputStream bObj = new ByteArrayInputStream(imageByteArray);
        return ImageIO.read(bObj);
    }

    public static String byteArrayToString64(byte[] byteArray) {
        return Base64.encodeBase64URLSafeString((byte[])byteArray);
    }

    public static byte[] string64ToByteArray(String dataString) {
        return Base64.decodeBase64((String)dataString);
    }

    public static byte[] ImageToByte(File file) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
                System.out.println("read " + readNum + " bytes,");
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    public static Image byteaToImage(byte[] value, boolean isThumbnail) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(value);
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("png");
            ImageReader reader = readers.next();
            ByteArrayInputStream source = bis;
            ImageInputStream iis = ImageIO.createImageInputStream(source);
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            if (isThumbnail) {
                param.setSourceSubsampling(4, 4, 0, 0);
            }
            return reader.read(0, param);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static Icon stretchIcon(ImageIcon icon, int width, int height) {
        int h2;
        double s2;
        if (icon == null) {
            return null;
        }
        int w2 = icon.getIconWidth();
        double s1 = (double)w2 / (double)width;
        int newW = s1 < (s2 = (double)(h2 = icon.getIconHeight()) / (double)height) ? (int)((double)w2 / s1) : (int)((double)w2 / s2);
        return new ImageIcon(icon.getImage().getScaledInstance(newW, -1, 4));
    }
}

