/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.swingplus;

import com.ucod.swingplus.UITheme;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;

public class VirtualKeyboard
extends JDialog {
    private Robot robot;
    private EventListenerList listenerList;
    private static final List<Key> KEYMAP_ES = Collections.unmodifiableList(Arrays.asList(new Key("q", 81, null, false), new Key("w", 87, null, false), new Key("e", 69, null, false), new Key("r", 82, null, false), new Key("t", 84, null, false), new Key("y", 89, null, false), new Key("u", 85, null, false), new Key("i", 73, null, false), new Key("o", 79, null, false), new Key("p", 80, null, false), new Key("a", 65, null, false), new Key("s", 83, null, false), new Key("d", 68, null, false), new Key("f", 70, null, false), new Key("g", 71, null, false), new Key("h", 72, null, false), new Key("j", 74, null, false), new Key("k", 75, null, false), new Key("l", 76, null, false), new Key("\u00f1", 241, null, true), new Key("z", 90, null, false), new Key("x", 88, null, false), new Key("c", 67, null, false), new Key("v", 86, null, false), new Key("b", 66, null, false), new Key("n", 78, null, false), new Key("m", 77, null, false)));
    private static final List<Key> SYMMAP_ES = Collections.unmodifiableList(Arrays.asList(new Key("1", 49, null, false), new Key("2", 50, null, false), new Key("3", 51, null, false), new Key("4", 52, null, false), new Key("5", 53, null, false), new Key("6", 54, null, false), new Key("7", 55, null, false), new Key("8", 56, null, false), new Key("9", 57, null, false), new Key("0", 48, null, false), new Key("!", 517, KeyboardModifier.shift, false), new Key("@", 50, KeyboardModifier.shift, false), new Key("#", 51, KeyboardModifier.shift, false), new Key("$", 515, KeyboardModifier.shift, false), new Key("+", 521, KeyboardModifier.shift, false), new Key("&", 150, KeyboardModifier.shift, false), new Key("/", 111, null, false), new Key("(", 519, null, false), new Key(")", 522, null, false), new Key("*", 106, null, false), new Key("-", 109, null, false), new Key("<", 153, null, false), new Key(">", 153, KeyboardModifier.shift, false), new Key(":", 513, KeyboardModifier.shift, false), new Key(";", 513, null, false), new Key("'", 222, null, false), new Key("?", 47, KeyboardModifier.shift, false)));
    private Map<Component, Key> KeyMap = new HashMap<Component, Key>();
    private Map<Component, Key> SymMap = new HashMap<Component, Key>();
    KeyboardModifier modifier = KeyboardModifier.normal;
    protected boolean capsLock = false;
    protected boolean symbols = false;
    private Component targetComp;
    private JButton backspaceButton;
    private JPanel buttonsPanel;
    private JButton commaButton;
    private JButton enterButton;
    private JButton hideButton;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton14;
    private JButton jButton15;
    private JButton jButton16;
    private JButton jButton17;
    private JButton jButton18;
    private JButton jButton19;
    private JButton jButton20;
    private JButton jButton21;
    private JButton jButton22;
    private JButton jButton23;
    private JButton jButton25;
    private JButton jButton26;
    private JButton jButton27;
    private JButton jButton28;
    private JButton jButton29;
    private JButton jButton3;
    private JButton jButton30;
    private JButton jButton31;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JButton periodButton;
    private JPanel row1Panel;
    private JPanel row2Panel;
    private JPanel row3Panel;
    private JPanel row4Panel;
    private JButton shiftButton;
    private JButton spaceButton;
    private JButton symbolButton;

    public VirtualKeyboard(boolean modal) throws AWTException {
        super((Frame)null, modal);
        this.listenerList = new EventListenerList();
        this.init();
    }

    public VirtualKeyboard(Frame parent, boolean modal) throws AWTException {
        super(parent, modal);
        this.listenerList = new EventListenerList();
        this.init();
    }

    public VirtualKeyboard(Dialog parent, boolean modal) throws AWTException {
        super(parent, modal);
        this.listenerList = new EventListenerList();
        this.init();
    }

    private void init() throws AWTException {
        Key sym;
        Key key;
        JButton button;
        this.robot = new Robot();
        this.initComponents();
        int i2 = 0;
        for (Component comp : this.row1Panel.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            button = (JButton)comp;
            key = KEYMAP_ES.get(i2);
            sym = SYMMAP_ES.get(i2);
            ++i2;
            this.KeyMap.put(comp, key);
            this.SymMap.put(comp, sym);
            button.setText(key.getName());
        }
        for (Component comp : this.row2Panel.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            button = (JButton)comp;
            key = KEYMAP_ES.get(i2);
            sym = SYMMAP_ES.get(i2);
            ++i2;
            this.KeyMap.put(comp, key);
            this.SymMap.put(comp, sym);
            button.setText(key.getName());
        }
        for (Component comp : this.row3Panel.getComponents()) {
            if (!(comp instanceof JButton) || "SYSTEM".equals((button = (JButton)comp).getActionCommand())) continue;
            key = KEYMAP_ES.get(i2);
            sym = SYMMAP_ES.get(i2);
            ++i2;
            this.KeyMap.put(comp, key);
            this.SymMap.put(comp, sym);
            button.setText(key.getName());
        }
    }

    protected void insertString(JTextField textField, String s2) {
        try {
            int pos = textField.getCaretPosition();
            textField.getDocument().insertString(pos, s2, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(VirtualKeyboard.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected KeyboardModifier getModifier() {
        return this.modifier;
    }

    protected void setModifier(KeyboardModifier modifier) {
        if (!this.modifier.equals((Object)modifier)) {
            if (KeyboardModifier.shift.equals((Object)this.modifier)) {
                this.robot.keyRelease(16);
            } else if (KeyboardModifier.alt.equals((Object)this.modifier)) {
                this.robot.keyRelease(18);
            } else if (KeyboardModifier.altshift.equals((Object)this.modifier)) {
                this.robot.keyRelease(16);
                this.robot.keyRelease(18);
            } else if (KeyboardModifier.altgraph.equals((Object)this.modifier)) {
                this.robot.keyRelease(65406);
            }
            if (KeyboardModifier.shift.equals((Object)modifier)) {
                String text;
                for (Component comp : this.row1Panel.getComponents()) {
                    if (!(comp instanceof JButton)) continue;
                    text = ((JButton)comp).getText().toUpperCase();
                    ((JButton)comp).setText(text);
                }
                for (Component comp : this.row2Panel.getComponents()) {
                    if (!(comp instanceof JButton)) continue;
                    text = ((JButton)comp).getText().toUpperCase();
                    ((JButton)comp).setText(text);
                }
                for (Component comp : this.row3Panel.getComponents()) {
                    if (!(comp instanceof JButton)) continue;
                    text = ((JButton)comp).getText().toUpperCase();
                    ((JButton)comp).setText(text);
                }
                this.robot.keyPress(16);
            } else {
                String text;
                for (Component comp : this.row1Panel.getComponents()) {
                    if (!(comp instanceof JButton)) continue;
                    text = ((JButton)comp).getText().toLowerCase();
                    ((JButton)comp).setText(text);
                }
                for (Component comp : this.row2Panel.getComponents()) {
                    if (!(comp instanceof JButton)) continue;
                    text = ((JButton)comp).getText().toLowerCase();
                    ((JButton)comp).setText(text);
                }
                for (Component comp : this.row3Panel.getComponents()) {
                    if (!(comp instanceof JButton)) continue;
                    text = ((JButton)comp).getText().toLowerCase();
                    ((JButton)comp).setText(text);
                }
                if (KeyboardModifier.alt.equals((Object)modifier)) {
                    this.robot.keyPress(18);
                } else if (KeyboardModifier.altshift.equals((Object)modifier)) {
                    this.robot.keyPress(16);
                    this.robot.keyPress(18);
                } else if (KeyboardModifier.altgraph.equals((Object)this.modifier)) {
                    this.robot.keyPress(65406);
                }
            }
            this.modifier = modifier;
        }
    }

    protected void sendKey(int vkCode, KeyboardModifier modifier) {
        KeyboardModifier oldModif = null;
        if (modifier != null && this.modifier != modifier) {
            oldModif = this.modifier;
            if (KeyboardModifier.shift.equals((Object)oldModif)) {
                this.robot.keyRelease(16);
            } else if (KeyboardModifier.alt.equals((Object)oldModif)) {
                this.robot.keyRelease(18);
            } else if (KeyboardModifier.altshift.equals((Object)oldModif)) {
                this.robot.keyRelease(16);
                this.robot.keyRelease(18);
            } else if (KeyboardModifier.altgraph.equals((Object)oldModif)) {
                this.robot.keyRelease(65406);
            }
            if (KeyboardModifier.shift.equals((Object)modifier)) {
                this.robot.keyPress(16);
            } else if (KeyboardModifier.alt.equals((Object)modifier)) {
                this.robot.keyPress(18);
            } else if (KeyboardModifier.altshift.equals((Object)modifier)) {
                this.robot.keyPress(16);
                this.robot.keyPress(18);
            } else if (KeyboardModifier.altgraph.equals((Object)modifier)) {
                this.robot.keyPress(65406);
            }
        }
        this.robot.keyPress(vkCode);
        this.robot.keyRelease(vkCode);
        if (oldModif != null) {
            if (KeyboardModifier.shift.equals((Object)modifier)) {
                this.robot.keyRelease(16);
            } else if (KeyboardModifier.alt.equals((Object)modifier)) {
                this.robot.keyRelease(18);
            } else if (KeyboardModifier.altshift.equals((Object)modifier)) {
                this.robot.keyRelease(16);
                this.robot.keyRelease(18);
            } else if (KeyboardModifier.altgraph.equals((Object)modifier)) {
                this.robot.keyRelease(65406);
            }
            if (KeyboardModifier.shift.equals((Object)oldModif)) {
                this.robot.keyPress(16);
            } else if (KeyboardModifier.alt.equals((Object)oldModif)) {
                this.robot.keyPress(18);
            } else if (KeyboardModifier.altshift.equals((Object)oldModif)) {
                this.robot.keyPress(16);
                this.robot.keyPress(18);
            } else if (KeyboardModifier.altgraph.equals((Object)oldModif)) {
                this.robot.keyPress(65406);
            }
        }
    }

    protected boolean areSymbolsVisible() {
        return this.symbols;
    }

    protected void setSymbols(boolean show_symbols) {
        Key key;
        JButton button;
        Map<Component, Key> map;
        this.symbols = show_symbols;
        if (show_symbols) {
            this.symbolButton.setText("ABC");
            map = this.SymMap;
            this.setModifier(KeyboardModifier.normal);
        } else {
            this.symbolButton.setText("123");
            map = this.KeyMap;
        }
        for (Component comp : this.row1Panel.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            button = (JButton)comp;
            key = map.get(comp);
            if (key != null) {
                button.setText(key.getName());
                continue;
            }
            button.setText("");
        }
        for (Component comp : this.row2Panel.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            button = (JButton)comp;
            key = map.get(comp);
            if (key != null) {
                button.setText(key.getName());
                continue;
            }
            button.setText("");
        }
        for (Component comp : this.row3Panel.getComponents()) {
            if (!(comp instanceof JButton) || "SYSTEM".equals((button = (JButton)comp).getActionCommand())) continue;
            key = map.get(comp);
            if (key != null) {
                button.setText(key.getName());
                continue;
            }
            button.setText("");
        }
    }

    protected boolean isCapsLock() {
        return this.capsLock;
    }

    protected void setCapsLock(boolean capsLock) {
        this.capsLock = capsLock;
        this.shiftButton.setSelected(capsLock);
        this.setModifier(this.isCapsLock() ? KeyboardModifier.shift : KeyboardModifier.normal);
    }

    public Component getTargetComp() {
        return this.targetComp;
    }

    public void setTargetComp(Component targetComp) {
        this.targetComp = targetComp;
    }

    @Override
    public void setVisible(boolean b2) {
        if (b2 == this.isVisible()) {
            return;
        }
        if (b2) {
            this.setSymbols(false);
            this.setCapsLock(false);
        }
        super.setVisible(b2);
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.row1Panel = new JPanel();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jButton12 = new JButton();
        this.row2Panel = new JPanel();
        this.jButton14 = new JButton();
        this.jButton15 = new JButton();
        this.jButton16 = new JButton();
        this.jButton17 = new JButton();
        this.jButton18 = new JButton();
        this.jButton19 = new JButton();
        this.jButton20 = new JButton();
        this.jButton21 = new JButton();
        this.jButton22 = new JButton();
        this.jButton23 = new JButton();
        this.row3Panel = new JPanel();
        this.shiftButton = new JButton();
        this.jButton25 = new JButton();
        this.jButton26 = new JButton();
        this.jButton27 = new JButton();
        this.jButton28 = new JButton();
        this.jButton29 = new JButton();
        this.jButton30 = new JButton();
        this.jButton31 = new JButton();
        this.backspaceButton = new JButton();
        this.row4Panel = new JPanel();
        this.hideButton = new JButton();
        this.symbolButton = new JButton();
        this.spaceButton = new JButton();
        this.commaButton = new JButton();
        this.periodButton = new JButton();
        this.enterButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setBounds(new Rectangle(0, 165, 800, 315));
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 325));
        this.setMinimumSize(new Dimension(383, 325));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(800, 315));
        this.setResizable(false);
        this.buttonsPanel.setLayout(new GridLayout(4, 1));
        this.row1Panel.setLayout(new FlowLayout(1, 5, 2));
        this.jButton3.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton3.setText("q");
        this.jButton3.setFocusPainted(false);
        this.jButton3.setPreferredSize(new Dimension(74, 74));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton3);
        this.jButton4.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton4.setText("w");
        this.jButton4.setFocusPainted(false);
        this.jButton4.setPreferredSize(new Dimension(74, 74));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton4);
        this.jButton5.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton5.setText("e");
        this.jButton5.setFocusPainted(false);
        this.jButton5.setPreferredSize(new Dimension(74, 74));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton5);
        this.jButton6.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton6.setText("r");
        this.jButton6.setFocusPainted(false);
        this.jButton6.setPreferredSize(new Dimension(74, 74));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton6);
        this.jButton7.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton7.setText("t");
        this.jButton7.setFocusPainted(false);
        this.jButton7.setPreferredSize(new Dimension(74, 74));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton7);
        this.jButton8.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton8.setText("y");
        this.jButton8.setFocusPainted(false);
        this.jButton8.setPreferredSize(new Dimension(74, 74));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton8);
        this.jButton9.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton9.setText("u");
        this.jButton9.setFocusPainted(false);
        this.jButton9.setPreferredSize(new Dimension(74, 74));
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton9);
        this.jButton10.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton10.setText("i");
        this.jButton10.setFocusPainted(false);
        this.jButton10.setPreferredSize(new Dimension(74, 74));
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton10);
        this.jButton11.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton11.setText("o");
        this.jButton11.setFocusPainted(false);
        this.jButton11.setPreferredSize(new Dimension(74, 74));
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton11);
        this.jButton12.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton12.setText("p");
        this.jButton12.setFocusPainted(false);
        this.jButton12.setPreferredSize(new Dimension(74, 74));
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row1Panel.add(this.jButton12);
        this.buttonsPanel.add(this.row1Panel);
        this.row2Panel.setLayout(new FlowLayout(1, 5, 2));
        this.jButton14.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton14.setText("a");
        this.jButton14.setFocusPainted(false);
        this.jButton14.setPreferredSize(new Dimension(74, 74));
        this.jButton14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton14);
        this.jButton15.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton15.setText("s");
        this.jButton15.setFocusPainted(false);
        this.jButton15.setPreferredSize(new Dimension(74, 74));
        this.jButton15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton15);
        this.jButton16.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton16.setText("d");
        this.jButton16.setFocusPainted(false);
        this.jButton16.setPreferredSize(new Dimension(74, 74));
        this.jButton16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton16);
        this.jButton17.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton17.setText("f");
        this.jButton17.setFocusPainted(false);
        this.jButton17.setPreferredSize(new Dimension(74, 74));
        this.jButton17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton17);
        this.jButton18.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton18.setText("g");
        this.jButton18.setFocusPainted(false);
        this.jButton18.setPreferredSize(new Dimension(74, 74));
        this.jButton18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton18);
        this.jButton19.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton19.setText("h");
        this.jButton19.setFocusPainted(false);
        this.jButton19.setPreferredSize(new Dimension(74, 74));
        this.jButton19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton19);
        this.jButton20.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton20.setText("j");
        this.jButton20.setFocusPainted(false);
        this.jButton20.setPreferredSize(new Dimension(74, 74));
        this.jButton20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton20);
        this.jButton21.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton21.setText("k");
        this.jButton21.setFocusPainted(false);
        this.jButton21.setPreferredSize(new Dimension(74, 74));
        this.jButton21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton21);
        this.jButton22.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton22.setText("l");
        this.jButton22.setFocusPainted(false);
        this.jButton22.setPreferredSize(new Dimension(74, 74));
        this.jButton22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton22);
        this.jButton23.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton23.setText("\u00f1");
        this.jButton23.setFocusPainted(false);
        this.jButton23.setPreferredSize(new Dimension(74, 74));
        this.jButton23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row2Panel.add(this.jButton23);
        this.buttonsPanel.add(this.row2Panel);
        this.row3Panel.setPreferredSize(new Dimension(749, 80));
        this.row3Panel.setLayout(new FlowLayout(1, 5, 2));
        this.shiftButton.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.shiftButton.setForeground(UITheme.WHITE);
        this.shiftButton.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/i32/shift-32-dark.png")));
        this.shiftButton.setActionCommand("SYSTEM");
        this.shiftButton.setFocusPainted(false);
        this.shiftButton.setPreferredSize(new Dimension(85, 74));
        this.shiftButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/i32/shift-32.png")));
        this.shiftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.shiftButtonActionPerformed(evt);
            }
        });
        this.row3Panel.add(this.shiftButton);
        this.jButton25.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton25.setText("z");
        this.jButton25.setFocusPainted(false);
        this.jButton25.setPreferredSize(new Dimension(74, 74));
        this.jButton25.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row3Panel.add(this.jButton25);
        this.jButton26.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton26.setText("x");
        this.jButton26.setFocusPainted(false);
        this.jButton26.setPreferredSize(new Dimension(74, 74));
        this.jButton26.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row3Panel.add(this.jButton26);
        this.jButton27.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton27.setText("c");
        this.jButton27.setFocusPainted(false);
        this.jButton27.setPreferredSize(new Dimension(74, 74));
        this.jButton27.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row3Panel.add(this.jButton27);
        this.jButton28.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton28.setText("v");
        this.jButton28.setFocusPainted(false);
        this.jButton28.setPreferredSize(new Dimension(74, 74));
        this.jButton28.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row3Panel.add(this.jButton28);
        this.jButton29.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton29.setText("b");
        this.jButton29.setFocusPainted(false);
        this.jButton29.setPreferredSize(new Dimension(74, 74));
        this.jButton29.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row3Panel.add(this.jButton29);
        this.jButton30.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton30.setText("n");
        this.jButton30.setFocusPainted(false);
        this.jButton30.setPreferredSize(new Dimension(74, 74));
        this.jButton30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row3Panel.add(this.jButton30);
        this.jButton31.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.jButton31.setText("m");
        this.jButton31.setFocusPainted(false);
        this.jButton31.setPreferredSize(new Dimension(74, 74));
        this.jButton31.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.btnEvent(evt);
            }
        });
        this.row3Panel.add(this.jButton31);
        this.backspaceButton.setFont(new Font("Segoe UI Semibold", 1, 36));
        this.backspaceButton.setForeground(UITheme.WHITE);
        this.backspaceButton.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/i48/delete_back-48-dark.png")));
        this.backspaceButton.setToolTipText("");
        this.backspaceButton.setActionCommand("SYSTEM");
        this.backspaceButton.setFocusPainted(false);
        this.backspaceButton.setPreferredSize(new Dimension(96, 74));
        this.backspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.backspaceButtonActionPerformed(evt);
            }
        });
        this.row3Panel.add(this.backspaceButton);
        this.buttonsPanel.add(this.row3Panel);
        this.row4Panel.setLayout(new FlowLayout(1, 5, 2));
        this.hideButton.setFont(new Font("Segoe UI Semibold", 1, 24));
        this.hideButton.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/i32/12_hardware_keyboard.png")));
        this.hideButton.setFocusPainted(false);
        this.hideButton.setPreferredSize(new Dimension(85, 74));
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.hideButtonActionPerformed(evt);
            }
        });
        this.row4Panel.add(this.hideButton);
        this.symbolButton.setFont(new Font("Segoe UI Semibold", 1, 24));
        this.symbolButton.setText("123");
        this.symbolButton.setFocusPainted(false);
        this.symbolButton.setPreferredSize(new Dimension(85, 74));
        this.symbolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.symbolButtonActionPerformed(evt);
            }
        });
        this.row4Panel.add(this.symbolButton);
        this.spaceButton.setFont(new Font("Segoe UI Semibold", 1, 24));
        this.spaceButton.setFocusPainted(false);
        this.spaceButton.setPreferredSize(new Dimension(300, 74));
        this.spaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.spaceButtonActionPerformed(evt);
            }
        });
        this.row4Panel.add(this.spaceButton);
        this.commaButton.setFont(new Font("Segoe UI Semibold", 1, 24));
        this.commaButton.setText(",");
        this.commaButton.setActionCommand("VK_COMMA");
        this.commaButton.setFocusPainted(false);
        this.commaButton.setPreferredSize(new Dimension(74, 74));
        this.commaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.commaButtonActionPerformed(evt);
            }
        });
        this.row4Panel.add(this.commaButton);
        this.periodButton.setFont(new Font("Segoe UI Semibold", 1, 24));
        this.periodButton.setText(".");
        this.periodButton.setActionCommand("VK_PERIOD");
        this.periodButton.setFocusPainted(false);
        this.periodButton.setPreferredSize(new Dimension(74, 74));
        this.periodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.periodButtonActionPerformed(evt);
            }
        });
        this.row4Panel.add(this.periodButton);
        this.enterButton.setBackground(new Color(0, 153, 204));
        this.enterButton.setFont(new Font("Segoe UI Semibold", 1, 24));
        this.enterButton.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/i32/enter-32.png")));
        this.enterButton.setToolTipText("");
        this.enterButton.setFocusPainted(false);
        this.enterButton.setPreferredSize(new Dimension(130, 74));
        this.enterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.enterButtonActionPerformed(evt);
            }
        });
        this.row4Panel.add(this.enterButton);
        this.buttonsPanel.add(this.row4Panel);
        this.getContentPane().add((Component)this.buttonsPanel, "Center");
        this.pack();
    }

    public void addActionListener(ActionListener l2) {
        this.listenerList.add(ActionListener.class, l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.listenerList.remove(ActionListener.class, l2);
    }

    private void btnEvent(ActionEvent evt) {
        Object comp = evt.getSource();
        if (comp instanceof JButton) {
            JButton button = (JButton)comp;
            Toolkit.getDefaultToolkit().beep();
            Key key = this.areSymbolsVisible() ? this.SymMap.get(button) : this.KeyMap.get(button);
            if (key != null) {
                if (key.isUnicode()) {
                    if (this.targetComp != null && this.targetComp instanceof JTextField) {
                        String text = ((JTextField)this.targetComp).getText();
                        text = text + button.getText();
                        ((JTextField)this.targetComp).setText(text);
                    }
                } else {
                    this.sendKey(key.getKey(), key.getModifier());
                }
            }
            button.setSelected(false);
        }
        if (!this.isCapsLock() && !this.areSymbolsVisible()) {
            this.setModifier(KeyboardModifier.normal);
        }
    }

    private void backspaceButtonActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().beep();
        this.sendKey(8, null);
    }

    private void symbolButtonActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().beep();
        this.setSymbols(!this.symbols);
    }

    private void shiftButtonActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().beep();
        if (this.areSymbolsVisible()) {
            return;
        }
        if (this.getModifier() == KeyboardModifier.shift && !this.isCapsLock()) {
            this.setCapsLock(true);
        } else if (this.isCapsLock()) {
            this.setCapsLock(false);
        } else {
            this.setModifier(KeyboardModifier.shift);
        }
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ActionListener.class) continue;
            ((ActionListener)listeners[i2 + 1]).actionPerformed(e2);
        }
    }

    private void hideButtonActionPerformed(ActionEvent evt) {
        this.setModifier(KeyboardModifier.normal);
        this.fireActionPerformed(evt);
        this.setVisible(false);
    }

    private void enterButtonActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().beep();
        this.sendKey(10, null);
    }

    private void commaButtonActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().beep();
        this.sendKey(44, null);
    }

    private void periodButtonActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().beep();
        this.sendKey(46, null);
    }

    private void spaceButtonActionPerformed(ActionEvent evt) {
        Toolkit.getDefaultToolkit().beep();
        this.sendKey(32, null);
    }

    private void hideKeyboard() {
        this.setModifier(KeyboardModifier.normal);
        this.setVisible(false);
        this.getParent().requestFocus();
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(VirtualKeyboard.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(VirtualKeyboard.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(VirtualKeyboard.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(VirtualKeyboard.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualKeyboard dialog = new VirtualKeyboard((Frame)new JFrame(), true);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e2) {
                            System.exit(0);
                        }
                    });
                    dialog.setVisible(true);
                }
                catch (AWTException ex) {
                    Logger.getLogger(VirtualKeyboard.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private static class Key {
        String name;
        int key;
        KeyboardModifier modifier;
        boolean unicode;

        Key(String name, int key, KeyboardModifier modifier, boolean unicode) {
            this.key = key;
            this.name = name;
            this.modifier = modifier;
            this.unicode = unicode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        public KeyboardModifier getModifier() {
            return this.modifier;
        }

        public void setModifier(KeyboardModifier modifier) {
            this.modifier = modifier;
        }

        public boolean isUnicode() {
            return this.unicode;
        }

        public void setUnicode(boolean unicode) {
            this.unicode = unicode;
        }
    }

    public static enum KeyboardModifier {
        normal,
        shift,
        alt,
        altshift,
        altgraph;

    }
}

