/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.swingplus;

import com.ucod.swingplus.UITheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropsPanel
extends JPanel
implements ActionListener {
    private JPanel topPanel = new JPanel(new GridLayout(1, 1));
    private JPanel bottomPanel = new JPanel(new GridLayout(1, 1));
    private Map bars = new LinkedHashMap();
    private int visibleBar = 0;
    private JComponent visibleComponent = null;
    private static final int BAR_HEIGHT = 36;

    public PropsPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
    }

    public void addBar(String name, JComponent component) {
        BarInfo barInfo = new BarInfo(name, component);
        barInfo.getButton().addActionListener(this);
        this.bars.put(name, barInfo);
        this.render();
    }

    public void addBar(String name, Icon icon, JComponent component) {
        BarInfo barInfo = new BarInfo(name, icon, component);
        barInfo.getButton().addActionListener(this);
        this.bars.put(name, barInfo);
        this.render();
    }

    public void removeBar(String name) {
        this.bars.remove(name);
        this.render();
    }

    public int getVisibleBar() {
        return this.visibleBar;
    }

    public void setVisibleBar(int visibleBar) {
        if (visibleBar >= 0 && visibleBar < this.bars.size()) {
            this.visibleBar = visibleBar;
            this.render();
        }
    }

    public void hideBar(String panelName) {
        BarInfo barInfo = (BarInfo)this.bars.get(panelName);
        if (barInfo != null) {
            barInfo.setVisible(false);
        }
    }

    public void showBar(String panelName) {
        BarInfo barInfo = (BarInfo)this.bars.get(panelName);
        if (barInfo != null) {
            barInfo.setVisible(true);
        }
    }

    public void render() {
        String barName;
        int i2;
        BarInfo barInfo = null;
        BarInfo visibleBarInfo = null;
        Iterator itr = this.bars.keySet().iterator();
        int totalBars = 0;
        int topBars = 0;
        for (i2 = 0; i2 < this.bars.size(); ++i2) {
            barName = (String)itr.next();
            barInfo = (BarInfo)this.bars.get(barName);
            if (!barInfo.getButton().isVisible()) continue;
            ++totalBars;
            if (i2 > this.visibleBar) continue;
            ++topBars;
        }
        int bottomBars = totalBars - topBars;
        this.topPanel.removeAll();
        GridLayout topLayout = (GridLayout)this.topPanel.getLayout();
        topLayout.setRows(topBars);
        itr = this.bars.keySet().iterator();
        for (i2 = 0; i2 <= this.visibleBar; ++i2) {
            barName = (String)itr.next();
            barInfo = (BarInfo)this.bars.get(barName);
            if (!barInfo.getButton().isVisible()) continue;
            visibleBarInfo = barInfo;
            this.topPanel.add(barInfo.getButton());
        }
        this.topPanel.validate();
        if (visibleBarInfo != null) {
            if (this.visibleComponent != null) {
                this.remove(this.visibleComponent);
            }
            this.visibleComponent = visibleBarInfo.getComponent();
            this.add((Component)this.visibleComponent, "Center");
        }
        this.bottomPanel.removeAll();
        GridLayout bottomLayout = (GridLayout)this.bottomPanel.getLayout();
        bottomLayout.setRows(bottomBars);
        for (i2 = this.visibleBar + 1; i2 < this.bars.size(); ++i2) {
            barName = (String)itr.next();
            barInfo = (BarInfo)this.bars.get(barName);
            if (!barInfo.getButton().isVisible()) continue;
            this.bottomPanel.add(barInfo.getButton());
        }
        this.bottomPanel.validate();
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        int currentBar = 0;
        for (String barName : this.bars.keySet()) {
            BarInfo barInfo = (BarInfo)this.bars.get(barName);
            if (barInfo.getButton() == e2.getSource()) {
                this.visibleBar = currentBar;
                this.render();
                return;
            }
            ++currentBar;
        }
    }

    public static JPanel getDummyPanel(String name) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JLabel(name, 0));
        return panel;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("PropsPanel Test");
        PropsPanel panelBar = new PropsPanel();
        panelBar.addBar("One", PropsPanel.getDummyPanel("One"));
        panelBar.addBar("Two", PropsPanel.getDummyPanel("Two"));
        panelBar.addBar("Three", PropsPanel.getDummyPanel("Three"));
        panelBar.addBar("Four", PropsPanel.getDummyPanel("Four"));
        panelBar.setVisibleBar(2);
        frame.getContentPane().add(panelBar);
        frame.setSize(800, 600);
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(d2.width / 2 - 400, d2.height / 2 - 300);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class BarInfo {
        private String name;
        private JButton button;
        private JComponent component;

        public BarInfo(String name, JComponent component) {
            this(name, null, component);
        }

        public BarInfo(String name, Icon icon, JComponent component) {
            this.name = name;
            this.component = component;
            this.button = icon == null ? new JButton(name) : new JButton(name, icon);
            Rectangle r2 = this.button.getBounds();
            this.button.setPreferredSize(new Dimension(r2.width, 36));
            this.button.setFocusable(false);
            this.button.setBackground(UITheme.DGRAY);
            this.button.setForeground(UITheme.WHITE);
            Font font = this.button.getFont();
            font = font.deriveFont(1);
            this.button.setFont(font);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JButton getButton() {
            return this.button;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void setVisible(boolean value) {
            this.component.setVisible(value);
            this.button.setVisible(value);
        }
    }
}

