/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.swingplus;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class JKinecticScroll {
    private static final HashMap<JScrollPane, MouseEventListener> listeners = new HashMap();
    private static int rowHeight;

    private JKinecticScroll() {
    }

    public static void install(JScrollPane p2) {
        JComponent itm;
        rowHeight = 42;
        AWTEventListener awtevtlis = JKinecticScroll.createAWTWindowListener();
        Toolkit.getDefaultToolkit().addAWTEventListener(awtevtlis, 16L);
        Toolkit.getDefaultToolkit().addAWTEventListener(awtevtlis, 32L);
        listeners.put(p2, new MouseEventListener(p2));
        Component c2 = p2.getViewport().getView();
        if (c2 instanceof JTable) {
            itm = (JTable)c2;
            ((JTable)itm).setRowHeight(rowHeight);
        }
        if (c2 instanceof JList) {
            itm = (JList)c2;
            ((JList)itm).setFixedCellHeight(rowHeight);
        }
        if (c2 instanceof JComponent) {
            itm = (JComponent)c2;
            itm.setAutoscrolls(false);
            Font f2 = itm.getFont();
            Font nf = new Font(f2.getFontName(), f2.getStyle(), 16);
            itm.setFont(nf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDispatchEvent(MouseEvent awte, JScrollPane comp) {
        MouseEventListener listener;
        HashMap<JScrollPane, MouseEventListener> hashMap = listeners;
        synchronized (hashMap) {
            if (!listeners.containsKey(comp)) {
                return;
            }
            listener = listeners.get(comp);
        }
        if (500 == awte.getID()) {
            listener.mouseClicked(awte);
        } else if (501 == awte.getID()) {
            listener.mousePressed(awte);
        } else if (502 == awte.getID()) {
            listener.mouseReleased(awte);
        } else if (504 == awte.getID()) {
            listener.mouseEntered(awte);
        } else if (505 == awte.getID()) {
            listener.mouseExited(awte);
        } else if (506 == awte.getID()) {
            listener.mouseDragged(awte);
        } else if (503 == awte.getID()) {
            listener.mouseMoved(awte);
        }
    }

    private static AWTEventListener createAWTWindowListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent awte) {
                MouseEvent event = (MouseEvent)awte;
                JScrollPane comp = JKinecticScroll.checkForScrollPanel(event.getComponent());
                if (comp != null) {
                    JKinecticScroll.doDispatchEvent(event, comp);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JScrollPane checkForScrollPanel(Component comp) {
        if (comp instanceof JScrollPane) {
            HashMap<JScrollPane, MouseEventListener> hashMap = listeners;
            synchronized (hashMap) {
                return listeners.containsKey((JScrollPane)comp) ? (JScrollPane)comp : null;
            }
        }
        if ((comp = comp.getParent()) != null) {
            return JKinecticScroll.checkForScrollPanel(comp);
        }
        return null;
    }

    private static class MouseEventListener
    implements MouseListener,
    MouseMotionListener {
        private Point lastPos = null;
        private Point relPos = null;
        private final ArrayList<MouseEvent> lastEvents = new ArrayList();
        private Thread kinetic = new Thread();
        private final JScrollPane pane;

        public MouseEventListener(JScrollPane pane) {
            this.pane = pane;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent me) {
            JViewport vp = this.pane.getViewport();
            if (this.lastPos == null) {
                this.lastPos = me.getLocationOnScreen();
            }
            if (this.pane.getVerticalScrollBar() != null && this.pane.getVerticalScrollBar().isVisible()) {
                this.moveBy(this.lastPos.x - me.getXOnScreen(), this.lastPos.y - me.getYOnScreen(), vp);
                ArrayList<MouseEvent> arrayList = this.lastEvents;
                synchronized (arrayList) {
                    if (this.lastEvents.size() > 5) {
                        this.lastEvents.remove(0);
                    }
                    this.lastEvents.add(me);
                }
            }
        }

        @Override
        public synchronized void mouseMoved(MouseEvent me) {
        }

        @Override
        public synchronized void mouseClicked(MouseEvent me) {
        }

        @Override
        public synchronized void mousePressed(MouseEvent me) {
            JViewport vp = this.pane.getViewport();
            this.lastPos = me.getLocationOnScreen();
            this.relPos = vp.getViewPosition();
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList arrayList = MouseEventListener.this.lastEvents;
                    synchronized (arrayList) {
                        MouseEventListener.this.lastEvents.clear();
                    }
                    MouseEventListener.this.kinetic.interrupt();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void mouseReleased(MouseEvent me) {
            if (this.pane.getVerticalScrollBar() != null && this.pane.getVerticalScrollBar().isVisible()) {
                MouseEvent first;
                MouseEvent last;
                JViewport vp = this.pane.getViewport();
                if (this.lastEvents.size() < 2) {
                    return;
                }
                ArrayList<MouseEvent> arrayList = this.lastEvents;
                synchronized (arrayList) {
                    last = this.lastEvents.get(this.lastEvents.size() - 1);
                    first = this.lastEvents.get(0);
                    this.lastEvents.clear();
                }
                Dimension vector = new Dimension(first.getXOnScreen() - last.getXOnScreen(), first.getYOnScreen() - last.getYOnScreen());
                long time = last.getWhen() - first.getWhen();
                Point2D.Float p2 = new Point2D.Float((float)vector.width / (float)time, (float)vector.height / (float)time);
                this.kinetic.interrupt();
                this.kinetic = new MoveThread(p2, vp);
                this.kinetic.start();
            }
        }

        @Override
        public synchronized void mouseEntered(MouseEvent me) {
        }

        @Override
        public synchronized void mouseExited(MouseEvent me) {
        }

        public void moveBy(int x2, int y2, JViewport vp) {
            Point vis = this.relPos.getLocation();
            vis.translate(x2, y2);
            if (vis.x < 0) {
                vis.x = 0;
            }
            if (vis.y < 0) {
                vis.y = 0;
            }
            if (vis.x + vp.getWidth() > vp.getViewSize().width) {
                vis.x = vp.getViewSize().width - vp.getWidth();
            }
            if (vis.y + vp.getHeight() > vp.getViewSize().height) {
                vis.y = vp.getViewSize().height - vp.getHeight();
            }
            vp.setViewPosition(vis);
        }

        private class MoveThread
        extends Thread {
            private Point2D speed;
            private final JViewport vp;
            private int ms = 20;
            private double modx = 0.0;
            private double mody = 0.0;

            public MoveThread(Point2D initialspeed, JViewport vp) {
                this.speed = initialspeed;
                this.vp = vp;
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        final double mx = this.speed.getX() * (double)this.ms + this.modx;
                        final double my = this.speed.getY() * (double)this.ms + this.mody;
                        if (mx <= 0.005 && my <= 0.005 && this.speed.getX() >= -0.005 && this.speed.getY() >= -0.005) {
                            return;
                        }
                        MouseEventListener.this.relPos = this.vp.getViewPosition();
                        this.modx = mx % 1.0;
                        this.mody = my % 1.0;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MouseEventListener.this.moveBy((int)mx, (int)my, MoveThread.this.vp);
                            }
                        });
                        this.speed.setLocation(this.speed.getX() / Math.exp((double)this.ms / 150.0), this.speed.getY() / Math.exp((double)this.ms / 150.0));
                        Thread.sleep(this.ms);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }
}

