/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.swingplus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

class CollapHeaderPanel
extends JPanel {
    int id;
    JLabel titleLabel;
    Color c1 = new Color(200, 180, 180);
    Color c2 = new Color(200, 220, 220);
    Color fontFg = Color.blue;
    Color rolloverFg = Color.red;
    public static final int HEIGHT = 45;
    private MouseListener listener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e2) {
            CollapHeaderPanel.this.titleLabel.setForeground(CollapHeaderPanel.this.rolloverFg);
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            CollapHeaderPanel.this.titleLabel.setForeground(CollapHeaderPanel.this.fontFg);
        }
    };

    public CollapHeaderPanel(int id, MouseListener ml) {
        this.id = id;
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel("Panel " + id, 0);
        this.add(this.titleLabel);
        this.titleLabel.setForeground(this.fontFg);
        Dimension d2 = this.getPreferredSize();
        d2.height = 45;
        this.setPreferredSize(d2);
        this.addMouseListener(ml);
        this.addMouseListener(this.listener);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        int w2 = this.getWidth();
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setPaint(new GradientPaint(w2 / 2, 0.0f, this.c1, w2 / 2, 22.0f, this.c2));
        g22.fillRect(0, 0, w2, 45);
    }

    public Color getGradientFromColor() {
        return this.c1;
    }

    public void setGradientFromColor(Color color) {
        this.c1 = color;
        this.repaint();
    }

    public Color getGradientToColor() {
        return this.c2;
    }

    public void setGradientToColor(Color color) {
        this.c2 = color;
        this.repaint();
    }
}

