/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.swingplus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CircularIntSpin
extends JPanel {
    private int value;
    private Integer min;
    private Integer max;
    private int interval;
    private final Timer clockTimer;
    private int y;
    private int timerCnt;
    private SpinSize size;
    private JLabel titleLabel;
    private JLabel valueLabel;

    public CircularIntSpin() {
        this.initComponents();
        this.min = null;
        this.max = null;
        this.size = SpinSize.SZ_BIG;
        this.interval = 1;
        this.timerCnt = 10;
        this.clockTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CircularIntSpin.this.timerActionPerformed(evt);
            }
        });
        this.y = 0;
    }

    public void timerActionPerformed(ActionEvent evt) {
        this.handleMouseEvent();
        if (this.timerCnt == 1) {
            this.clockTimer.setDelay(150);
        } else if (this.timerCnt > 0) {
            --this.timerCnt;
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Omnes Medium", 0, 14));
        this.titleLabel.setForeground(new Color(153, 153, 153));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("TITLE");
        this.titleLabel.setHorizontalTextPosition(0);
        this.titleLabel.setPreferredSize(new Dimension(120, 32));
        this.add((Component)this.titleLabel, "First");
        this.valueLabel.setFont(new Font("Omnes Medium", 0, 48));
        this.valueLabel.setForeground(new Color(34, 34, 34));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/control_circular.png")));
        this.valueLabel.setText("0");
        this.valueLabel.setDisabledIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/control_circular_dis.png")));
        this.valueLabel.setHorizontalTextPosition(0);
        this.valueLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                CircularIntSpin.this.valueLabelMouseDragged(evt);
            }
        });
        this.valueLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CircularIntSpin.this.valueLabelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                CircularIntSpin.this.valueLabelMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                CircularIntSpin.this.valueLabelMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CircularIntSpin.this.valueLabelMouseExited(evt);
            }
        });
        this.add((Component)this.valueLabel, "Center");
    }

    public SpinSize getIconSize() {
        return this.size;
    }

    public void setIconSize(SpinSize size) {
        this.size = size;
        if (SpinSize.SZ_BIG.equals((Object)size)) {
            this.valueLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/control_circular.png")));
        } else {
            this.valueLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/control_circular_chico.png")));
        }
    }

    public void setIconColor(SpinColor color) {
        if (SpinColor.BLUE.equals((Object)color)) {
            this.valueLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/control_circular_azul.png")));
        } else if (SpinColor.RED.equals((Object)color)) {
            this.valueLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/control_circular_rojo.png")));
        } else {
            this.valueLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/ucod/images/control_circular.png")));
        }
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            super.setFont(font);
            if (this.valueLabel != null) {
                this.valueLabel.setFont(font);
            }
        }
    }

    private void handleMouseEvent() {
        SpinButton button;
        if (!this.isEnabled()) {
            return;
        }
        int h2 = this.valueLabel.getSize().height;
        if (this.y > h2 / 2) {
            this.decValue();
            button = SpinButton.BUTTON_DOWN;
        } else {
            this.incValue();
            button = SpinButton.BUTTON_UP;
        }
        this.fireActionPerformed(button);
    }

    private void valueLabelMouseClicked(MouseEvent evt) {
        this.y = evt.getY();
        this.handleMouseEvent();
    }

    private void valueLabelMousePressed(MouseEvent evt) {
        this.y = evt.getY();
        this.clockTimer.setInitialDelay(1000);
        this.clockTimer.setDelay(300);
        this.clockTimer.start();
    }

    private void valueLabelMouseReleased(MouseEvent evt) {
        this.clockTimer.stop();
        this.timerCnt = 5;
    }

    private void valueLabelMouseExited(MouseEvent evt) {
        this.clockTimer.stop();
        this.timerCnt = 5;
    }

    private void valueLabelMouseDragged(MouseEvent evt) {
        this.y = evt.getY();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        int oldValue = this.value;
        this.value = value;
        this.valueLabel.setText(String.valueOf(value));
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        if (min == null) {
            this.min = min;
        } else if (this.max == null) {
            this.min = min;
        } else if (min <= this.max) {
            this.min = min;
        }
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        if (max == null) {
            this.max = max;
        } else if (this.min == null) {
            this.max = max;
        } else if (this.min <= max) {
            this.max = max;
        }
    }

    private void incValue() {
        int val = this.value;
        int mx = this.max != null ? this.max : Integer.MAX_VALUE;
        val = this.value > mx - this.interval ? mx : (val += this.interval);
        this.setValue(val);
    }

    private void decValue() {
        int val = this.value;
        int mn = this.min != null ? this.min : Integer.MIN_VALUE;
        val = this.value < mn + this.interval ? mn : (val -= this.interval);
        this.setValue(val);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.valueLabel.setEnabled(enable);
    }

    protected void fireActionPerformed(SpinButton button) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent event = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ActionListener.class) continue;
            if (event == null) {
                event = new ActionEvent(this, 1001, button.getValue(), new Date().getTime(), 0);
            }
            ((ActionListener)listeners[i2 + 1]).actionPerformed(event);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public static enum SpinSize {
        SZ_SMALL{

            @Override
            public String getValue() {
                return "small";
            }
        }
        ,
        SZ_BIG{

            @Override
            public String getValue() {
                return "big";
            }
        };


        public abstract String getValue();
    }

    public static enum SpinButton {
        BUTTON_UP{

            @Override
            public String getValue() {
                return "up";
            }
        }
        ,
        BUTTON_DOWN{

            @Override
            public String getValue() {
                return "down";
            }
        };


        public abstract String getValue();
    }

    public static enum SpinColor {
        RED,
        BLUE,
        LBLUE;

    }
}

