/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.lang;

import com.ucod.lang.LocaleChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocaleUtil {
    private static Locale currentLocale;
    private static List<Locale> supportedLocales;
    private static List<LocaleChangeListener> localeChangeListeners;
    private static ResourceBundle messages;
    private static String resourceBundleName;

    public LocaleUtil(Locale[] supportedLocales, String resourceBundleName) {
        localeChangeListeners = new LinkedList<LocaleChangeListener>();
        LocaleUtil.supportedLocales = new ArrayList<Locale>();
        LocaleUtil.resourceBundleName = resourceBundleName;
        if (supportedLocales == null) {
            throw new NullPointerException();
        }
        LocaleUtil.supportedLocales.addAll(Arrays.asList(supportedLocales));
        LocaleUtil.setPrivCurrentLocaleByIndex(0);
    }

    public static ResourceBundle getMessages() {
        return messages;
    }

    public static String getMessage(String key) {
        if (key == null) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message key can not be null");
            return "";
        }
        if (messages == null) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Messages Object is null");
            return "";
        }
        try {
            return messages.getString(key);
        }
        catch (MissingResourceException ex) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message String '".concat(key).concat("' not found"), ex);
            return "";
        }
        catch (ClassCastException ex) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message with key '".concat(key).concat("' is not a String"), ex);
            return "";
        }
    }

    public static Object getObject(String key) {
        if (key == null) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message key can not be null");
            return "";
        }
        if (messages == null) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Messages Object is null");
            return "";
        }
        try {
            return messages.getObject(key);
        }
        catch (MissingResourceException ex) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message String '".concat(key).concat("' not found"), ex);
            return "";
        }
    }

    public static String[] getStringArray(String key) {
        if (key == null) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message key can not be null");
        } else if (messages == null) {
            Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Messages Object is null");
        } else {
            try {
                return messages.getStringArray(key);
            }
            catch (MissingResourceException ex) {
                Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message String '".concat(key).concat("' not found"), ex);
            }
            catch (ClassCastException ex) {
                Logger.getLogger(LocaleUtil.class.getName()).log(Level.WARNING, "Message with key '".concat(key).concat("' is not a String Array"), ex);
            }
        }
        return new String[0];
    }

    private static void setPrivCurrentLocaleByIndex(int index) {
        if (index >= 0 || index < supportedLocales.size()) {
            Locale oldLocale = currentLocale;
            currentLocale = supportedLocales.get(index);
            messages = ResourceBundle.getBundle(resourceBundleName, currentLocale);
            LocaleUtil.fireLocaleChangeEvent(oldLocale, currentLocale);
        }
    }

    public static void setCurrentLocaleByIndex(int index) {
        LocaleUtil.setPrivCurrentLocaleByIndex(index);
    }

    public static void setCurrentLocale(Locale locale) {
        if (locale != null) {
            LocaleUtil.setPrivCurrentLocaleByIndex(supportedLocales.indexOf(locale));
        }
    }

    public static int getCurrentLocaleIndex() {
        if (currentLocale != null) {
            return supportedLocales.indexOf(currentLocale);
        }
        return -1;
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static synchronized Locale[] getSupportedLocales() {
        return supportedLocales.toArray(new Locale[0]);
    }

    public static String[] getLangNames() {
        ArrayList names = new ArrayList();
        supportedLocales.stream().forEach(supportedLocale -> {
            if (supportedLocale.getLanguage().equals(new Locale("es").getLanguage())) {
                names.add("Espa\u00f1ol");
            } else if (supportedLocale.getLanguage().equals(new Locale("en").getLanguage())) {
                names.add("English");
            } else if (supportedLocale.getLanguage().equals(new Locale("pt").getLanguage())) {
                names.add("Portugu\u00eas");
            }
        });
        return names.toArray(new String[0]);
    }

    public static synchronized void addLocaleChangeListener(LocaleChangeListener l2) {
        if (l2 == null) {
            return;
        }
        localeChangeListeners.add(l2);
    }

    public static synchronized void removeLocaleChangeListener(LocaleChangeListener l2) {
        if (l2 == null) {
            return;
        }
        localeChangeListeners.remove(l2);
    }

    public static synchronized LocaleChangeListener[] getLocaleChangeListeners() {
        return localeChangeListeners.toArray(new LocaleChangeListener[0]);
    }

    private static void fireLocaleChangeEvent(Locale oldLocale, Locale newLocale) {
        LocaleChangeListener[] listeners;
        for (LocaleChangeListener listener : listeners = LocaleUtil.getLocaleChangeListeners()) {
            if (listener == null) continue;
            listener.localeChanged(oldLocale, newLocale);
        }
    }
}

