/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.FlatLookAndFeel;

import com.ucod.FlatLookAndFeel.UpperBorders;
import com.ucod.FlatLookAndFeel.UpperEssentialLookAndFeel;
import com.ucod.FlatLookAndFeel.g;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class UpperToggleButtonUI
extends MetalToggleButtonUI {
    protected MiListener miml;
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent jComponent) {
        return new UpperToggleButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setBorder(null);
        abstractButton.setForeground(UpperEssentialLookAndFeel.getBlack());
        this.selectColor = UpperEssentialLookAndFeel.getFocusColor();
    }

    @Override
    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setBorder(MetalBorders.getButtonBorder());
    }

    @Override
    public void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        this.miml = new MiListener(this, abstractButton);
        abstractButton.addMouseListener(this.miml);
        abstractButton.addPropertyChangeListener(this.miml);
        abstractButton.addFocusListener(this.miml);
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        abstractButton.removeMouseListener(this.miml);
        abstractButton.removePropertyChangeListener(this.miml);
        abstractButton.removeFocusListener(this.miml);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.oldOpaque = jComponent.isOpaque();
        if (jComponent.getParent() instanceof JToolBar) {
            jComponent.setOpaque(false);
            jComponent.setBorder(UpperBorders.getSplitPaneBorder());
            jComponent.setPreferredSize(new Dimension(150, jComponent.getHeight()));
            super.update(graphics, jComponent);
            return;
        }
        jComponent.setOpaque(false);
        super.update(graphics, jComponent);
        jComponent.setOpaque(this.oldOpaque);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton serializable) {
        if (!this.oldOpaque) {
            return;
        }
        if (serializable.isContentAreaFilled()) {
            graphics = (Graphics2D)graphics;
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(g.a((Color)UpperEssentialLookAndFeel.getPrimaryControlShadow(), 100));
            serializable = UpperToggleButtonUI.a(serializable);
            ((Graphics2D)graphics).fill((Shape)((Object)serializable));
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (!abstractButton.isFocusPainted() || !this.oldOpaque) {
            return;
        }
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        g.a(graphics, 3, 3, abstractButton.getWidth() - 6, abstractButton.getHeight() - 6, 2, 2, UpperEssentialLookAndFeel.getFocusColor());
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ButtonModel buttonModel = ((AbstractButton)jComponent).getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Float float_ = UpperToggleButtonUI.a(jComponent);
        if (jComponent.getParent() instanceof JToolBar) {
            if (buttonModel.isRollover() || buttonModel.isPressed() || buttonModel.isSelected()) {
                graphics2D.setColor(UpperEssentialLookAndFeel.getPrimaryControl());
                graphics2D.fill(float_);
                jComponent.setBorder(UpperBorders.getButtonBorder());
            }
            if (buttonModel.isPressed() || buttonModel.isSelected()) {
                graphics2D.setColor(UpperEssentialLookAndFeel.getControlDarkShadow());
                graphics2D.fill(float_);
            }
        }
        if (this.oldOpaque) {
            graphics2D.clip(float_);
            graphics2D.setColor(UpperEssentialLookAndFeel.getControl());
            graphics2D.fill(float_);
            GradientPaint gradientPaint = buttonModel.isPressed() || buttonModel.isSelected() ? new GradientPaint(0.0f, 0.0f, g.a(), 0.0f, jComponent.getHeight(), g.b()) : new GradientPaint(0.0f, 0.0f, g.b(), 0.0f, jComponent.getHeight(), g.a());
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(float_);
            if (buttonModel.isRollover()) {
                graphics2D.setColor(g.c());
                graphics2D.fill(float_);
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        super.paint(graphics, jComponent);
    }

    private static RoundRectangle2D.Float a(JComponent jComponent) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float();
        new RoundRectangle2D.Float().x = 0.0f;
        float_.y = 0.0f;
        float_.width = jComponent.getWidth() - 2;
        float_.height = jComponent.getHeight();
        float_.arcwidth = 0.0f;
        float_.archeight = 0.0f;
        return float_;
    }

    public class MiListener
    extends MouseInputAdapter
    implements FocusListener,
    PropertyChangeListener {
        private AbstractButton a;
        private /* synthetic */ UpperToggleButtonUI b;

        MiListener(UpperToggleButtonUI upperToggleButtonUI, AbstractButton abstractButton) {
            this.b = upperToggleButtonUI;
            this.a = abstractButton;
        }

        public void refresh() {
            if (this.a != null && this.a.getParent() != null) {
                this.a.getParent().repaint(this.a.getX() - 5, this.a.getY() - 5, this.a.getWidth() + 10, this.a.getHeight() + 10);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.a.getModel().setRollover(true);
            this.refresh();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.a.getModel().setRollover(false);
            this.refresh();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.a.getModel().setRollover(false);
            this.refresh();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.a.getModel().setRollover(false);
            this.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.refresh();
        }
    }
}

