/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import com.sun.mail.util.LogOutputStream;
import com.sun.mail.util.MailLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

public class TraceInputStream
extends FilterInputStream {
    private boolean trace = false;
    private boolean quote = false;
    private OutputStream traceOut;

    public TraceInputStream(InputStream in, MailLogger logger) {
        super(in);
        this.trace = logger.isLoggable(Level.FINEST);
        this.traceOut = new LogOutputStream(logger);
    }

    public TraceInputStream(InputStream in, OutputStream traceOut) {
        super(in);
        this.traceOut = traceOut;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setQuote(boolean quote) {
        this.quote = quote;
    }

    @Override
    public int read() throws IOException {
        int b2 = this.in.read();
        if (this.trace && b2 != -1) {
            if (this.quote) {
                this.writeByte(b2);
            } else {
                this.traceOut.write(b2);
            }
        }
        return b2;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int count = this.in.read(b2, off, len);
        if (this.trace && count != -1) {
            if (this.quote) {
                for (int i2 = 0; i2 < count; ++i2) {
                    this.writeByte(b2[off + i2]);
                }
            } else {
                this.traceOut.write(b2, off, count);
            }
        }
        return count;
    }

    private final void writeByte(int b2) throws IOException {
        if ((b2 &= 0xFF) > 127) {
            this.traceOut.write(77);
            this.traceOut.write(45);
            b2 &= 0x7F;
        }
        if (b2 == 13) {
            this.traceOut.write(92);
            this.traceOut.write(114);
        } else if (b2 == 10) {
            this.traceOut.write(92);
            this.traceOut.write(110);
            this.traceOut.write(10);
        } else if (b2 == 9) {
            this.traceOut.write(92);
            this.traceOut.write(116);
        } else if (b2 < 32) {
            this.traceOut.write(94);
            this.traceOut.write(64 + b2);
        } else {
            this.traceOut.write(b2);
        }
    }
}

