/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import java.util.ArrayList;

public class MessageSet {
    public int start;
    public int end;

    public MessageSet() {
    }

    public MessageSet(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int size() {
        return this.end - this.start + 1;
    }

    public static MessageSet[] createMessageSets(int[] msgs) {
        ArrayList<MessageSet> v2 = new ArrayList<MessageSet>();
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            int j2;
            MessageSet ms = new MessageSet();
            ms.start = msgs[i2];
            for (j2 = i2 + 1; j2 < msgs.length && msgs[j2] == msgs[j2 - 1] + 1; ++j2) {
            }
            ms.end = msgs[j2 - 1];
            v2.add(ms);
            i2 = j2 - 1;
        }
        return v2.toArray(new MessageSet[v2.size()]);
    }

    public static String toString(MessageSet[] msgsets) {
        if (msgsets == null || msgsets.length == 0) {
            return null;
        }
        int i2 = 0;
        StringBuilder s2 = new StringBuilder();
        int size = msgsets.length;
        while (true) {
            int start;
            int end;
            if ((end = msgsets[i2].end) > (start = msgsets[i2].start)) {
                s2.append(start).append(':').append(end);
            } else {
                s2.append(start);
            }
            if (++i2 >= size) break;
            s2.append(',');
        }
        return s2.toString();
    }

    public static int size(MessageSet[] msgsets) {
        int count = 0;
        if (msgsets == null) {
            return 0;
        }
        for (int i2 = 0; i2 < msgsets.length; ++i2) {
            count += msgsets[i2].size();
        }
        return count;
    }
}

