/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.ResyncData;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.UIDSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.mail.Message;

public final class Utility {
    private Utility() {
    }

    public static MessageSet[] toMessageSet(Message[] msgs, Condition cond) {
        ArrayList<MessageSet> v2 = new ArrayList<MessageSet>(1);
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            IMAPMessage msg = (IMAPMessage)msgs[i2];
            if (msg.isExpunged()) continue;
            int current = msg.getSequenceNumber();
            if (cond != null && !cond.test(msg)) continue;
            MessageSet set = new MessageSet();
            set.start = current;
            ++i2;
            while (i2 < msgs.length) {
                msg = (IMAPMessage)msgs[i2];
                if (!msg.isExpunged()) {
                    int next = msg.getSequenceNumber();
                    if (cond == null || cond.test(msg)) {
                        if (next == current + 1) {
                            current = next;
                        } else {
                            --i2;
                            break;
                        }
                    }
                }
                ++i2;
            }
            set.end = current;
            v2.add(set);
        }
        if (v2.isEmpty()) {
            return null;
        }
        return v2.toArray(new MessageSet[v2.size()]);
    }

    public static MessageSet[] toMessageSetSorted(Message[] msgs, Condition cond) {
        msgs = (Message[])msgs.clone();
        Arrays.sort(msgs, new Comparator<Message>(){

            @Override
            public int compare(Message msg1, Message msg2) {
                return msg1.getMessageNumber() - msg2.getMessageNumber();
            }
        });
        return Utility.toMessageSet(msgs, cond);
    }

    public static UIDSet[] toUIDSet(Message[] msgs) {
        ArrayList<UIDSet> v2 = new ArrayList<UIDSet>(1);
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            IMAPMessage msg = (IMAPMessage)msgs[i2];
            if (msg.isExpunged()) continue;
            long current = msg.getUID();
            UIDSet set = new UIDSet();
            set.start = current;
            ++i2;
            while (i2 < msgs.length) {
                msg = (IMAPMessage)msgs[i2];
                if (!msg.isExpunged()) {
                    long next = msg.getUID();
                    if (next == current + 1L) {
                        current = next;
                    } else {
                        --i2;
                        break;
                    }
                }
                ++i2;
            }
            set.end = current;
            v2.add(set);
        }
        if (v2.isEmpty()) {
            return null;
        }
        return v2.toArray(new UIDSet[v2.size()]);
    }

    public static UIDSet[] getResyncUIDSet(ResyncData rd) {
        return rd.getUIDSet();
    }

    public static interface Condition {
        public boolean test(IMAPMessage var1);
    }
}

