/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import java.io.IOException;
import java.io.OutputStream;

class LengthCounter
extends OutputStream {
    private int size = 0;
    private byte[] buf = new byte[8192];
    private int maxsize;

    public LengthCounter(int maxsize) {
        this.maxsize = maxsize;
    }

    @Override
    public void write(int b2) {
        int newsize = this.size + 1;
        if (this.buf != null) {
            if (newsize > this.maxsize && this.maxsize >= 0) {
                this.buf = null;
            } else if (newsize > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newsize)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.size);
                this.buf = newbuf;
                this.buf[this.size] = (byte)b2;
            } else {
                this.buf[this.size] = (byte)b2;
            }
        }
        this.size = newsize;
    }

    @Override
    public void write(byte[] b2, int off, int len) {
        if (off < 0 || off > b2.length || len < 0 || off + len > b2.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newsize = this.size + len;
        if (this.buf != null) {
            if (newsize > this.maxsize && this.maxsize >= 0) {
                this.buf = null;
            } else if (newsize > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newsize)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.size);
                this.buf = newbuf;
                System.arraycopy(b2, off, this.buf, this.size, len);
            } else {
                System.arraycopy(b2, off, this.buf, this.size, len);
            }
        }
        this.size = newsize;
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBytes() {
        return this.buf;
    }
}

